/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species.exception;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.species.exception.IacucProtocolExceptionService;
import org.kuali.kra.iacuc.species.exception.rule.AddProtocolExceptionEvent;

public class IacucProtocolExceptionAction
extends IacucProtocolAction {
    private static final String CONFIRM_DELETE_PROTOCOL_EXCEPTION_KEY = "confirmDeleteProtocolException";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getIacucProtocolExceptionHelper().prepareView();
        return forward;
    }

    public ActionForward addProtocolException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolException iacucProtocolException;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        if (this.applyRules(new AddProtocolExceptionEvent("", document, iacucProtocolException = protocolForm.getIacucProtocolExceptionHelper().getNewIacucProtocolException()))) {
            this.getIacucProtocolExceptionService().addProtocolException(document.getIacucProtocol(), iacucProtocolException);
            protocolForm.getIacucProtocolExceptionHelper().setNewIacucProtocolException(new IacucProtocolException());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_EXCEPTION_KEY, "question.iacuc.protocol.exception.delete.confirmation", new String[0]), CONFIRM_DELETE_PROTOCOL_EXCEPTION_KEY, "");
    }

    public ActionForward confirmDeleteProtocolException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_EXCEPTION_KEY.equals(question)) {
            IacucProtocolForm protocolForm = (IacucProtocolForm)form;
            IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
            document.getIacucProtocol().getIacucProtocolExceptions().remove(this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    protected IacucProtocolExceptionService getIacucProtocolExceptionService() {
        return (IacucProtocolExceptionService)KcServiceLocator.getService("iacucProtocolExceptionService");
    }
}

