/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.print.BudgetBaseStream;
import org.kuali.coeus.common.budget.impl.print.ReportTypeVO;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.printing.schema.BudgetSummaryReportDocument;
import org.kuali.kra.printing.schema.ReportHeaderType;
import org.kuali.kra.printing.schema.ReportPageType;
import org.kuali.kra.printing.schema.ReportType;
import org.kuali.kra.printing.schema.SubReportType;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="budgetCumilativeXmlStream")
@Scope(value="prototype")
public class BudgetCumilativeXmlStream
extends BudgetBaseStream<BudgetSummaryReportDocument> {
    private static final String CUMULATIVE_BUDGET = "Cumulative Budget";

    @Override
    public Class<BudgetSummaryReportDocument> type() {
        return BudgetSummaryReportDocument.class;
    }

    @Override
    public Map<String, BudgetSummaryReportDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, BudgetSummaryReportDocument> xmlObjectList = new LinkedHashMap<String, BudgetSummaryReportDocument>();
        this.budget = (Budget)printableBusinessObject;
        if (this.budget != null) {
            BudgetSummaryReportDocument budgetSummaryReportDocument = BudgetSummaryReportDocument.Factory.newInstance();
            BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = this.getBudgetCumulativeReport();
            budgetSummaryReportDocument.setBudgetSummaryReport(budgetSummaryReport);
            xmlObjectList.put(CUMULATIVE_BUDGET, budgetSummaryReportDocument);
        }
        return xmlObjectList;
    }

    private BudgetSummaryReportDocument.BudgetSummaryReport getBudgetCumulativeReport() {
        BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
        BudgetParent budgetParent = this.budget.getBudgetParent();
        ReportHeaderType reportHeaderType = this.getReportHeaderTypeForCumulativeReport(budgetParent);
        budgetSummaryReport.setReportHeader(reportHeaderType);
        ReportPageType cumulativePageType = this.getCumulativeBudgetReportPageType();
        budgetSummaryReport.setCumilativePage(cumulativePageType);
        ReportPageType[] reportPageTypeList = new ReportPageType[]{cumulativePageType};
        budgetSummaryReport.setReportPageArray(reportPageTypeList);
        return budgetSummaryReport;
    }

    @Override
    protected ReportHeaderType getReportHeaderTypeForCumulativeReport(BudgetParent budgetParent) {
        String principleInvestigatorName;
        ReportHeaderType reportHeaderType = ReportHeaderType.Factory.newInstance();
        if (budgetParent != null) {
            reportHeaderType.setParentTypeName(budgetParent.getParentTypeName());
            reportHeaderType.setProposalNumber(budgetParent.getParentNumber());
        }
        if (budgetParent != null && budgetParent.getParentTitle() != null) {
            reportHeaderType.setProposalTitle(budgetParent.getParentTitle());
        }
        if ((principleInvestigatorName = budgetParent.getParentPIName()) != null) {
            reportHeaderType.setPIName(principleInvestigatorName);
        }
        if (this.budget.getVersionNumber() != null) {
            reportHeaderType.setBudgetVersion(this.budget.getBudgetVersionNumber());
        }
        if (this.budget.getStartDate() != null) {
            reportHeaderType.setPeriodStartDate(DateFormatUtils.format((Date)this.budget.getStartDate(), (String)"dd MMM yyyy"));
        }
        if (this.budget.getEndDate() != null) {
            reportHeaderType.setPeriodEndDate(DateFormatUtils.format((Date)this.budget.getEndDate(), (String)"dd MMM yyyy"));
        }
        reportHeaderType.setCreateDate(this.dateTimeService.getCurrentDate().toString());
        if (this.budget.getComments() != null && this.budget.getPrintBudgetCommentFlag() != null && this.budget.getPrintBudgetCommentFlag().equals("true")) {
            reportHeaderType.setComments(this.budget.getComments());
        }
        this.budget.setPrintBudgetCommentFlag(null);
        return reportHeaderType;
    }

    private ReportPageType getCumulativeBudgetReportPageType() {
        ReportPageType reportPageType = ReportPageType.Factory.newInstance();
        ReportPageType.BudgetSummary budgetSummary = this.getCumulativeBudget();
        ReportPageType.CalculationMethodology calculationMethodology = this.getCumulativeCalculationMethodology();
        reportPageType.setBudgetSummary(budgetSummary);
        reportPageType.setCalculationMethodology(calculationMethodology);
        reportPageType.setPeriod(this.budgetPeriod.getBudgetPeriod());
        return reportPageType;
    }

    private ReportPageType.BudgetSummary getCumulativeBudget() {
        ReportPageType.BudgetSummary budgetSummary = ReportPageType.BudgetSummary.Factory.newInstance();
        SubReportType subReportType = this.getCumulativeSalarySummary();
        budgetSummary.setSalarySummaryFromEDI(subReportType);
        subReportType = this.getBudgetCumulativeSummaryNonPersonnel();
        budgetSummary.setBudgetSummaryNonPersonnel(subReportType);
        subReportType = this.getBudgetCumulativeIDCForReport();
        budgetSummary.setBudgetIndirectCostsForReport(subReportType);
        budgetSummary.setTotalDirectCost(this.budget.getTotalDirectCost().doubleValue());
        budgetSummary.setTotalCostToSponsor(this.budget.getTotalCost().doubleValue());
        budgetSummary.setTotalUnderrecoveryAmount(this.budget.getUnderrecoveryAmount().doubleValue());
        budgetSummary.setTotalCostSharingAmount(this.budget.getCostSharingAmount().doubleValue());
        return budgetSummary;
    }

    private ReportPageType.CalculationMethodology getCumulativeCalculationMethodology() {
        ReportPageType.CalculationMethodology calculationMethodology = ReportPageType.CalculationMethodology.Factory.newInstance();
        SubReportType subReportType = this.getCumulativeBudgetOHExclusions();
        calculationMethodology.setBudgetOHExclusions(subReportType);
        subReportType = this.getCumulativeBudgetLAExclusions();
        calculationMethodology.setBudgetLAExclusions(subReportType);
        subReportType = this.getCumulativeBudgetOHRateBase();
        calculationMethodology.setBudgetOHRateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetEBRateBase();
        calculationMethodology.setBudgetEBRateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetLARateBase();
        calculationMethodology.setBudgetLARateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetVacRateBase();
        calculationMethodology.setBudgetVacRateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetOtherRateBase();
        calculationMethodology.setBudgetOtherRateBaseForPeriod(subReportType);
        return calculationMethodology;
    }

    private SubReportType getCumulativeSalarySummary() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        this.setReportTypeForCumulativeBudgetSalary(reportTypeList);
        this.setBudgetLASalaryForBudgetRateAndBaseForCumulativeReport(reportTypeList);
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    protected void setBudgetLASalaryForBudgetRateAndBaseForCumulativeReport(List<ReportType> reportTypeList) {
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            this.setBudgetLASalaryForBudgetRateAndBase(reportTypeList, new ArrayList<ReportTypeVO>());
        }
    }

    protected void setReportTypeForCumulativeBudgetSalary(List<ReportType> reportTypeList) {
        ArrayList<ReportTypeVO> reportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            reportTypeVOList.addAll(this.getReportTypeVOList(budgetPeriod));
        }
        reportTypeVOList.sort(Comparator.comparing(ReportTypeVO::getBudgetCategoryCode));
        this.setReportTypeListFromReportTypeVoListForCumulativeBudgetSalary(reportTypeList, reportTypeVOList);
    }

    private void setReportTypeListFromReportTypeVoListForCumulativeBudgetSalary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String cumulativeBudgetSalaryKey = this.getKeyForBudgetSalarySummary(reportTypeVO);
            if (reportTypeMap.containsKey(cumulativeBudgetSalaryKey)) continue;
            ScaleTwoDecimal vacationRate = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal empBenefitRate = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String cumulativeBudgetSalaryTempKey = this.getKeyForBudgetSalarySummary(tempReportTypeVO);
                if (!cumulativeBudgetSalaryTempKey.equals(cumulativeBudgetSalaryKey)) continue;
                if (vacationRate.isLessThan((AbstractDecimal)tempReportTypeVO.getVacationRate())) {
                    vacationRate = tempReportTypeVO.getVacationRate();
                }
                if (empBenefitRate.isLessThan((AbstractDecimal)tempReportTypeVO.getEmployeeBenefitRate())) {
                    empBenefitRate = tempReportTypeVO.getEmployeeBenefitRate();
                }
                fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)tempReportTypeVO.getFringe());
            }
            ReportType reportType = this.getReportTypeForCumulativeBudgetSalary(vacationRate, empBenefitRate, fringe, reportTypeVO);
            reportTypeMap.put(cumulativeBudgetSalaryKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForCumulativeBudgetSalary(ScaleTwoDecimal vacationRate, ScaleTwoDecimal empBenefitRate, ScaleTwoDecimal fringe, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setStartDate(reportTypeVO.getStartDate().toString());
        reportType.setEndDate(reportTypeVO.getEndDate().toString());
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setPersonName(reportTypeVO.getPersonName());
        reportType.setVacationRate(vacationRate.toString().concat("%"));
        reportType.setEmployeeBenefitRate(empBenefitRate.toString().concat("%"));
        reportType.setFringe(fringe.doubleValue());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setInvestigatorFlag(reportTypeVO.getInvestigatorFlag());
        if (reportTypeVO.getBudgetCategoryCode() != null) {
            reportType.setBudgetCategoryCode(Integer.parseInt(reportTypeVO.getBudgetCategoryCode()));
        }
        reportType.setSalaryRequested(reportTypeVO.getSalaryRequested().doubleValue());
        return reportType;
    }

    private SubReportType getBudgetCumulativeSummaryNonPersonnel() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.LAB_ALLOCATION.getRateClassType(), budgetLineItem));
            }
        }
        ReportType reportType = this.getReportTypeForNonPersonnel("Other Direct Costs", "Allocated Lab Expense", calculatedCost, null);
        if (calculatedCost.doubleValue() > 0.0) {
            reportTypeList.add(reportType);
        }
        this.setReportTypeForBudgetCumulativeNonPersonnel(reportTypeList);
        reportTypeList.sort(Comparator.comparing(ReportType::getBudgetCategoryDescription));
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForBudgetCumulativeNonPersonnel(List<ReportType> reportTypeList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        ArrayList<Object> tempReportTypeVOList = new ArrayList<Object>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
                ReportTypeVO tempReportTypeVO = this.getReportTypeVOForBudgetCumulativeNonPersonnel(budgetLineItem);
                tempReportTypeVOList.add(tempReportTypeVO);
            }
        }
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String cumulativeNonPersKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(cumulativeNonPersKey)) continue;
            ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO reportTypeVO2 : tempReportTypeVOList) {
                String cumulativeNonPersTempKey = reportTypeVO2.getCostElementDesc();
                if (!cumulativeNonPersTempKey.equals(cumulativeNonPersKey)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)reportTypeVO2.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForBudgetCumulativeNonPersonnel(calculatedCost, reportTypeVO);
            reportTypeMap.put(cumulativeNonPersKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForBudgetCumulativeNonPersonnel(ScaleTwoDecimal calculatedCost, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        return reportType;
    }

    private ReportTypeVO getReportTypeVOForBudgetCumulativeNonPersonnel(BudgetLineItem budgetLineItem) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setBudgetCategoryDesc(budgetLineItem.getBudgetCategory().getDescription());
        reportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
        reportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
        return reportTypeVO;
    }

    private SubReportType getBudgetCumulativeIDCForReport() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        ScaleTwoDecimal calculatedCostForOn = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCostForOff = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getOnOffCampusFlag().booleanValue()) {
                    calculatedCostForOn = (ScaleTwoDecimal)calculatedCostForOn.add((AbstractDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.OVERHEAD.getRateClassType(), budgetLineItem));
                    continue;
                }
                calculatedCostForOff = (ScaleTwoDecimal)calculatedCostForOff.add((AbstractDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.OVERHEAD.getRateClassType(), budgetLineItem));
            }
        }
        if (!calculatedCostForOn.equals((Object)ScaleTwoDecimal.ZERO)) {
            ReportType reportTypeForOn = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.TRUE, calculatedCostForOn, null);
            reportTypeList.add(reportTypeForOn);
        }
        if (!calculatedCostForOff.equals((Object)ScaleTwoDecimal.ZERO)) {
            ReportType reportTypeForOff = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.FALSE, calculatedCostForOff, null);
            reportTypeList.add(reportTypeForOff);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetOHExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        if (this.budgetHasLineItemsWithLaRates()) {
            int sortId = 1;
            String categoryDesc = "Allocated Administrative Support";
            ScaleTwoDecimal calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1ForCumulativeReport();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = "Employee Benefits on Allocated Administrative Support";
            calculatedCost = this.getCalculatedCostForBudgetOHExclusionsSortId2ForCumulativeReport();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            sortId = 3;
            this.setReportTypeOHExclusionForSortIdForCumulativeReport(reportTypeList, sortId);
            sortId = 4;
            categoryDesc = "Allocated Lab Expense";
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4ForCumulativeReport();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            if (calculatedCost.doubleValue() > 0.0) {
                reportTypeList.add(reportTypeForSortId4);
            }
        } else {
            int sortId = 1;
            this.setReportTypeOHExclusionForSortId(reportTypeList, sortId);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    @Override
    protected void setReportTypeOHExclusionForSortId(List<ReportType> reportTypeList, int sortId) {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            this.setReportTypeVOListForOHExclusionSortId(tempReportTypeVOList);
        }
        this.setReportTypeListOHExclusionForSortId(reportTypeList, sortId, tempReportTypeVOList);
    }

    private ScaleTwoDecimal getCalculatedCostForBudgetExclusionsSortId4ForCumulativeReport() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)this.getCalculatedCostForBudgetExclusionsSortId4());
        }
        return calculatedCost;
    }

    private void setReportTypeOHExclusionForSortIdForCumulativeReport(List<ReportType> reportTypeList, int sortId) {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            this.setReportTypeVOListForOHExclusionSortId(tempReportTypeVOList);
        }
        this.setReportTypeListOHExclusionForSortId(reportTypeList, sortId, tempReportTypeVOList);
    }

    private ScaleTwoDecimal getCalculatedCostForBudgetOHExclusionsSortId2ForCumulativeReport() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)this.getCalculatedCostForBudgetOHExclusionsSortId2());
        }
        return calculatedCost;
    }

    private ScaleTwoDecimal getCalculatedCostForBudgetExclusionsSortId1ForCumulativeReport() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)this.getCalculatedCostForBudgetExclusionsSortId1());
        }
        return calculatedCost;
    }

    private SubReportType getCumulativeBudgetLAExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        if (this.budgetHasLineItemsWithLaRates()) {
            int sortId = 1;
            String categoryDesc = "Allocated Administrative Support";
            ScaleTwoDecimal calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1ForCumulativeReport();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = "Total Employee Benefits";
            calculatedCost = this.getCalculatedCostForBudgetLAExclusionsSortId2ForCumulativeReport();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            this.setReportTypeForBudgetLAExclusionsSortId3ForCumulativeReport(reportTypeList);
            sortId = 4;
            categoryDesc = "Allocated Lab Expense";
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4ForCumulativeReport();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            if (calculatedCost.doubleValue() > 0.0) {
                reportTypeList.add(reportTypeForSortId4);
            }
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private void setReportTypeForBudgetLAExclusionsSortId3ForCumulativeReport(List<ReportType> reportTypeList) {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            this.setReportTypeVOListForLAExclusionSortId3(tempReportTypeVOList);
        }
        this.setReportTypeList(reportTypeList, tempReportTypeVOList);
    }

    private ScaleTwoDecimal getCalculatedCostForBudgetLAExclusionsSortId2ForCumulativeReport() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        Iterator<BudgetPeriod> iterator = this.budget.getBudgetPeriods().iterator();
        while (iterator.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = iterator.next();
            calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)this.getCalculatedCostForBudgetLAExclusionsSortId2());
        }
        return calculatedCost;
    }

    private SubReportType getCumulativeBudgetOHRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem);
                if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem);
            }
        }
        this.setReportTypeMapForBudgetOHRateAndBase(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetEBRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem);
                if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem);
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetLARateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem);
                if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem);
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetVacRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem);
                if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem);
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetOtherRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem);
                if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem);
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }
}

