/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.personnel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.DateSortable;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.AppointmentType;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonSalaryDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.JobCode;
import org.kuali.coeus.common.budget.framework.personnel.JobCodeService;
import org.kuali.coeus.common.budget.framework.personnel.TbnPerson;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsorable;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="BUDGET_PERSONS")
public class BudgetPerson
extends KcPersistableBusinessObjectBase
implements PersonRolodex,
HierarchyMaintainable,
DateSortable,
BudgetPersonContract {
    private static final String BUDGET_PERSON_GROUP_OTHER = "Other Personnel";
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PERSON_SEQUENCE_NUMBER")
    private Integer personSequenceNumber;
    @Id
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    private Budget budget;
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @Column(name="EFFECTIVE_DATE")
    private Date effectiveDate;
    @Column(name="JOB_CODE")
    private String jobCode;
    @Column(name="NON_EMPLOYEE_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean nonEmployeeFlag;
    @Column(name="PERSON_ID")
    private String personId;
    @Column(name="ROLODEX_ID")
    private Integer rolodexId;
    @Column(name="TBN_ID")
    private String tbnId;
    @Column(name="APPOINTMENT_TYPE_CODE")
    private String appointmentTypeCode;
    @Column(name="CALCULATION_BASE")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal calculationBase;
    @Column(name="PERSON_NAME")
    private String personName;
    @Column(name="SALARY_ANNIVERSARY_DATE")
    private Date salaryAnniversaryDate;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="HIERARCHY_PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER", insertable=false, updatable=false)
    private DevelopmentProposal hierarchyProposal;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="JOB_CODE", referencedColumnName="JOB_CODE", insertable=false, updatable=false)
    private JobCode jobCodeRef;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="APPOINTMENT_TYPE_CODE", referencedColumnName="APPOINTMENT_TYPE_CODE", insertable=false, updatable=false)
    private AppointmentType appointmentType;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="ROLODEX_ID", referencedColumnName="ROLODEX_ID", insertable=false, updatable=false)
    private Rolodex rolodex;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TBN_ID", referencedColumnName="TBN_ID", insertable=false, updatable=false)
    private TbnPerson tbnPerson;
    @OneToMany(mappedBy="budgetPerson", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails;
    @Transient
    private String role;
    @Transient
    private boolean selected;
    @Transient
    private String userName;
    @Transient
    private String emailAddress;
    @Transient
    private Unit unit;
    @Transient
    private String organization;
    @Transient
    private String city;
    @Transient
    private PersonRolodex personRolodex;
    @Transient
    private String contactRoleCode;
    @Transient
    private transient KcPersonService kcPersonService;
    @Transient
    private transient BudgetPersonService budgetPersonService;
    @Transient
    private BudgetPersonSalaryDetails personSalaryDetails;
    @Transient
    private transient DataObjectService dataObjectService;

    public BudgetPerson() {
        this.budgetPersonSalaryDetails = new ArrayList<BudgetPersonSalaryDetails>();
        this.personSalaryDetails = new BudgetPersonSalaryDetails();
    }

    public BudgetPerson(KcPerson person) {
        this.personId = person.getPersonId();
        this.personName = person.getFullName();
        this.salaryAnniversaryDate = person.getExtendedAttributes().getSalaryAnniversaryDate();
        this.nonEmployeeFlag = false;
        this.userName = person.getUserName();
        this.emailAddress = person.getEmailAddress();
        this.unit = person.getUnit();
    }

    public BudgetPerson(Rolodex rolodex) {
        this.rolodexId = rolodex.getRolodexId();
        this.personName = rolodex.getFirstName() + " " + rolodex.getLastName();
        this.nonEmployeeFlag = true;
        this.organization = rolodex.getOrganization();
        this.emailAddress = rolodex.getEmailAddress();
        this.city = rolodex.getCity();
    }

    public BudgetPerson(TbnPerson tbn) {
        this.tbnId = tbn.getTbnId();
        this.personName = tbn.getPersonName();
        this.nonEmployeeFlag = true;
        this.jobCode = tbn.getJobCode();
    }

    public BudgetPerson(PersonRolodex proposalPerson) {
        if (proposalPerson.getPersonId() != null) {
            this.personId = proposalPerson.getPersonId();
            this.nonEmployeeFlag = false;
        } else {
            this.rolodexId = proposalPerson.getRolodexId();
            this.nonEmployeeFlag = true;
        }
        this.personName = proposalPerson.getFullName();
    }

    public List<BudgetPersonSalaryDetails> getBudgetPersonSalaryDetails() {
        ArrayList<BudgetPersonSalaryDetails> salaryDetails = new ArrayList<BudgetPersonSalaryDetails>();
        if ((this.budgetPersonSalaryDetails == null || this.budgetPersonSalaryDetails.isEmpty()) && this.getBudget() != null) {
            for (BudgetPeriod budgetPeriod : this.getBudget().getBudgetPeriods()) {
                salaryDetails.add(this.getNewBudgetPersonSalaryDetails(budgetPeriod));
            }
            this.budgetPersonSalaryDetails = salaryDetails;
        }
        return this.budgetPersonSalaryDetails;
    }

    public BudgetPersonSalaryDetails getNewBudgetPersonSalaryDetails(BudgetPeriod budgetPeriod) {
        BudgetPersonSalaryDetails budgetPersonSalaryDetails = new BudgetPersonSalaryDetails();
        budgetPersonSalaryDetails.setBudgetPerson(this);
        budgetPersonSalaryDetails.setBudgetId(this.getBudgetId());
        budgetPersonSalaryDetails.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
        budgetPersonSalaryDetails.setPersonId(this.getPersonId());
        budgetPersonSalaryDetails.setPersonSequenceNumber(this.getPersonSequenceNumber());
        return budgetPersonSalaryDetails;
    }

    public void setBudgetPersonSalaryDetails(List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails) {
        this.budgetPersonSalaryDetails = budgetPersonSalaryDetails;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getStartDate() {
        return this.effectiveDate;
    }

    public String getJobCode() {
        return this.jobCode;
    }

    public void setJobCode(String jobCode) {
        if (this.jobCode == null || !this.jobCode.equals(jobCode)) {
            this.jobCode = jobCode;
            this.refreshJobTitle();
        }
    }

    public Boolean getNonEmployeeFlag() {
        return this.nonEmployeeFlag;
    }

    public void setNonEmployeeFlag(Boolean nonEmployeeFlag) {
        this.nonEmployeeFlag = nonEmployeeFlag;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public AppointmentType getAppointmentType() {
        return this.appointmentType;
    }

    public void setAppointmentType(AppointmentType appointmentType) {
        this.appointmentType = appointmentType;
    }

    public ScaleTwoDecimal getCalculationBase() {
        return this.calculationBase;
    }

    public void setCalculationBase(ScaleTwoDecimal calculationBase) {
        this.calculationBase = calculationBase;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getAppointmentTypeCode() {
        return this.appointmentTypeCode;
    }

    public void setAppointmentTypeCode(String appointmentTypeCode) {
        this.appointmentTypeCode = appointmentTypeCode;
    }

    @Override
    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public KcPerson getPerson() {
        return this.getKcPersonService().getKcPersonByPersonId(this.personId);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setRoldex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Integer getPersonSequenceNumber() {
        return this.personSequenceNumber;
    }

    public void setPersonSequenceNumber(Integer personSequenceNumber) {
        this.personSequenceNumber = personSequenceNumber;
    }

    public String getTbnId() {
        return this.tbnId;
    }

    public void setTbnId(String tbnId) {
        this.tbnId = tbnId;
    }

    public Rolodex getRolodex() {
        if (this.rolodex == null && this.rolodexId != null) {
            this.getDataObjectService().wrap((Object)this).fetchRelationship("rolodex");
        }
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public String getRole() {
        if (this.getPersonRolodex() != null) {
            this.role = this.getPersonRolodex().getContactRole().getRoleDescription();
        }
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean isDuplicatePerson(BudgetPerson budgetPerson) {
        if (!StringUtils.equals((CharSequence)this.getJobCode(), (CharSequence)budgetPerson.getJobCode()) || !Objects.equals(this.getEffectiveDate(), budgetPerson.getEffectiveDate())) {
            return false;
        }
        if (this.getNonEmployeeFlag() != null && this.getNonEmployeeFlag().booleanValue() && budgetPerson.getNonEmployeeFlag() != null && budgetPerson.getNonEmployeeFlag().booleanValue()) {
            if (this.getRolodexId() != null && budgetPerson.getRolodexId() != null) {
                return this.getRolodexId().equals(budgetPerson.getRolodexId());
            }
            if (this.getTbnId() != null && budgetPerson.getTbnId() != null) {
                return this.getTbnId().equals(budgetPerson.getTbnId());
            }
            return false;
        }
        if (this.getNonEmployeeFlag() != null && !this.getNonEmployeeFlag().booleanValue() && budgetPerson.getNonEmployeeFlag() != null && !budgetPerson.getNonEmployeeFlag().booleanValue()) {
            return this.getPersonId().equals(budgetPerson.getPersonId());
        }
        return false;
    }

    public boolean isSamePerson(BudgetPerson budgetPerson) {
        if (this.getNonEmployeeFlag().booleanValue() && budgetPerson.getNonEmployeeFlag().booleanValue()) {
            if (this.getRolodexId() != null && budgetPerson.getRolodexId() != null) {
                return this.getRolodexId().equals(budgetPerson.getRolodexId());
            }
            if (this.getTbnId() != null && budgetPerson.getTbnId() != null) {
                return this.getTbnId().equals(budgetPerson.getTbnId()) && StringUtils.equals((CharSequence)this.getPersonName(), (CharSequence)budgetPerson.getPersonName());
            }
            return false;
        }
        if (!this.getNonEmployeeFlag().booleanValue() && !budgetPerson.getNonEmployeeFlag().booleanValue()) {
            return this.getPersonId().equals(budgetPerson.getPersonId());
        }
        return false;
    }

    public String getPersonRolodexTbnId() {
        String rolodexPersonId = this.getRolodexId() == null ? this.getPersonId() : this.getRolodexId().toString();
        return rolodexPersonId == null ? this.getTbnId() : rolodexPersonId;
    }

    public String getJobTitle() {
        this.getJobTitleFromJobCode();
        String ret = null;
        if (this.jobCodeRef != null) {
            ret = this.jobCodeRef.getJobTitle();
        }
        return ret;
    }

    public void setJobTitle(String jobTitle) {
        this.refreshJobTitle();
    }

    private void refreshJobTitle() {
        this.jobCodeRef = null;
        this.getJobTitleFromJobCode();
    }

    private void getJobTitleFromJobCode() {
        if (StringUtils.isNotBlank((CharSequence)this.getJobCode()) && (this.jobCodeRef == null || !StringUtils.isNotBlank((CharSequence)this.jobCodeRef.getJobTitle()))) {
            JobCodeService jcService = KcServiceLocator.getService(JobCodeService.class);
            this.jobCodeRef = jcService.findJobCodeRef(this.getJobCode());
        }
    }

    public JobCode getJobCodeRef() {
        return this.jobCodeRef;
    }

    public void setJobCodeRef(JobCode jobCodeRef) {
        this.jobCodeRef = jobCodeRef;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getBudgetId() == null ? 0 : this.getBudgetId().hashCode());
        result = 31 * result + (this.personSequenceNumber == null ? 0 : this.personSequenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BudgetPerson other = (BudgetPerson)obj;
        if (this.getBudgetId() == null ? other.getBudgetId() != null : !this.getBudgetId().equals(other.getBudgetId())) {
            return false;
        }
        return !(this.personSequenceNumber == null ? other.personSequenceNumber != null : !this.personSequenceNumber.equals(other.personSequenceNumber));
    }

    public Date getSalaryAnniversaryDate() {
        return this.salaryAnniversaryDate;
    }

    public void setSalaryAnniversaryDate(Date salaryAnniversaryDate) {
        this.salaryAnniversaryDate = salaryAnniversaryDate;
    }

    @Override
    public Date getSortableDate() {
        return this.getEffectiveDate();
    }

    public void setPersonSalaryDetails(BudgetPersonSalaryDetails personSalaryDetails) {
        this.personSalaryDetails = personSalaryDetails;
    }

    public BudgetPersonSalaryDetails getPersonSalaryDetails() {
        return this.personSalaryDetails;
    }

    public TbnPerson getTbnPerson() {
        return this.tbnPerson;
    }

    public void setTbnPerson(TbnPerson tbnPerson) {
        this.tbnPerson = tbnPerson;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPersonGroup() {
        if (this.hierarchyProposal != null) {
            return "Proposal #" + this.hierarchyProposal.getProposalNumber() + " - Budget Version " + this.hierarchyProposal.getLastSyncedBudget().getBudgetVersionNumber();
        }
        return this.getPersonRolodex() != null ? this.getBudget().getParentDocumentGroupName() : BUDGET_PERSON_GROUP_OTHER;
    }

    protected BudgetPersonService getBudgetPersonService() {
        if (this.budgetPersonService == null) {
            this.budgetPersonService = KcServiceLocator.getService(BudgetPersonService.class);
        }
        return this.budgetPersonService;
    }

    public String getContactRoleCode() {
        if (this.getPersonRolodex() != null) {
            this.contactRoleCode = this.getPersonRolodex().getContactRole().getRoleCode();
        }
        return this.contactRoleCode;
    }

    public void setContactRoleCode(String contactRoleCode) {
        this.contactRoleCode = contactRoleCode;
    }

    @PostLoad
    protected void syncPersonRolodex() {
        this.setPersonRolodex(this.getBudgetPersonService().getBudgetPersonRolodex(this.getBudget(), this));
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public PersonRolodex getPersonRolodex() {
        return this.personRolodex;
    }

    public void setPersonRolodex(PersonRolodex personRolodex) {
        this.personRolodex = personRolodex;
    }

    @Override
    public String getFullName() {
        return this.personName;
    }

    @Override
    public boolean isOtherSignificantContributorFlag() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().isOtherSignificantContributorFlag() : false;
    }

    @Override
    public String getProjectRole() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().getProjectRole() : null;
    }

    @Override
    public ContactRole getContactRole() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().getContactRole() : null;
    }

    @Override
    public Sponsorable getParent() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().getParent() : null;
    }

    @Override
    public String getInvestigatorRoleDescription() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().getInvestigatorRoleDescription() : null;
    }

    @Override
    public boolean isInvestigator() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().isInvestigator() : false;
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().isPrincipalInvestigator() : false;
    }

    @Override
    public boolean isMultiplePi() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().isMultiplePi() : false;
    }

    @Override
    public String getLastName() {
        String lastName = null;
        if (this.getTbnId() == null) {
            lastName = this.getRolodexId() == null ? this.getKcPersonService().getKcPersonByPersonId(this.personId).getLastName() : this.getRolodex().getLastName();
        }
        return lastName;
    }

    @Override
    public Integer getOrdinalPosition() {
        return this.getPersonRolodex() != null ? this.getPersonRolodex().getOrdinalPosition() : this.getPersonSequenceNumber();
    }

    public DevelopmentProposal getHierarchyProposal() {
        return this.hierarchyProposal;
    }

    public void setHierarchyProposal(DevelopmentProposal hierarchyProposal) {
        this.hierarchyProposal = hierarchyProposal;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }
}

