/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.signature;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.kuali.coeus.common.framework.person.signature.PersonSignature;
import org.kuali.coeus.common.framework.person.signature.PersonSignatureModule;
import org.kuali.coeus.common.framework.person.signature.PersonSignatureService;
import org.kuali.coeus.common.framework.person.signature.PrintTextLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class PersonSignatureServiceImpl
implements PersonSignatureService {
    private static final String CORRESPONDENCE_SIGNATURE_TYPE = "CORRESPONDENCE_SIGNATURE_TYPE";
    private static final String CORRESPONDENCE_SIGNATURE_TAG = "CORRESPONDENCE_SIGNATURE_TAG";
    private static final float ADDITIONAL_SPACE_BETWEEN_TAG_AND_IMAGE = 5.0f;
    private static final String PERSON_SIGNATURE_ACTIVE = "signatureActive";
    private static final String PERSON_SIGNATURE_PERSON_ID = "personId";
    private static final String DEFAULT_SIGNATURE = "defaultSignature";
    protected static final String MODULE_CODE = "moduleCode";
    private static final Logger LOG = LogManager.getLogger(PersonSignatureServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;

    @Override
    public byte[] applySignature(byte[] pdfBytes) throws IOException {
        byte[] pdfFileData = pdfBytes;
        ByteArrayOutputStream byteArrayOutputStream = this.getOriginalPdfDocumentAsOutputsStream(pdfBytes);
        if (Objects.nonNull(byteArrayOutputStream = this.identifyModeAndApplySignature(byteArrayOutputStream))) {
            pdfFileData = byteArrayOutputStream.toByteArray();
        }
        return pdfFileData;
    }

    protected ByteArrayOutputStream identifyModeAndApplySignature(ByteArrayOutputStream originalByteArrayOutputStream) throws IOException {
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        String signatureTypeParam = this.getSignatureTypeParameter();
        SignatureTypes signatureType = SignatureTypes.NO_SIGNATURE_REQURIED;
        if (Objects.nonNull(signatureTypeParam)) {
            signatureType = SignatureTypes.getSignatureMode(signatureTypeParam);
        }
        if (signatureType != null) {
            switch (signatureType) {
                case DEFAULT_SIGNATURE: {
                    outputStream = this.printDefaultSignature(outputStream);
                    break;
                }
                case SIGNED_IN_USER_SIGNATURE: {
                    String personId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
                    outputStream = this.printLoggedInUserSignature(personId, outputStream);
                    break;
                }
            }
        } else {
            LOG.warn("Invalid signature type defined in parameter");
        }
        return outputStream;
    }

    protected ByteArrayOutputStream printDefaultSignature(ByteArrayOutputStream originalByteArrayOutputStream) throws IOException {
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        PersonSignature authorizedSignature = this.getDefaultSignature();
        if (ObjectUtils.isNotNull((Object)authorizedSignature) && Objects.nonNull(authorizedSignature.getAttachmentContent())) {
            outputStream = this.applyAutographInDocument(authorizedSignature, outputStream);
        }
        return outputStream;
    }

    protected ByteArrayOutputStream printLoggedInUserSignature(String personId, ByteArrayOutputStream originalByteArrayOutputStream) throws IOException {
        PersonSignature userSignature = this.getLoggedinPersonSignature(personId);
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        if (ObjectUtils.isNull((Object)userSignature)) {
            userSignature = this.getDefaultSignature();
        }
        if (ObjectUtils.isNotNull((Object)userSignature) && Objects.nonNull(userSignature.getAttachmentContent())) {
            outputStream = this.applyAutographInDocument(userSignature, outputStream);
        }
        return outputStream;
    }

    protected ByteArrayOutputStream applyAutographInDocument(PersonSignature personSignature, ByteArrayOutputStream originalByteArrayOutputStream) {
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        try {
            if (personSignature.getAttachmentContent() != null) {
                outputStream = this.scanAndApplyAutographInEachPage(personSignature, outputStream);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return outputStream;
    }

    protected ByteArrayOutputStream scanAndApplyAutographInEachPage(PersonSignature personSignature, ByteArrayOutputStream originalByteArrayOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        block8: {
            PDDocument originalDocument = PDDocument.load((byte[])originalByteArrayOutputStream.toByteArray());
            try {
                Set<PrintTextLocator.PDFTextLocation> locations = new PrintTextLocator(originalDocument, new HashSet<String>(this.getSignatureTagParameter())).doSearch();
                BufferedImage image = this.getBufferedImage(personSignature.getAttachmentContent());
                IntStream.rangeClosed(1, originalDocument.getDocumentCatalog().getPages().getCount()).forEach(pageNumber -> locations.stream().filter(location -> location.isFound() && pageNumber == location.getPage()).forEach(location -> {
                    try {
                        PDPage page = originalDocument.getDocumentCatalog().getPages().get(pageNumber - 1);
                        PDImageXObject signatureImage = JPEGFactory.createFromImage((PDDocument)originalDocument, (BufferedImage)image);
                        try (PDPageContentStream stream = new PDPageContentStream(originalDocument, page, PDPageContentStream.AppendMode.APPEND, true, false);){
                            stream.drawImage(signatureImage, location.getX(), page.getMediaBox().getHeight() - (float)signatureImage.getHeight() - 5.0f - location.getY());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }));
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                originalDocument.save((OutputStream)outputStream);
                byteArrayOutputStream = outputStream;
                if (originalDocument == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (originalDocument != null) {
                        try {
                            originalDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            originalDocument.close();
        }
        return byteArrayOutputStream;
    }

    private ByteArrayOutputStream getOriginalPdfDocumentAsOutputsStream(byte[] pdfFileData) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(pdfFileData);
        PDDocument originalDocument = PDDocument.load((InputStream)is);
        originalDocument.save((OutputStream)outputStream);
        originalDocument.close();
        return outputStream;
    }

    protected BufferedImage getBufferedImage(byte[] imageData) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        return ImageIO.read(in);
    }

    protected PersonSignature getDefaultSignature() {
        List<PersonSignatureModule> moduleSignatures = this.getAuthorizedDefaultSignatory();
        PersonSignature authorizedSignature = null;
        if (!moduleSignatures.isEmpty()) {
            authorizedSignature = moduleSignatures.get(0).getPersonSignature();
        }
        return authorizedSignature;
    }

    protected PersonSignature getLoggedinPersonSignature(String personId) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        boolean isAuthorized = false;
        fieldValues.put(PERSON_SIGNATURE_PERSON_ID, personId);
        fieldValues.put(PERSON_SIGNATURE_ACTIVE, Boolean.TRUE);
        PersonSignature personSignature = (PersonSignature)this.getBusinessObjectService().findByPrimaryKey(PersonSignature.class, fieldValues);
        if (ObjectUtils.isNotNull((Object)personSignature)) {
            for (PersonSignatureModule personSignatureModule : personSignature.getPersonSignatureModules()) {
                if (!personSignatureModule.getModuleCode().equalsIgnoreCase(this.getModuleCodeHook()) || !personSignatureModule.isSignatureActive()) continue;
                isAuthorized = true;
                break;
            }
        }
        return isAuthorized ? personSignature : null;
    }

    protected List<PersonSignatureModule> getAuthorizedDefaultSignatory() {
        HashMap<String, Object> matchingKey = new HashMap<String, Object>();
        matchingKey.put(MODULE_CODE, this.getModuleCodeHook());
        matchingKey.put(PERSON_SIGNATURE_ACTIVE, Boolean.TRUE);
        matchingKey.put(DEFAULT_SIGNATURE, Boolean.TRUE);
        return (List)this.getBusinessObjectService().findMatching(PersonSignatureModule.class, matchingKey);
    }

    protected String getSignatureTypeParameter() {
        return this.getParameterService().getParameterValueAsString(this.getModuleNameSpaceHook(), "Document", CORRESPONDENCE_SIGNATURE_TYPE);
    }

    protected Collection<String> getSignatureTagParameter() {
        return this.getParameterService().getParameterValuesAsString(this.getModuleNameSpaceHook(), "Document", CORRESPONDENCE_SIGNATURE_TAG);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected abstract String getModuleCodeHook();

    protected abstract String getModuleNameSpaceHook();

    public static enum SignatureTypes {
        DEFAULT_SIGNATURE("D"),
        SIGNED_IN_USER_SIGNATURE("S"),
        NO_SIGNATURE_REQURIED("N");

        private String signatureType;

        private SignatureTypes(String signatureType) {
            this.signatureType = signatureType;
        }

        public String getSignatureType() {
            return this.signatureType;
        }

        public static SignatureTypes getSignatureMode(String signatureType) {
            for (SignatureTypes sType : SignatureTypes.values()) {
                if (!sType.signatureType.equals(signatureType)) continue;
                return sType;
            }
            return null;
        }
    }
}

