/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.location;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.location.AddProposalCongressionalDistrictEvent;
import org.kuali.coeus.propdev.impl.location.CongressionalDistrict;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.location.ProposalSiteRule;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public class BasicProposalSiteEvent
extends KcDocumentEventBase {
    private static final Logger LOG = LogManager.getLogger(AddProposalCongressionalDistrictEvent.class);
    private List<ProposalSite> proposalSites;
    private String siteIndex;
    private List<CongressionalDistrict> congressionalDistricts;

    public BasicProposalSiteEvent(String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this("Creating a rule event that only checks the proposal site index. Document Id = " + BasicProposalSiteEvent.getDocumentId((Document)proposalDevelopmentDocument), errorPathPrefix, proposalDevelopmentDocument);
    }

    public BasicProposalSiteEvent(String description, String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument, ProposalSite proposalSite) {
        this(description, errorPathPrefix, proposalDevelopmentDocument);
        this.proposalSites = new ArrayList<ProposalSite>();
        this.proposalSites.add(proposalSite);
        this.siteIndex = "0";
    }

    public BasicProposalSiteEvent(String description, String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument, List<ProposalSite> proposalSites, String siteIndex) {
        this(description, errorPathPrefix, proposalDevelopmentDocument);
        this.proposalSites = proposalSites;
        this.siteIndex = siteIndex;
    }

    private BasicProposalSiteEvent(String description, String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        super(description, errorPathPrefix, (Document)proposalDevelopmentDocument);
    }

    public BasicProposalSiteEvent(String description, ProposalDevelopmentDocument proposalDevelopmentDocument, List<CongressionalDistrict> congressionalDistricts) {
        this(description, proposalDevelopmentDocument);
        this.congressionalDistricts = congressionalDistricts;
    }

    public BasicProposalSiteEvent(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this("Creating a rule event that only checks the proposal site index. Document Id = " + BasicProposalSiteEvent.getDocumentId((Document)proposalDevelopmentDocument), proposalDevelopmentDocument);
    }

    public List<ProposalSite> getProposalSites() {
        return this.proposalSites;
    }

    public String getSiteIndex() {
        return this.siteIndex;
    }

    public ProposalSite getProposalSite() {
        return this.proposalSites.get(new Integer(this.siteIndex));
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)((Object)((Object)this)).getClass().getName(), (String)"."));
        logMessage.append("with site index ");
        logMessage.append(this.siteIndex);
        logMessage.append(", ");
        logMessage.append(this.proposalSites == null ? "null" : Integer.valueOf(this.proposalSites.size()));
        logMessage.append(" proposal sites");
        LOG.debug((CharSequence)logMessage);
    }

    public Class getRuleInterfaceClass() {
        return ProposalSiteRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((ProposalSiteRule)rule).processBasicProposalSiteRules(this);
    }
}

