/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.print;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsHelperBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.Protocol;

public class ProtocolPrintPermissionUtils
extends PermissionsHelperBase {
    private static final long serialVersionUID = -6233936470002193650L;
    private Protocol protocol;

    public ProtocolPrintPermissionUtils() {
    }

    public ProtocolPrintPermissionUtils(String roleType) {
        super(roleType);
    }

    @Override
    public boolean canModifyPermissions() {
        return false;
    }

    @Override
    protected List<KcPerson> getPersonsInRole(String roleName) {
        KcAuthorizationService kraAuthorizationService = KcServiceLocator.getService(KcAuthorizationService.class);
        KcPersonService kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        List<String> users = kraAuthorizationService.getPrincipalsInRole(roleName, this.getProtocol());
        ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
        for (String userId : users) {
            KcPerson person = kcPersonService.getKcPersonByPersonId(userId);
            if (person == null || !person.getActive().booleanValue()) continue;
            persons.add(person);
        }
        return persons;
    }

    @Override
    protected boolean isStandardRoleName(String roleName) {
        return StringUtils.equals((CharSequence)roleName, (CharSequence)"Protocol Aggregator") || StringUtils.equals((CharSequence)roleName, (CharSequence)"Protocol Viewer");
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }
}

