/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.permission;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.permission.PermissionsHelperBase;

public class PermissionsHelper
extends PermissionsHelperBase {
    private static final long serialVersionUID = 7892561010219047907L;

    public PermissionsHelper(ProtocolForm form) {
        super(form, "KC-PROTOCOL");
        this.form = form;
    }

    @Override
    protected void initExcludedRolesHook() {
        if (this.excludeRoles == null) {
            this.excludeRoles = new HashSet();
        }
        this.excludeRoles.add("IRB Online Reviewer");
        this.excludeRoles.add("Active Committee Member");
        this.excludeRoles.add("Active Committee Member On Scheduled Date");
        this.excludeRoles.add("ProtocolApprover");
        this.excludeRoles.add("Active Committee Member On Protocol");
    }

    @Override
    protected void buildDisplayNameMap() {
        if (this.displayNameMap == null) {
            this.displayNameMap = new HashMap();
            this.displayNameMap.put("Protocol Aggregator", "Aggregator");
            this.displayNameMap.put("Protocol Viewer", "Viewer");
            this.displayNameMap.put("Protocol Unassigned", "unassigned");
        }
    }

    @Override
    public boolean canModifyPermissions() {
        ProtocolTask task = new ProtocolTask("modifyProtocolRoles", (Protocol)this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    @Override
    protected boolean isStandardRoleName(String roleName) {
        return StringUtils.equals((CharSequence)roleName, (CharSequence)"Protocol Aggregator") || StringUtils.equals((CharSequence)roleName, (CharSequence)"Protocol Viewer");
    }
}

