/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.version.BudgetVersionRule;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.propdev.impl.budget.core.ProposalAddBudgetVersionEvent;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="proposalBudgetVersionRule")
public class ProposalBudgetVersionRule
extends BudgetVersionRule {
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    protected boolean processAddBudgetVersionName(ProposalAddBudgetVersionEvent event) {
        boolean retval = true;
        if (!this.isNameValid(event.getVersionName())) {
            retval = false;
            this.getGlobalVariableService().getMessageMap().putError(event.getErrorPath() + ".budgetName", "error.budgetVersion.documentDescription.required", new String[]{"Name"});
        }
        for (Budget budget : event.getBudgetParent().getBudgets()) {
            if (!StringUtils.equals((CharSequence)budget.getName(), (CharSequence)event.getVersionName())) continue;
            retval = false;
            this.getGlobalVariableService().getMessageMap().putError(event.getErrorPath() + ".budgetName", "error.budgetVersion.exists", new String[0]);
            break;
        }
        return retval;
    }

    @KcEventMethod
    public boolean processAddBudgetVersion(ProposalAddBudgetVersionEvent event) throws WorkflowException {
        boolean retval = true;
        retval &= this.processAddBudgetVersionName(event);
        return retval &= super.processAddBudgetVersion(event);
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

