/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolActionAjaxService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerType;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionAjaxServiceImplBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class IacucProtocolActionAjaxServiceImpl
extends ProtocolActionAjaxServiceImplBase
implements IacucProtocolActionAjaxService {
    private ParameterService parameterService;
    public static final String DEFAULT_REVIEW_TYPE_PARAMETER_NAME = "IACUC_ALL_COMM_REVIEWERS_DEFAULT_ASSIGNED";

    @Override
    public Class<? extends ProtocolBase> getProtocolClassHook() {
        return IacucProtocol.class;
    }

    @Override
    public Class getProtocolReviewerTypeClassHook() {
        return IacucProtocolReviewerType.class;
    }

    @Override
    public String getDefaultCommitteeReviewTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-IACUC", "Document", DEFAULT_REVIEW_TYPE_PARAMETER_NAME);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public String getReviewers(String protocolId, String committeeId, String scheduleId) {
        if (StringUtils.isNotBlank((CharSequence)scheduleId)) {
            return this.getRevs(protocolId, committeeId, scheduleId);
        }
        return "";
    }

    protected String getRevs(String protocolId, String committeeId, String scheduleId) {
        StringBuffer ajaxList = new StringBuffer();
        IacucProtocol protocol = (IacucProtocol)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocol.class, (Object)protocolId);
        List<CommitteeMembershipBase> filteredMembers = protocol.filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(committeeId, scheduleId));
        for (CommitteeMembershipBase filteredMember : filteredMembers) {
            Optional<ProtocolOnlineReviewBase> review;
            if (StringUtils.isNotBlank((CharSequence)filteredMember.getPersonId())) {
                ajaxList.append(filteredMember.getPersonId() + ";" + filteredMember.getPersonName() + ";N;");
                review = protocol.getProtocolOnlineReviews().stream().filter(r -> filteredMember.getPersonId().equals(r.getProtocolReviewer().getPersonId())).findFirst();
                ajaxList.append((review.isPresent() ? review.get().getProtocolReviewer().getReviewerTypeCode() : "") + ";");
                continue;
            }
            ajaxList.append(filteredMember.getRolodexId() + ";" + filteredMember.getPersonName() + ";Y;");
            review = protocol.getProtocolOnlineReviews().stream().filter(r -> filteredMember.getRolodexId().equals(r.getProtocolReviewer().getRolodexId())).findFirst();
            ajaxList.append((review.isPresent() ? review.get().getProtocolReviewer().getReviewerTypeCode() : "") + ";");
        }
        return this.clipLastChar(ajaxList);
    }

    @Override
    public String getModifySubmissionProtocolReviewers(String protocolId, String committeeId, String scheduleId, String protocolReviewTypeCode) {
        return this.getRevs(protocolId, committeeId, scheduleId);
    }
}

