/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.math.BigDecimal;
import java.util.List;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.AwardBudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonService;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonServiceFactory;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.budget.AwardBudgetPeriodCalculationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="awardBudgetPeriodCalculationService")
public class AwardBudgetPeriodCalculationServiceImpl
implements AwardBudgetPeriodCalculationService {
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;

    @Override
    public void calculateBudgetPeriod(boolean forceCalculation, Budget budget, BudgetPeriod budgetPeriod) {
        budgetPeriod.setBudget(budget);
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            this.budgetCalculationService.updatePersonnelBudgetRate(budgetLineItem);
            if (!budgetLineItem.getFormulatedCostElementFlag().booleanValue()) continue;
            this.calculateAndUpdateFormulatedCost(budgetLineItem);
        }
        if (this.kcBusinessRulesEngine.applyRules(new AwardBudgetSaveEvent(budget)).booleanValue()) {
            if (forceCalculation) {
                this.recalculateBudgetPeriod(budget, budgetPeriod);
            } else {
                this.calculateBudgetPeriod(budget, budgetPeriod);
            }
        }
    }

    @Override
    public void calculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.budgetCalculationService.calculateBudgetPeriod(budget, budgetPeriod);
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParent budgetParent) {
        return BudgetCommonServiceFactory.createInstance(budgetParent);
    }

    @Override
    public void recalculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.getBudgetCommonService(budget.getBudgetParent()).recalculateBudgetPeriod(budget, budgetPeriod);
    }

    @Override
    public void calculateAndUpdateFormulatedCost(BudgetLineItem budgetLineItem) {
        ScaleTwoDecimal formulatedCostTotal;
        if (budgetLineItem.getFormulatedCostElementFlag().booleanValue() && (formulatedCostTotal = this.getFormulatedCostsTotal(budgetLineItem)) != null) {
            budgetLineItem.setLineItemCost(formulatedCostTotal);
        }
    }

    @Override
    public void calculateBudgetFormulatedCost(BudgetFormulatedCostDetail budgetFormulatedCost) {
        BigDecimal unitCost = budgetFormulatedCost.getUnitCost().bigDecimalValue();
        BigDecimal count = new ScaleTwoDecimal(budgetFormulatedCost.getCount().intValue()).bigDecimalValue();
        BigDecimal frequency = new ScaleTwoDecimal(budgetFormulatedCost.getFrequency().intValue()).bigDecimalValue();
        BigDecimal calculatedExpense = unitCost.multiply(count).multiply(frequency);
        budgetFormulatedCost.setCalculatedExpenses(new ScaleTwoDecimal(calculatedExpense));
    }

    @Override
    public ScaleTwoDecimal getFormulatedCostsTotal(BudgetLineItem budgetLineItem) {
        List<BudgetFormulatedCostDetail> budgetFormulatedCosts = budgetLineItem.getBudgetFormulatedCosts();
        ScaleTwoDecimal formulatedExpenses = ScaleTwoDecimal.ZERO;
        for (BudgetFormulatedCostDetail budgetFormulatedCostDetail : budgetFormulatedCosts) {
            this.calculateBudgetFormulatedCost(budgetFormulatedCostDetail);
            formulatedExpenses = (ScaleTwoDecimal)formulatedExpenses.add((AbstractDecimal)budgetFormulatedCostDetail.getCalculatedExpenses());
        }
        return formulatedExpenses;
    }
}

