/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.approve;

import java.sql.Timestamp;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveBean;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public abstract class ProtocolApproveServiceImplBase
implements ProtocolApproveService {
    protected static final String RESPONSE_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of response approval action on protocol.";
    private static final String ADMIN_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of administrative approval action on protocol.";
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    protected ProtocolOnlineReviewService protocolOnlineReviewService;

    @Override
    public void grantResponseApproval(ProtocolDocumentBase protocolDocument, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach(protocolDocument.getProtocol(), actionBean, this.getProtocolActionTypeCodeForResponseApprovalHook());
        if (protocolDocument.getProtocol().getApprovalDate() == null) {
            protocolDocument.getProtocol().setApprovalDate(actionBean.getApprovalDate());
        }
        if (!protocolDocument.getProtocol().isNew()) {
            protocolDocument.getProtocol().setLastApprovalDate(actionBean.getApprovalDate());
        }
        protocolDocument.getProtocol().setExpirationDate(actionBean.getExpirationDate());
        this.finalizeReviewsAndSave(protocolDocument, this.getProtocolActionTypeCodeForResponseApprovalHook(), RESPONSE_APPROVAL_FINALIZE_OLR_ANNOTATION);
        protocolDocument.getProtocol().getProtocolDocument().getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    protected abstract String getProtocolActionTypeCodeForResponseApprovalHook();

    @Override
    public void grantAdminApproval(ProtocolDocumentBase protocolDocument, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach(protocolDocument.getProtocol(), actionBean, this.getProtocolActionTypeCodeForAdminApprovalHook());
        if (protocolDocument.getProtocol().getApprovalDate() == null) {
            protocolDocument.getProtocol().setApprovalDate(actionBean.getApprovalDate());
        }
        if (!protocolDocument.getProtocol().isNew()) {
            protocolDocument.getProtocol().setLastApprovalDate(actionBean.getApprovalDate());
        }
        protocolDocument.getProtocol().setExpirationDate(actionBean.getExpirationDate());
        this.finalizeReviewsAndSave(protocolDocument, this.getProtocolActionTypeCodeForAdminApprovalHook(), ADMIN_APPROVAL_FINALIZE_OLR_ANNOTATION);
        protocolDocument.getProtocol().getProtocolDocument().getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    protected abstract String getProtocolActionTypeCodeForAdminApprovalHook();

    protected void generateProtocolActionAndAttach(ProtocolBase protocol, ProtocolApproveBean actionBean, String protocolActionTypeCode) {
        ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(protocol, protocol.getProtocolSubmission(), protocolActionTypeCode);
        protocolAction.setComments(actionBean.getComments());
        protocolAction.setActionDate(new Timestamp(actionBean.getActionDate().getTime()));
        protocolAction.setSubmissionIdFk(protocol.getLastProtocolAction().getSubmissionIdFk());
        protocolAction.setSubmissionNumber(protocol.getLastProtocolAction().getSubmissionNumber());
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
    }

    protected abstract ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected abstract ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String var1);

    protected void finalizeReviewsAndSave(ProtocolDocumentBase protocolDocument, String protocolActionTypeCode, String reviewAnnotation) throws Exception {
        protocolDocument.refreshReferenceObject("protocolStatus");
        this.protocolOnlineReviewService.finalizeOnlineReviews(protocolDocument.getProtocol().getProtocolSubmission(), reviewAnnotation);
        this.documentService.saveDocument((Document)protocolDocument);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return this.protocolOnlineReviewService;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }
}

