/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import java.sql.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipRole;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.rule.AddCommitteeMembershipRoleRule;
import org.kuali.coeus.common.committee.impl.rule.AddCommitteeMembershipRule;
import org.kuali.coeus.common.committee.impl.rule.event.AddCommitteeMembershipEvent;
import org.kuali.coeus.common.committee.impl.rule.event.AddCommitteeMembershipRoleEvent;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;

public class CommitteeMembershipRule
extends KcTransactionalDocumentRuleBase
implements AddCommitteeMembershipRule,
AddCommitteeMembershipRoleRule {
    private final String PROPERTY_NAME_PERSON_NAME = "committeeHelper.newCommitteeMembership.personName";
    private final String PROPERTY_NAME_ROLE_CODE = "committeeHelper.newCommitteeMembershipRoles[%1$s].membershipRoleCode";
    private final String PROPERTY_NAME_ROLE_START_DATE = "committeeHelper.newCommitteeMembershipRoles[%1$s].startDate";
    private final String PROPERTY_NAME_ROLE_END_DATE = "committeeHelper.newCommitteeMembershipRoles[%1$s].endDate";

    @Override
    public boolean processAddCommitteeMembershipBusinessRules(AddCommitteeMembershipEvent addCommitteeMembershipEvent) {
        boolean isValid = true;
        CommitteeMembershipBase committeeMembership = addCommitteeMembershipEvent.getCommitteeMembership();
        if (StringUtils.isBlank((CharSequence)committeeMembership.getPersonId()) && committeeMembership.getRolodexId() == null) {
            isValid = false;
            this.reportError("committeeHelper.newCommitteeMembership.personName", "error.committee.membership.person.not.specified", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)committeeMembership.getPersonName()) && isValid) {
            isValid = false;
            this.reportError("committeeHelper.newCommitteeMembership.personName", "error.committee.membership.person.no.name", new String[0]);
        }
        return isValid;
    }

    @Override
    public boolean processAddCommitteeMembershipRoleBusinessRules(AddCommitteeMembershipRoleEvent addCommitteeMembershipRoleEvent) {
        boolean isValid = true;
        CommitteeMembershipRole membershipRole = addCommitteeMembershipRoleEvent.getCommitteeMembershipRole();
        int membershipIndex = addCommitteeMembershipRoleEvent.getMembershipIndex();
        CommitteeDocumentBase committeeDocument = (CommitteeDocumentBase)addCommitteeMembershipRoleEvent.getDocument();
        CommitteeMembershipBase committeeMembership = ((CommitteeBase)committeeDocument.getCommittee()).getCommitteeMemberships().get(membershipIndex);
        List<CommitteeMembershipRole> membershipRoles = committeeMembership.getMembershipRoles();
        if (StringUtils.isBlank((CharSequence)membershipRole.getMembershipRoleCode())) {
            isValid = false;
            this.reportError(String.format("committeeHelper.newCommitteeMembershipRoles[%1$s].membershipRoleCode", membershipIndex), "error.committee.membership.role.not.specified", new String[0]);
        }
        if (membershipRole.getStartDate() == null) {
            isValid = false;
            this.reportError(String.format("committeeHelper.newCommitteeMembershipRoles[%1$s].startDate", membershipIndex), "error.committee.membership.roleStartDate.not.specified", new String[0]);
        }
        if (this.hasDateOutsideCommitteeMembershipTerm(committeeMembership, membershipRole.getStartDate())) {
            isValid = false;
            this.reportError(String.format("committeeHelper.newCommitteeMembershipRoles[%1$s].startDate", membershipIndex), "error.committee.membership.roleStartDate.outside.term", new String[0]);
        }
        if (membershipRole.getEndDate() == null) {
            isValid = false;
            this.reportError(String.format("committeeHelper.newCommitteeMembershipRoles[%1$s].endDate", membershipIndex), "error.committee.membership.roleEndDate.not.specified", new String[0]);
        }
        if (membershipRole.getStartDate() != null && membershipRole.getEndDate() != null && membershipRole.getEndDate().before(membershipRole.getStartDate())) {
            isValid = false;
            this.reportError(String.format("committeeHelper.newCommitteeMembershipRoles[%1$s].endDate", membershipIndex), "error.committee.membership.roleEndDate.before.roleStartDate", new String[0]);
        }
        if (this.hasDateOutsideCommitteeMembershipTerm(committeeMembership, membershipRole.getEndDate())) {
            isValid = false;
            this.reportError(String.format("committeeHelper.newCommitteeMembershipRoles[%1$s].endDate", membershipIndex), "error.committee.membership.roleEndDate.outside.term", new String[0]);
        }
        if (isValid && this.hasRoleOverlap(membershipRole, membershipRoles)) {
            isValid = false;
            this.reportError(String.format("committeeHelper.newCommitteeMembershipRoles[%1$s].membershipRoleCode", membershipIndex), "error.committee.membership.role.duplicate", new String[0]);
        }
        return isValid;
    }

    private boolean hasDateOutsideCommitteeMembershipTerm(CommitteeMembershipBase committeeMembership, Date date) {
        boolean isOutside = false;
        if (committeeMembership.getTermStartDate() != null && committeeMembership.getTermEndDate() != null && date != null && (date.before(committeeMembership.getTermStartDate()) || date.after(committeeMembership.getTermEndDate()))) {
            isOutside = true;
        }
        return isOutside;
    }

    private boolean hasRoleOverlap(CommitteeMembershipRole role, List<CommitteeMembershipRole> membershipRoles) {
        boolean hasOverlap = false;
        for (CommitteeMembershipRole tmpRole : membershipRoles) {
            if (!role.getMembershipRoleCode().equals(tmpRole.getMembershipRoleCode()) || !this.isWithinPeriod(role.getStartDate(), tmpRole.getStartDate(), tmpRole.getEndDate()) && !this.isWithinPeriod(role.getEndDate(), tmpRole.getStartDate(), tmpRole.getEndDate())) continue;
            hasOverlap = true;
        }
        return hasOverlap;
    }

    private boolean isWithinPeriod(Date date, Date periodStart, Date periodEnd) {
        return !date.before(periodStart) && !date.after(periodEnd);
    }
}

