/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.unit.admin;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.unit.admin.UnitAdministratorContract;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

@Entity
@Table(name="UNIT_ADMINISTRATOR")
@IdClass(value=UnitAdministratorId.class)
public class UnitAdministrator
extends KcPersistableBusinessObjectBase
implements AbstractUnitAdministrator,
Comparable<UnitAdministrator>,
UnitAdministratorContract {
    private static final Logger LOG = LogManager.getLogger(UnitAdministrator.class);
    @Id
    @Column(name="PERSON_ID")
    private String personId;
    @Id
    @Column(name="UNIT_ADMINISTRATOR_TYPE_CODE")
    private String unitAdministratorTypeCode;
    @Id
    @Column(name="UNIT_NUMBER")
    private String unitNumber;
    @ManyToOne
    @JoinColumn(name="UNIT_NUMBER", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit unit;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="UNIT_ADMINISTRATOR_TYPE_CODE", referencedColumnName="UNIT_ADMINISTRATOR_TYPE_CODE", insertable=false, updatable=false)
    private UnitAdministratorType unitAdministratorType;
    @Transient
    private transient KcPersonService kcPersonService;

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    @Override
    public String getUnitAdministratorTypeCode() {
        return this.unitAdministratorTypeCode;
    }

    public void setUnitAdministratorTypeCode(String unitAdministratorTypeCode) {
        this.unitAdministratorTypeCode = unitAdministratorTypeCode;
    }

    @Override
    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    @Override
    public KcPerson getPerson() {
        KcPerson kcPerson = null;
        try {
            if (this.personId != null) {
                return this.getKcPersonService().getKcPersonByPersonId(this.personId);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.info("getPerson(): ignoring missing person/entity: " + this.personId);
        }
        return kcPerson;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    @Override
    public UnitAdministratorType getUnitAdministratorType() {
        return this.unitAdministratorType;
    }

    public void setUnitAdministratorType(UnitAdministratorType unitAdministratorType) {
        this.unitAdministratorType = unitAdministratorType;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public int compareTo(UnitAdministrator unitAdmin) {
        int result = 0;
        if (unitAdmin == null) {
            result = 1;
        } else if (!this.getUnitAdministratorTypeCode().equalsIgnoreCase(unitAdmin.getUnitAdministratorTypeCode())) {
            result = this.getUnitAdministratorTypeCode().compareTo(unitAdmin.getUnitAdministratorTypeCode());
        } else if (this.getPerson() != null && StringUtils.isNotEmpty((CharSequence)this.getPerson().getLastName()) && unitAdmin.getPerson() != null && StringUtils.isNotEmpty((CharSequence)unitAdmin.getPerson().getLastName())) {
            result = this.getPerson().getLastName().compareTo(unitAdmin.getPerson().getLastName());
        }
        return result;
    }

    public static final class UnitAdministratorId
    implements Serializable,
    Comparable<UnitAdministratorId> {
        private String unitNumber;
        private String personId;
        private String unitAdministratorTypeCode;

        public String getUnitNumber() {
            return this.unitNumber;
        }

        public void setUnitNumber(String unitNumber) {
            this.unitNumber = unitNumber;
        }

        public String getPersonId() {
            return this.personId;
        }

        public void setPersonId(String personId) {
            this.personId = personId;
        }

        public String getUnitAdministratorTypeCode() {
            return this.unitAdministratorTypeCode;
        }

        public void setUnitAdministratorTypeCode(String unitAdministratorTypeCode) {
            this.unitAdministratorTypeCode = unitAdministratorTypeCode;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("unitNumber", (Object)this.unitNumber).append("personId", (Object)this.personId).append("unitAdministratorTypeCode", (Object)this.unitAdministratorTypeCode).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            UnitAdministratorId rhs = (UnitAdministratorId)other;
            return new EqualsBuilder().append((Object)this.unitNumber, (Object)rhs.unitNumber).append((Object)this.personId, (Object)rhs.personId).append((Object)this.unitAdministratorTypeCode, (Object)rhs.unitAdministratorTypeCode).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.unitNumber).append((Object)this.personId).append((Object)this.unitAdministratorTypeCode).toHashCode();
        }

        @Override
        public int compareTo(UnitAdministratorId other) {
            return new CompareToBuilder().append((Object)this.unitNumber, (Object)other.unitNumber).append((Object)this.personId, (Object)other.personId).append((Object)this.unitAdministratorTypeCode, (Object)other.unitAdministratorTypeCode).toComparison();
        }
    }
}

