/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolDocumentRule;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.procedures.IacucProcedureNavigation;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolSpeciesStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.procedures.rule.AddProcedureLocationEvent;
import org.kuali.kra.iacuc.procedures.rule.AddProtocolStudyGroupEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

public class IacucProtocolProceduresAction
extends IacucProtocolAction {
    private static final String BEAN_FIND_PARAM_START = "iacucProtocolStudyGroupBeans[";
    private static final String BEAN_STUDY_GROUP_FIND_PARAM_START = "iacucProtocolStudyGroups[";
    private static final String BEAN_STUDY_GROUP_SPECIES_FIND_PARAM_START = "iacucProtocolSpeciesStudyGroups[";
    private static final String BEAN_PERSON_FIND_PARAM_START = "iacucProcedurePersonResponsibleList[";
    private static final String BEAN_LOCATION_FIND_PARAM_START = "iacucProcedureLocationResponsibleList[";
    private static final String FIND_PARAM_END = "].";
    private static final String CONFIRM_DELETE_PROCEDURE_LOCATION_KEY = "confirmDeleteProcedureLocation";
    private static final String CONFIRM_DELETE_PROCEDURE_GROUP_LOCATION_KEY = "confirmDeleteProcedureGroupLocation";
    private static final String CONFIRM_DELETE_PROCEDURE_STUDY_GROUP_KEY = "confirmDeleteProcedureStudyGroup";
    private static final String CONFIRM_DELETE_PROCEDURE_SPECIES_STUDY_GROUP_KEY = "confirmDeleteProcedureSpeciesStudyGroup";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getIacucProtocolProceduresHelper().prepareView();
        return forward;
    }

    public ActionForward addProtocolStudyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int groupBeanIndex = this.getSelectedLine(request);
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getIacucProtocol(form).getIacucProtocolStudyGroupBeans().get(groupBeanIndex);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.applyRules((DocumentEvent)new AddProtocolStudyGroupEvent(protocolForm.getIacucProtocolDocument(), selectedIacucProtocolStudyGroupBean, groupBeanIndex))) {
            this.getIacucProtocolProcedureService().addProtocolStudyGroup(selectedIacucProtocolStudyGroupBean, this.getIacucProtocol(form));
            selectedIacucProtocolStudyGroupBean.initializeStudyGroupItems();
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolStudyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
        IacucProtocolStudyGroup selectedStudyGroup = this.getSelectedStudyGroup(request, selectedIacucProtocolStudyGroupBean);
        String speciesAndGroups = selectedStudyGroup.getIacucProtocolSpecies().getGroupAndSpecies();
        return this.deleteProcedureStudyGroup(mapping, (ActionForm)protocolForm, request, response, speciesAndGroups, false);
    }

    public ActionForward deleteProtocolSpeciesStudyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
        IacucProtocolSpeciesStudyGroup selectedStudyGroup = this.getSelectedSpeciesStudyGroup(request, selectedIacucProtocolStudyGroupBean);
        String speciesAndGroups = selectedStudyGroup.getGroupAndSpecies();
        return this.deleteProcedureStudyGroup(mapping, (ActionForm)protocolForm, request, response, speciesAndGroups, true);
    }

    private ActionForward deleteProcedureStudyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String speciesAndGroups, boolean procedureGroupedBySpecies) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
        String procedureCategory = selectedIacucProtocolStudyGroupBean.getIacucProcedureCategory().getProcedureCategory();
        String procedure = selectedIacucProtocolStudyGroupBean.getIacucProcedure().getProcedureDescription();
        String confirmDeleteKey = procedureGroupedBySpecies ? CONFIRM_DELETE_PROCEDURE_SPECIES_STUDY_GROUP_KEY : CONFIRM_DELETE_PROCEDURE_STUDY_GROUP_KEY;
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, confirmDeleteKey, "question.iacuc.procedure.study.group.delete.confirmation", procedureCategory, procedure, speciesAndGroups), confirmDeleteKey, "");
    }

    public ActionForward confirmDeleteProcedureStudyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROCEDURE_STUDY_GROUP_KEY.equals(question)) {
            IacucProtocolForm protocolForm = (IacucProtocolForm)form;
            IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
            IacucProtocolStudyGroup selectedStudyGroup = this.getSelectedStudyGroup(request, selectedIacucProtocolStudyGroupBean);
            this.getIacucProtocolProcedureService().deleteProtocolStudyGroup(selectedIacucProtocolStudyGroupBean, selectedStudyGroup, this.getIacucProtocol(form));
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteProcedureSpeciesStudyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROCEDURE_SPECIES_STUDY_GROUP_KEY.equals(question)) {
            IacucProtocolForm protocolForm = (IacucProtocolForm)form;
            IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
            IacucProtocolSpeciesStudyGroup selectedStudyGroup = this.getSelectedSpeciesStudyGroup(request, selectedIacucProtocolStudyGroupBean);
            this.getIacucProtocolProcedureService().deleteProtocolStudyGroup(selectedIacucProtocolStudyGroupBean, selectedStudyGroup);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addProcedureLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation = protocolForm.getIacucProtocolProceduresHelper().getNewIacucProtocolStudyGroupLocation();
        if (this.applyRules((DocumentEvent)new AddProcedureLocationEvent(protocolForm.getIacucProtocolDocument(), newIacucProtocolStudyGroupLocation))) {
            this.getIacucProtocolProcedureService().addProcedureLocation(newIacucProtocolStudyGroupLocation, this.getIacucProtocol(form));
            protocolForm.getIacucProtocolProceduresHelper().setNewIacucProtocolStudyGroupLocation(new IacucProtocolStudyGroupLocation());
        }
        return mapping.findForward("location");
    }

    public ActionForward addProcedureGroupLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
        IacucProtocolStudyGroup selectedStudyGroup = this.getSelectedStudyGroup(request, selectedIacucProtocolStudyGroupBean);
        IacucProtocolStudyGroupLocation newStudyGroupLocation = selectedStudyGroup.getNewIacucProtocolStudyGroupLocation();
        if (this.applyRules((DocumentEvent)new AddProcedureLocationEvent(protocolForm.getIacucProtocolDocument(), newStudyGroupLocation))) {
            this.getIacucProtocolProcedureService().addProcedureGroupLocation(newStudyGroupLocation, selectedStudyGroup, this.getIacucProtocol((ActionForm)protocolForm));
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateIacucProtocolStudyGroupCategory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    @Override
    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        this.getIacucProtocolProcedureService().synchronizeProtocolStudyGroups(this.getIacucProtocol(form));
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.save(mapping, form, request, response);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        return mapping.findForward(this.getProcedureActionForward(protocolForm));
    }

    public ActionForward deleteProcedureLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupLocation procedureLocation = this.getSelectedProcedureLocation(protocolForm, request);
        String locationName = procedureLocation.getIacucLocationName().getLocationName();
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROCEDURE_LOCATION_KEY, "question.iacuc.procedure.location.delete.confirmation", locationName), CONFIRM_DELETE_PROCEDURE_LOCATION_KEY, "");
    }

    public ActionForward deleteProcedureGroupPersonResponsible(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
        IacucProtocolStudyGroup selectedStudyGroup = this.getSelectedStudyGroup(request, selectedIacucProtocolStudyGroupBean);
        int selectedPersonIndex = this.getSelectedBeanIndex(request, BEAN_PERSON_FIND_PARAM_START, FIND_PARAM_END);
        IacucProcedurePersonResponsible selectedPersonResponsible = selectedStudyGroup.getIacucProcedurePersonResponsibleList().get(selectedPersonIndex);
        this.getIacucProtocolProcedureService().deleteProcedureGroupPersonResponsible(selectedStudyGroup, selectedPersonResponsible, this.getIacucProtocol(form));
        return mapping.findForward("basic");
    }

    public ActionForward deleteProcedureGroupLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
        IacucProtocolStudyGroup selectedStudyGroup = this.getSelectedStudyGroup(request, selectedIacucProtocolStudyGroupBean);
        int selectedLocationIndex = this.getSelectedBeanIndex(request, BEAN_LOCATION_FIND_PARAM_START, FIND_PARAM_END);
        IacucProtocolStudyGroupLocation selectedStudyGroupLocation = selectedStudyGroup.getIacucProcedureLocationResponsibleList().get(selectedLocationIndex);
        String groupName = selectedStudyGroup.getIacucProtocolSpecies().getGroupAndSpecies();
        String locationName = selectedStudyGroupLocation.getIacucLocationName().getLocationName();
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROCEDURE_GROUP_LOCATION_KEY, "question.iacuc.procedure.group.location.delete.confirmation", groupName, locationName), CONFIRM_DELETE_PROCEDURE_GROUP_LOCATION_KEY, "");
    }

    public ActionForward confirmDeleteProcedureGroupLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROCEDURE_GROUP_LOCATION_KEY.equals(question)) {
            IacucProtocolForm protocolForm = (IacucProtocolForm)form;
            IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = this.getSelectedProcedureBean(request, protocolForm.getIacucProtocolDocument());
            IacucProtocolStudyGroup selectedStudyGroup = this.getSelectedStudyGroup(request, selectedIacucProtocolStudyGroupBean);
            int selectedLocationIndex = this.getSelectedBeanIndex(request, BEAN_LOCATION_FIND_PARAM_START, FIND_PARAM_END);
            IacucProtocolStudyGroupLocation selectedStudyGroupLocation = selectedStudyGroup.getIacucProcedureLocationResponsibleList().get(selectedLocationIndex);
            this.getIacucProtocolProcedureService().deleteProcedureGroupLocation(selectedStudyGroup, selectedStudyGroupLocation, this.getIacucProtocol(form));
        }
        return mapping.findForward("location");
    }

    public ActionForward confirmDeleteProcedureLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROCEDURE_LOCATION_KEY.equals(question)) {
            IacucProtocolForm protocolForm = (IacucProtocolForm)form;
            IacucProtocolStudyGroupLocation procedureLocation = this.getSelectedProcedureLocation(protocolForm, request);
            this.getIacucProtocolProcedureService().deleteProcedureLocation(procedureLocation, this.getIacucProtocol((ActionForm)protocolForm));
        }
        return mapping.findForward("location");
    }

    private IacucProtocolStudyGroupLocation getSelectedProcedureLocation(IacucProtocolForm protocolForm, HttpServletRequest request) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolStudyGroupLocation procedureLocation = document.getIacucProtocol().getIacucProtocolStudyGroupLocations().get(this.getLineToDelete(request));
        return procedureLocation;
    }

    @Override
    protected IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return (IacucProtocolProcedureService)KcServiceLocator.getService("iacucProtocolProcedureService");
    }

    protected IacucProtocolStudyGroup getSelectedStudyGroup(HttpServletRequest request, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        int selectedStudyGroupIndex = this.getSelectedBeanIndex(request, BEAN_STUDY_GROUP_FIND_PARAM_START, FIND_PARAM_END);
        return selectedProtocolStudyGroupBean.getIacucProtocolStudyGroups().get(selectedStudyGroupIndex);
    }

    protected IacucProtocolSpeciesStudyGroup getSelectedSpeciesStudyGroup(HttpServletRequest request, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        int selectedStudyGroupIndex = this.getSelectedBeanIndex(request, BEAN_STUDY_GROUP_SPECIES_FIND_PARAM_START, FIND_PARAM_END);
        return selectedProtocolStudyGroupBean.getIacucProtocolSpeciesStudyGroups().get(selectedStudyGroupIndex);
    }

    protected IacucProtocolStudyGroupBean getSelectedProcedureBean(HttpServletRequest request, IacucProtocolDocument document) {
        int selectedBeanIndex = this.getSelectedBeanIndex(request, BEAN_FIND_PARAM_START, FIND_PARAM_END);
        return document.getIacucProtocol().getIacucProtocolStudyGroupBeans().get(selectedBeanIndex);
    }

    protected int getSelectedBeanIndex(HttpServletRequest request, String beanNameOpen, String beanNameClose) {
        int selectedBeanIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            selectedBeanIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)beanNameOpen, (String)beanNameClose));
        }
        return selectedBeanIndex;
    }

    @Override
    protected IacucProtocol getIacucProtocol(ActionForm form) {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        return protocolForm.getIacucProtocolDocument().getIacucProtocol();
    }

    public ActionForward updateProcedures(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (protocolForm.getIacucProtocolProceduresHelper().isModifyProtocolProcedures()) {
            super.save(mapping, form, request, response);
        }
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.PROCEDURES);
        return mapping.findForward("basic");
    }

    public ActionForward updatePersonnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ActionForward forward = mapping.findForward("personnel");
        if (protocolForm.getIacucProtocolProceduresHelper().isModifyProtocolProcedures()) {
            if (this.isSaveProcedureValid(form)) {
                super.save(mapping, form, request, response);
            } else {
                return mapping.findForward("basic");
            }
        }
        this.getIacucProtocolProcedureService().populateIacucSpeciesPersonProcedures(this.getIacucProtocol((ActionForm)protocolForm));
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.PERSONNEL);
        return forward;
    }

    public ActionForward updateLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ActionForward forward = mapping.findForward("location");
        if (protocolForm.getIacucProtocolProceduresHelper().isModifyProtocolProcedures()) {
            if (this.isSaveProcedureValid(form)) {
                super.save(mapping, form, request, response);
            } else {
                return mapping.findForward("basic");
            }
        }
        this.getIacucProtocolProcedureService().populateIacucSpeciesLocationProcedures(this.getIacucProtocol((ActionForm)protocolForm));
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.LOCATION);
        return forward;
    }

    public ActionForward updateSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ActionForward forward = mapping.findForward("summary");
        if (protocolForm.getIacucProtocolProceduresHelper().isModifyProtocolProcedures()) {
            if (this.isSaveProcedureValid(form)) {
                super.save(mapping, form, request, response);
            } else {
                return mapping.findForward("basic");
            }
        }
        this.getIacucProtocolProcedureService().setProcedureSummaryBySpeciesGroup(this.getIacucProtocol(form));
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.SUMMARY);
        protocolForm.getIacucProtocolProceduresHelper().setSummaryGroupedBySpecies(false);
        return forward;
    }

    public ActionForward setEditLocationProcedures(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol iacucProtocol = this.getIacucProtocol((ActionForm)protocolForm);
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.LOCATION);
        this.getIacucProtocolProcedureService().addLocationResponsibleProcedures(iacucProtocol);
        super.save(mapping, form, request, response);
        return mapping.findForward("location");
    }

    public ActionForward setEditPersonProcedures(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol iacucProtocol = this.getIacucProtocol((ActionForm)protocolForm);
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.PERSONNEL);
        this.getIacucProtocolProcedureService().addPersonResponsibleProcedures(iacucProtocol);
        super.save(mapping, form, request, response);
        return mapping.findForward("personnel");
    }

    private boolean isSaveProcedureValid(ActionForm form) {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.PROCEDURES);
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocolDocumentRule protocolDocumentRule = new IacucProtocolDocumentRule();
        return protocolDocumentRule.isProtocolStudyGroupValid(protocolDocument);
    }

    public ActionForward summaryBySpecies(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        this.getIacucProtocolProcedureService().setProcedureSummaryGroupedBySpecies(this.getIacucProtocol(form));
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.SUMMARY);
        protocolForm.getIacucProtocolProceduresHelper().setSummaryGroupedBySpecies(true);
        return mapping.findForward("summary");
    }

    public ActionForward summaryByGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        this.getIacucProtocolProcedureService().setProcedureSummaryBySpeciesGroup(this.getIacucProtocol(form));
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.SUMMARY);
        protocolForm.getIacucProtocolProceduresHelper().setSummaryGroupedBySpecies(false);
        return mapping.findForward("summary");
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        protocolForm.getIacucProtocolProceduresHelper().setCurrentProcedureDetailTab(IacucProcedureNavigation.PROCEDURES);
        return actionForward;
    }

    private String getProcedureActionForward(IacucProtocolForm protocolForm) {
        IacucProcedureNavigation currentProcedureTab = protocolForm.getIacucProtocolProceduresHelper().getCurrentProcedureDetailTab();
        String procedureActionForwardName = "basic";
        switch (currentProcedureTab) {
            case PERSONNEL: {
                procedureActionForwardName = "personnel";
                break;
            }
            case LOCATION: {
                procedureActionForwardName = "location";
                break;
            }
            case SUMMARY: {
                procedureActionForwardName = "summary";
            }
        }
        return procedureActionForwardName;
    }
}

