/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.framework.core;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class BaseQuestionnaireAuditRule<T extends KcTransactionalDocumentBase>
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final String MANDATORY_QUESTIONNAIRE_AUDIT_ERRORS = "mandatoryQuestionnaireAuditErrors";
    private List<AuditError> auditErrors;

    protected abstract List<Integer> getIncompleteMandatoryQuestionnaire(T var1);

    public boolean processRunAuditBusinessRules(Document document) {
        KcTransactionalDocumentBase inDocument = (KcTransactionalDocumentBase)document;
        this.auditErrors = new ArrayList<AuditError>();
        List<Integer> headerIds = this.getIncompleteMandatoryQuestionnaire(inDocument);
        if (!headerIds.isEmpty()) {
            this.addErrorToAuditErrors(headerIds);
        }
        this.reportAndCreateAuditCluster(this.getAuditErrorsLabel());
        return headerIds.isEmpty();
    }

    protected List<Integer> getIncompleteMandatoryQuestionnaire(String ModuleCode, ModuleQuestionnaireBean moduleQuestionnaireBean) {
        ArrayList<Integer> headers = new ArrayList<Integer>();
        int i = 0;
        for (AnswerHeader answerHeader : this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean)) {
            if (this.getQuestionnaireUsage(ModuleCode, moduleQuestionnaireBean.getModuleSubItemCode(), answerHeader.getQuestionnaire().getQuestionnaireUsages()).isMandatory() && !answerHeader.isCompleted()) {
                headers.add(i);
            }
            ++i;
        }
        return headers;
    }

    protected abstract String getAuditErrorLink();

    protected abstract String getAuditErrorsLabel();

    protected QuestionnaireUsage getQuestionnaireUsage(String moduleItemCode, String moduleSubItemCode, List<QuestionnaireUsage> questionnaireUsages) {
        QuestionnaireUsage usage = null;
        int version = 0;
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (!moduleItemCode.equals(questionnaireUsage.getModuleItemCode()) || !moduleSubItemCode.equals(questionnaireUsage.getModuleSubItemCode()) || questionnaireUsage.getQuestionnaireSequenceNumber() <= version) continue;
            version = questionnaireUsage.getQuestionnaireSequenceNumber();
            usage = questionnaireUsage;
        }
        return usage;
    }

    protected void addErrorToAuditErrors(List<Integer> headerIds) {
        for (Integer id : headerIds) {
            this.auditErrors.add(new AuditError("questionnaireHelper.answerHeaders[" + id + "].answers[0].answer", "error.mandatory.questionnaire", this.getAuditErrorLink()));
        }
    }

    protected void reportAndCreateAuditCluster(String label) {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(MANDATORY_QUESTIONNAIRE_AUDIT_ERRORS, new AuditCluster(label, this.auditErrors, "Error"));
        }
    }

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KcServiceLocator.getService(QuestionnaireAnswerService.class);
    }
}

