/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.override;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.propdev.api.s2s.override.S2sOverrideApplicationDataContract;
import org.kuali.coeus.propdev.impl.s2s.FormUtilityService;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideAttachment;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.file.FileMeta;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Entity
@Table(name="S2S_OVERRIDE_APPL_DATA")
public class S2sOverrideApplicationData
extends KcPersistableBusinessObjectBase
implements S2sOverrideApplicationDataContract,
FileMeta,
Identifiable {
    private static final Logger LOG = LogManager.getLogger(S2sOverrideApplicationData.class);
    @PortableSequenceGenerator(name="SEQ_S2S_OVERRIDE_APPL_DATA_ID")
    @GeneratedValue(generator="SEQ_S2S_OVERRIDE_APPL_DATA_ID")
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="APPLICATION")
    @Lob
    private String application;
    @Column(name="FILE_NAME")
    private String name;
    @OneToMany(mappedBy="application", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="contentId ASC")
    private List<S2sOverrideAttachment> attachments;
    @RequestAccessible
    @Transient
    private MultipartFile multipartFile;
    @Transient
    private transient String url;
    @Transient
    private transient DateTimeService dateTimeService;
    @Transient
    private transient KcAttachmentService kcAttachmentService;
    @Transient
    private transient GrantApplicationHashService grantApplicationHashService;
    @Transient
    private transient FormUtilityService formUtilityService;

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public List<S2sOverrideAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<S2sOverrideAttachment> attachments) {
        this.attachments = attachments;
    }

    public void init(MultipartFile multipartFile) throws IOException {
        this.application = new String(multipartFile.getBytes());
        this.name = multipartFile.getName();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.getContentType();
    }

    public byte[] getData() {
        return this.application != null ? this.application.getBytes() : new byte[]{};
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContentType() {
        return "text/xml";
    }

    public void setContentType(String contentType) {
    }

    public Long getSize() {
        return this.application != null ? (long)this.application.length() : 0L;
    }

    public void setSize(Long size) {
    }

    public String getSizeFormatted() {
        return this.getKcAttachmentService().formatFileSizeString(this.getSize());
    }

    public Date getDateUploaded() {
        return this.getUpdateTimestamp();
    }

    public void setDateUploaded(Date dateUploaded) {
        this.setUpdateTimestamp(new Timestamp(dateUploaded.getTime()));
    }

    public String getDateUploadedFormatted() {
        if (this.getUpdateTimestamp() != null) {
            return this.getDateTimeService().toString(new Date(this.getUpdateTimestamp().getTime()), "MM/dd/yyyy hh:mm a");
        }
        return "";
    }

    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    public void setMultipartFile(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R doToHeaderVersion1(BiFunction<Document, NodeList, R> headerFunction, String applicationXml) {
        if (!StringUtils.isNotBlank((CharSequence)applicationXml)) return null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.application.getBytes(StandardCharsets.UTF_8));){
            Document appDoc = this.getFormUtilityService().createDomBuilder().parse(byteArrayInputStream);
            NodeList headers = appDoc.getElementsByTagNameNS("http://apply.grants.gov/system/Header-V1.0", "GrantSubmissionHeader");
            R r = headerFunction.apply(appDoc, headers);
            return r;
        }
        catch (IOException | RuntimeException | ParserConfigurationException | SAXException e) {
            if (!LOG.isInfoEnabled()) return null;
            LOG.info(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean isHeaderVersion1Form() {
        Boolean exists = this.doToHeaderVersion1((appDoc, headers) -> headers != null && headers.getLength() > 0, this.application);
        return exists != null ? exists : false;
    }

    public String getSha1Hash() {
        return this.doToHeaderVersion1((appDoc, headers) -> {
            for (int i = 0; i < headers.getLength(); ++i) {
                Node header = headers.item(i);
                header.getParentNode().removeChild(header);
            }
            try {
                return this.getGrantApplicationHashService().computeGrantFormsHash(this.getFormUtilityService().docToString((Document)appDoc));
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        }, this.application);
    }

    public String getSha1HashInXml() {
        Node hashNode;
        if (StringUtils.isNotBlank((CharSequence)this.application) && (hashNode = this.getSha1HashInXmlNode()) != null) {
            return hashNode.getTextContent();
        }
        return null;
    }

    public Node getSha1HashInXmlNode() {
        return this.doToHeaderVersion1((appDoc, headers) -> {
            for (int i = 0; i < headers.getLength(); ++i) {
                Node header = headers.item(i);
                Node hashValueNode = this.getFormUtilityService().getHashValueFromParent(header);
                if (hashValueNode == null) continue;
                return hashValueNode;
            }
            return null;
        }, this.application);
    }

    public boolean updateSha1HashInXml() {
        block3: {
            Node xmlHash;
            String actualHash = this.getSha1Hash();
            if (StringUtils.isNotBlank((CharSequence)actualHash) && (xmlHash = this.getSha1HashInXmlNode()) != null && !actualHash.equals(xmlHash.getTextContent())) {
                xmlHash.setTextContent(actualHash);
                try {
                    this.setApplication(this.getFormUtilityService().docToString(xmlHash.getOwnerDocument()));
                    return true;
                }
                catch (TransformerException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    public void setKcAttachmentService(KcAttachmentService kcAttachmentService) {
        this.kcAttachmentService = kcAttachmentService;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        if (this.grantApplicationHashService == null) {
            this.grantApplicationHashService = KcServiceLocator.getService(GrantApplicationHashService.class);
        }
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }

    public FormUtilityService getFormUtilityService() {
        if (this.formUtilityService == null) {
            this.formUtilityService = KcServiceLocator.getService(FormUtilityService.class);
        }
        return this.formUtilityService;
    }

    public void setFormUtilityService(FormUtilityService formUtilityService) {
        this.formUtilityService = formUtilityService;
    }
}

