/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.table;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.table.IacucProtocolTableBean;
import org.kuali.kra.iacuc.actions.table.IacucProtocolTableService;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class IacucProtocolTableServiceImpl
implements IacucProtocolTableService {
    private ProtocolActionService protocolActionService;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    protected ProtocolVersionService protocolVersionService;

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public CommitteeScheduleBase getNextScheduleForCommittee(CommitteeScheduleBase currentSchedule) {
        CommitteeScheduleBase retVal = null;
        if (null != currentSchedule && null != currentSchedule.getCommitteeIdFk()) {
            List schedules;
            currentSchedule.refreshReferenceObject("committee");
            Object committee = currentSchedule.getParentCommittee();
            if (null != committee && null != (schedules = ((CommitteeBase)committee).getCommitteeSchedules())) {
                Collections.sort(schedules);
                for (CommitteeScheduleBase schedule : schedules) {
                    int indexOfSchedule;
                    if (!StringUtils.equals((CharSequence)schedule.getScheduleId(), (CharSequence)currentSchedule.getScheduleId()) || (indexOfSchedule = schedules.indexOf(schedule)) + 1 >= schedules.size()) continue;
                    retVal = (CommitteeScheduleBase)schedules.get(indexOfSchedule + 1);
                }
            }
        }
        return retVal;
    }

    private void bumpSubmissionToNextSchedule(IacucProtocolSubmission submission) {
        CommitteeScheduleBase originalSchedule = submission.getCommitteeSchedule();
        CommitteeScheduleBase nextSchedule = this.getNextScheduleForCommittee(originalSchedule);
        if (null != nextSchedule) {
            submission.setScheduleId(nextSchedule.getScheduleId());
            submission.setScheduleIdFk(nextSchedule.getId());
            submission.setCommitteeSchedule(nextSchedule);
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("protocolIdFk", submission.getProtocolId().toString());
            fieldValues.put("scheduleIdFk", originalSchedule.getId().toString());
            List minutes = (List)this.businessObjectService.findMatching(IacucCommitteeScheduleMinute.class, fieldValues);
            if (!minutes.isEmpty()) {
                nextSchedule.getCommitteeScheduleMinutes().addAll(minutes);
                this.getBusinessObjectService().save((PersistableBusinessObject)nextSchedule);
            }
        }
    }

    @Override
    public IacucProtocolDocument tableProtocol(IacucProtocol protocol, IacucProtocolTableBean actionBean) throws Exception {
        IacucProtocolSubmission submission = (IacucProtocolSubmission)protocol.getProtocolSubmission();
        this.bumpSubmissionToNextSchedule(submission);
        IacucProtocolAction protocolAction = new IacucProtocolAction(protocol, submission, "203");
        protocolAction.setComments(actionBean.getComments());
        protocolAction.setActionDate(new Timestamp(actionBean.getActionDate().getTime()));
        protocol.getProtocolActions().add(protocolAction);
        this.getProtocolActionService().updateProtocolStatus(protocolAction, protocol);
        this.getDocumentService().saveDocument((Document)protocol.getProtocolDocument());
        return this.getNewProtocolDocument(protocol);
    }

    private IacucProtocolDocument getNewProtocolDocument(IacucProtocol protocol) throws Exception {
        this.documentService.cancelDocument((Document)protocol.getProtocolDocument(), "Protocol document cancelled - protocol has been returned for revisions.");
        IacucProtocolDocument newProtocolDocument = (IacucProtocolDocument)this.getProtocolVersionService().versionProtocolDocument(protocol.getProtocolDocument());
        newProtocolDocument.getProtocol().setProtocolSubmission(null);
        newProtocolDocument.getProtocol().setApprovalDate(null);
        newProtocolDocument.getProtocol().setLastApprovalDate(null);
        newProtocolDocument.getProtocol().setExpirationDate(null);
        newProtocolDocument.getProtocol().refreshReferenceObject("protocolStatus");
        newProtocolDocument.getProtocol().refreshReferenceObject("protocolSubmission");
        this.documentService.saveDocument((Document)newProtocolDocument);
        return newProtocolDocument;
    }

    public ProtocolVersionService getProtocolVersionService() {
        return this.protocolVersionService;
    }

    public void setProtocolVersionService(ProtocolVersionService protocolVersionService) {
        this.protocolVersionService = protocolVersionService;
    }
}

