/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class ProtocolOnlineReviewLookupableHelperServiceImplBase
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 7269604308213091097L;
    private DictionaryValidationService dictionaryValidationService;
    private static final String REVIEWER_EMPLOYEE = "lookupReviewerPersonId";
    private static final String REVIEWER_NONEMPLOYEE = "lookupReviewerRolodexId";
    private static final String LOOKUP_PROTOCOL_ONLINE_REVIEW_STATUS_CODES = "lookupProtocolOnlineReviewStatusCode";
    private static final String PROTOCOL_NUMBER = "lookupProtocol.protocolNumber";
    private static final String PROTOCOL_REVIEW_DUE_DATE = "lookupDateDue";
    private static final String OBJ_PROTOCOLREVIEWER_REVIEWER_EMPLOYEE = "protocolReviewer.personId";
    private static final String OBJ_PROTOCOLREVIEWER_NONEMPLOYEE = "protocolReviewer.personId";
    private static final String OBJ_PROTOCOL_PROTOCOL_NUMBER = "protocol.protocolNumber";
    private static final String OBJ_PROTOCOL_ONLINE_REVIEW_STATUS_CODE = "protocolOnlineReviewStatusCode";
    private static final String OBJ_PROTOCOL_REVIEW_DUE_DATE = "protocol.dateDue";

    @Override
    protected abstract String getDocumentTypeName();

    @Override
    protected abstract String getHtmlAction();

    @Override
    protected String getKeyFieldName() {
        return "protocolOnlineReviewId";
    }

    public DictionaryValidationService getDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }

    protected boolean validateDate(String dateFieldName, String dateFieldValue) {
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(dateFieldValue);
            return true;
        }
        catch (ParseException e) {
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
    }

    public void validateSearchParameters(Map fieldValues) {
        Map fvalues = fieldValues;
        super.validateSearchParameters(fieldValues);
        Set keys = fieldValues.keySet();
        for (String key : keys) {
            String value = fieldValues.get(key).toString();
            if (key.toUpperCase().indexOf("DATE") <= 0 || value.indexOf("..") != -1 || value.indexOf(">=") != -1 || value.indexOf("<=") != -1 || !StringUtils.isNotBlank((CharSequence)value)) continue;
            this.validateDate(key, value);
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)fvalues.get(REVIEWER_NONEMPLOYEE))) && StringUtils.isNotBlank((CharSequence)((CharSequence)fvalues.get(REVIEWER_EMPLOYEE)))) {
            GlobalVariables.getMessageMap().putError(REVIEWER_NONEMPLOYEE, "error.protocol.onlinereview.search.onlyoneperson", new String[0]);
        }
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.validateSearchParameters(fieldValues);
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get(REVIEWER_EMPLOYEE))) {
            fieldValues.put("protocolReviewer.personId", fieldValues.get(REVIEWER_EMPLOYEE));
        } else if (StringUtils.isNotBlank((CharSequence)fieldValues.get(REVIEWER_NONEMPLOYEE))) {
            fieldValues.put("protocolReviewer.personId", fieldValues.get(REVIEWER_NONEMPLOYEE));
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get(PROTOCOL_REVIEW_DUE_DATE))) {
            fieldValues.put(OBJ_PROTOCOL_REVIEW_DUE_DATE, fieldValues.get(PROTOCOL_REVIEW_DUE_DATE));
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get(PROTOCOL_NUMBER))) {
            fieldValues.put(OBJ_PROTOCOL_PROTOCOL_NUMBER, fieldValues.get(PROTOCOL_NUMBER));
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get(LOOKUP_PROTOCOL_ONLINE_REVIEW_STATUS_CODES))) {
            fieldValues.put(OBJ_PROTOCOL_ONLINE_REVIEW_STATUS_CODE, fieldValues.get(LOOKUP_PROTOCOL_ONLINE_REVIEW_STATUS_CODES));
        }
        fieldValues.remove(PROTOCOL_REVIEW_DUE_DATE);
        fieldValues.remove(REVIEWER_NONEMPLOYEE);
        fieldValues.remove(REVIEWER_EMPLOYEE);
        fieldValues.remove(PROTOCOL_NUMBER);
        fieldValues.remove(LOOKUP_PROTOCOL_ONLINE_REVIEW_STATUS_CODES);
        super.setBackLocationDocFormKey(fieldValues);
        List results = super.getSearchResults(fieldValues);
        return this.filterResults(results);
    }

    protected abstract List<ProtocolOnlineReviewBase> filterResults(List<ProtocolOnlineReviewBase> var1);

    protected abstract String getProtocolSubmissionApprovedStatusCodeHook();

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
        ProtocolOnlineReviewBase protocolOnlineReview = (ProtocolOnlineReviewBase)businessObject;
        if (this.getProtocolOLRSavedStatusCodeHook().equals(protocolOnlineReview.getProtocolOnlineReviewStatusCode())) {
            htmlDataList.add((HtmlData)this.getEditLinkForDocument((Document)protocolOnlineReview.getProtocolOnlineReviewDocument()));
        } else {
            htmlDataList.add((HtmlData)this.getViewLink(protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber()));
        }
    }

    protected abstract String getProtocolOLRSavedStatusCodeHook();

    @Override
    protected HtmlData.AnchorHtmlData getViewLink(String documentNumber) {
        Properties parameters = this.getLinkProperties(documentNumber);
        parameters.put("viewDocument", "true");
        String displayText = "view";
        return this.getAnchorHtmlData(parameters, displayText);
    }

    private HtmlData.AnchorHtmlData getEditLinkForDocument(Document document) {
        Properties parameters = this.getLinkProperties(document.getDocumentNumber());
        String displayText = "edit";
        return this.getAnchorHtmlData(parameters, displayText);
    }

    private Properties getLinkProperties(String documentNumber) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "redirectToProtocolFromReview");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("docId", documentNumber);
        return parameters;
    }

    private HtmlData.AnchorHtmlData getAnchorHtmlData(Properties parameters, String displayText) {
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        return new HtmlData.AnchorHtmlData(href, "docHandler", displayText);
    }
}

