/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.distribution;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleBase;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetUnrecoveredFandAAuditRule")
public class BudgetUnrecoveredFandAAuditRule
extends BudgetAuditRuleBase {
    public static final String BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY = "budgetUnrecoveredFandAAuditErrors";
    public static final String BUDGET_UNRECOVERED_F_AND_A_WARNING_KEY = "budgetUnrecoveredFandAAuditWarnings";
    private static final String[] PARAMS = new String[]{"Unrecovered F and A"};
    @Autowired
    @Qualifier(value="fiscalYearMonthService")
    private FiscalYearMonthService fiscalYearMonthService;

    @KcEventMethod
    @Deprecated
    public boolean processRunAuditBusinessRules(BudgetAuditEvent event) {
        Budget budget = event.getBudget();
        if (GlobalVariables.getAuditErrorMap().containsKey(BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY)) {
            List auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY)).getAuditErrorList();
            auditErrors.clear();
        }
        if (!budget.isUnrecoveredFandAApplicable().booleanValue()) {
            return true;
        }
        List<BudgetUnrecoveredFandA> unrecoveredFandAs = budget.getBudgetUnrecoveredFandAs();
        boolean retval = true;
        if (budget.getUnallocatedUnrecoveredFandA().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budget.isUnrecoveredFandAEnforced().booleanValue()) {
            retval = false;
            if (unrecoveredFandAs.size() == 0) {
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetUnrecoveredFandA", PARAMS));
            }
            for (int i = 0; i < unrecoveredFandAs.size(); ++i) {
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].amount", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetUnrecoveredFandA", PARAMS));
            }
        }
        int i = 0;
        BudgetParent budgetParent = budget.getBudgetParent();
        boolean duplicateEntryFound = false;
        for (BudgetUnrecoveredFandA unrecoveredFandA : unrecoveredFandAs) {
            String source = unrecoveredFandA.getSourceAccount();
            Integer fiscalYear = unrecoveredFandA.getFiscalYear();
            if (null == source || source.length() == 0) {
                retval = false;
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].sourceAccount", "error.budget.distribution.sourceMissing", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.getParamsForMissingSourceEntry(i)));
            }
            if (null == fiscalYear || fiscalYear <= 0) {
                retval = false;
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].fiscalYear", "error.budget.distribution.fiscalYearMissing", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.getParamsForEntry(i)));
            }
            Calendar projectStartDate = Calendar.getInstance();
            projectStartDate.setTime(budgetParent.getRequestedStartDateInitial());
            Calendar projectEndDate = Calendar.getInstance();
            projectEndDate.setTime(budgetParent.getRequestedEndDateInitial());
            if (fiscalYear != null && (fiscalYear < this.fiscalYearMonthService.getFiscalYearFromDate(projectStartDate) || fiscalYear > this.fiscalYearMonthService.getFiscalYearFromDate(projectEndDate))) {
                this.getAuditWarnings().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].fiscalYear", "warning.budget.distribution.fiscalYearInconsistent", "budgetDistributionAndIncome.budgetUnrecoveredFandA", PARAMS));
            }
            if (!duplicateEntryFound) {
                int j = 0;
                for (BudgetUnrecoveredFandA unrecoveredFandAForComparison : unrecoveredFandAs) {
                    if (i != j && unrecoveredFandA.getFiscalYear() != null && unrecoveredFandAForComparison.getFiscalYear() != null && unrecoveredFandA.getFiscalYear().intValue() == unrecoveredFandAForComparison.getFiscalYear().intValue() && unrecoveredFandA.getApplicableRate().equals((Object)unrecoveredFandAForComparison.getApplicableRate()) && unrecoveredFandA.getOnCampusFlag().equalsIgnoreCase(unrecoveredFandAForComparison.getOnCampusFlag()) && StringUtils.equalsIgnoreCase((CharSequence)unrecoveredFandA.getSourceAccount(), (CharSequence)unrecoveredFandAForComparison.getSourceAccount()) && unrecoveredFandA.getAmount().equals((Object)unrecoveredFandAForComparison.getAmount())) {
                        retval = false;
                        this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "]", "error.budget.distribution.duplicate.unrecoveredFA", "budgetDistributionAndIncome.budgetUnrecoveredFandA", PARAMS));
                        duplicateEntryFound = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return retval;
    }

    @KcEventMethod
    public boolean processRunAuditBusinessRules(BudgetAuditRuleEvent event) {
        Budget budget = event.getBudget();
        boolean retval = true;
        List<BudgetUnrecoveredFandA> unrecoveredFandAs = budget.getBudgetUnrecoveredFandAs();
        if (budget.isUnrecoveredFandAApplicable().booleanValue() && budget.isUnrecoveredFandAEnforced().booleanValue()) {
            retval = this.verifyUnrecoveredFA(budget, unrecoveredFandAs);
            retval &= this.verifySourceAccount(budget, unrecoveredFandAs);
        }
        return retval;
    }

    protected boolean verifyUnrecoveredFA(Budget budget, List<BudgetUnrecoveredFandA> unrecoveredFandAs) {
        boolean retval = true;
        BudgetConstants.BudgetAuditRules budgetUnrecoveredFARule = BudgetConstants.BudgetAuditRules.UNRECOVERED_FA;
        if (budget.getUnallocatedUnrecoveredFandA().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            retval = false;
            List<AuditError> auditErrors = this.getAuditErrors(budgetUnrecoveredFARule, true);
            if (unrecoveredFandAs.isEmpty()) {
                auditErrors.add(new AuditError("budget.budgetUnrecoveredFandA", "error.budget.distribution.unallocatedMustBeZero", budgetUnrecoveredFARule.getPageId(), PARAMS));
                retval = false;
            } else {
                auditErrors.add(new AuditError(budgetUnrecoveredFARule.getPageId(), "error.budget.distribution.unallocatedMustBeZero", budgetUnrecoveredFARule.getPageId(), PARAMS));
                retval = false;
            }
        }
        return retval;
    }

    protected boolean verifySourceAccount(Budget budget, List<BudgetUnrecoveredFandA> unrecoveredFandAs) {
        boolean retval = true;
        BudgetParent budgetParent = budget.getBudgetParent();
        BudgetConstants.BudgetAuditRules budgetUnrecoveredFARule = BudgetConstants.BudgetAuditRules.UNRECOVERED_FA;
        List<AuditError> auditErrors = this.getAuditErrors(budgetUnrecoveredFARule, true);
        List<AuditError> auditWarnings = this.getAuditErrors(budgetUnrecoveredFARule, false);
        boolean duplicateEntryFound = false;
        for (int i = 0; i < unrecoveredFandAs.size(); ++i) {
            BudgetUnrecoveredFandA unrecoveredFandA = unrecoveredFandAs.get(i);
            String source = unrecoveredFandA.getSourceAccount();
            Integer fiscalYear = unrecoveredFandA.getFiscalYear();
            if (StringUtils.isEmpty((CharSequence)source) || source.length() == 0) {
                auditErrors.add(new AuditError(budgetUnrecoveredFARule.getPageId(), "error.budget.distribution.sourceMissing", budgetUnrecoveredFARule.getPageId(), this.getParamsForMissingSourceEntry(i)));
                retval = false;
            }
            if (fiscalYear == null || fiscalYear <= 0) {
                auditErrors.add(new AuditError(budgetUnrecoveredFARule.getPageId(), "error.budget.distribution.fiscalYearMissing", budgetUnrecoveredFARule.getPageId(), this.getParamsForEntry(i)));
                retval = false;
            }
            if (StringUtils.isBlank((CharSequence)unrecoveredFandA.getOnCampusFlag())) {
                auditErrors.add(new AuditError(budgetUnrecoveredFARule.getPageId(), "error.budget.distribution.onCampusFlagMissing", budgetUnrecoveredFARule.getPageId(), this.getParamsForEntry(i)));
                retval = false;
            }
            Calendar projectStartDate = Calendar.getInstance();
            projectStartDate.setTime(budgetParent.getRequestedStartDateInitial());
            Calendar projectEndDate = Calendar.getInstance();
            projectEndDate.setTime(budgetParent.getRequestedEndDateInitial());
            if (fiscalYear != null && (fiscalYear < this.fiscalYearMonthService.getFiscalYearFromDate(projectStartDate) || fiscalYear > this.fiscalYearMonthService.getFiscalYearFromDate(projectEndDate))) {
                auditWarnings.add(new AuditError(budgetUnrecoveredFARule.getPageId(), "warning.budget.distribution.fiscalYearInconsistent", budgetUnrecoveredFARule.getPageId(), PARAMS));
                retval = true;
            }
            if (duplicateEntryFound || !unrecoveredFandAs.stream().anyMatch(duplicateFandA -> unrecoveredFandA != duplicateFandA && this.unrecoveredFAMatches(unrecoveredFandA, (BudgetUnrecoveredFandA)duplicateFandA))) continue;
            auditErrors.add(new AuditError(budgetUnrecoveredFARule.getPageId(), "error.budget.distribution.duplicate.unrecoveredFA", budgetUnrecoveredFARule.getPageId(), PARAMS));
            duplicateEntryFound = true;
            retval = false;
            break;
        }
        return retval;
    }

    protected boolean unrecoveredFAMatches(BudgetUnrecoveredFandA obj1, BudgetUnrecoveredFandA obj2) {
        return new EqualsBuilder().append((Object)obj1.getFiscalYear(), (Object)obj2.getFiscalYear()).append((Object)obj1.getApplicableRate(), (Object)obj2.getApplicableRate()).append((Object)obj1.getOnCampusFlag(), (Object)obj2.getOnCampusFlag()).append((Object)obj1.getSourceAccount(), (Object)obj2.getSourceAccount()).append((Object)obj1.getAmount(), (Object)obj2.getAmount()).isEquals();
    }

    private String[] getParamsForMissingSourceEntry(int i) {
        return new String[]{String.format("%s entry #%d", PARAMS[0], i + 1)};
    }

    private String[] getParamsForEntry(int i) {
        return new String[]{PARAMS[0], String.valueOf(i + 1)};
    }

    private List<AuditError> getAuditErrors() {
        return this.getAuditProblems(BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY, "Error");
    }

    private List<AuditError> getAuditWarnings() {
        return this.getAuditProblems(BUDGET_UNRECOVERED_F_AND_A_WARNING_KEY, "Warnings");
    }

    private List<AuditError> getAuditProblems(String key, String problemType) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(key)) {
            GlobalVariables.getAuditErrorMap().put(key, new AuditCluster("Budget Unrecovered F and A", auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }
}

