/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.docperm;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeRight;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.docperm.PermissionsRule;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.rice.krad.document.Document;

public class ProposalDevelopmentPermissionsRule
extends KcTransactionalDocumentRuleBase
implements PermissionsRule {
    private transient KcPersonService kcPersonService;
    private transient KcWorkflowService kcWorkflowService;
    private transient SystemAuthorizationService systemAuthorizationService;
    private transient GlobalVariableService globalVariableService;

    @Override
    public boolean processAddProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, ProposalUserRoles proposalUser) {
        boolean isValid = true;
        if (StringUtils.isEmpty((CharSequence)proposalUser.getUsername())) {
            isValid = false;
            this.reportError("newCollectionLines['permissionsHelper.workingUserRoles'].username", "error.empty.username", new String[0]);
        } else if (!this.isValidUser(proposalUser.getUsername())) {
            isValid = false;
            this.reportError("newCollectionLines['permissionsHelper.workingUserRoles'].username", "error.unknown.username", new String[0]);
        } else if (this.isDuplicate(proposalUser.getUsername(), proposalUserRolesList)) {
            isValid = false;
            this.reportError("newCollectionLines['permissionsHelper.workingUserRoles'].username", "error.duplicate.proposalUser", new String[0]);
        } else if (this.getKcWorkflowService().isInWorkflow((Document)document) && !this.isAddingViewerOnly(proposalUser)) {
            isValid = false;
            this.reportError("newCollectionLines['permissionsHelper.workingUserRoles'].roleName", "error.viewer.only", new String[0]);
        }
        return isValid;
    }

    @Override
    public boolean processDeleteProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, int index) {
        boolean isValid = true;
        KcWorkflowService kraWorkflowService = this.getKcWorkflowService();
        ProposalUserRoles proposalUserRole = proposalUserRolesList.get(index);
        String username = proposalUserRole.getUsername();
        if (this.hasModifyNarrativePermission(username, proposalUserRolesList)) {
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getNarratives(), "PropDev-PermissionsPage-UserTable", "Proposal Attachment");
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getInstituteAttachments(), "PropDev-PermissionsPage-UserTable", "Internal Attachment");
        }
        if (this.isLastAggregator(username, proposalUserRolesList)) {
            isValid = false;
            this.getGlobalVariableService().getMessageMap().putErrorForSectionId("PropDev-PermissionsPage-UserTable", "error.last.aggregator", new String[0]);
        } else if (this.isAggregatorInitiator(document, proposalUserRole)) {
            isValid = false;
            this.getGlobalVariableService().getMessageMap().putErrorForSectionId("PropDev-PermissionsPage-UserTable", "error.propdev.perm.initiator", new String[0]);
        } else if (kraWorkflowService.isInWorkflow((Document)document)) {
            isValid = false;
            this.getGlobalVariableService().getMessageMap().putErrorForSectionId("PropDev-PermissionsPage-UserTable", "error.viewer.only", new String[0]);
        }
        return isValid;
    }

    @Override
    public boolean processEditProposalUserRolesBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, ProposalUserRoles editRoles) {
        boolean isValid = true;
        String username = editRoles.getUsername();
        if (this.isRemovingModifyNarrativePermission(proposalUserRolesList, editRoles)) {
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getNarratives(), "PropDev-PermissionsPage-UserTable", "Proposal Attachment");
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getInstituteAttachments(), "PropDev-PermissionsPage-UserTable", "Internal Attachment");
        } else if (!this.isAggregatorRolePresent(proposalUserRolesList)) {
            isValid = false;
            this.getGlobalVariableService().getMessageMap().putErrorForSectionId("PropDev-PermissionsPage-UserTable", "error.last.aggregator", new String[0]);
        }
        return isValid;
    }

    protected boolean isAggregatorRolePresent(List<ProposalUserRoles> proposalUserRolesList) {
        for (ProposalUserRoles proposalUserRoles : proposalUserRolesList) {
            if (!this.hasAggregator(proposalUserRoles)) continue;
            return true;
        }
        return false;
    }

    private boolean isOnlyModifier(String username, Narrative narrative) {
        boolean retval = true;
        for (NarrativeUserRights narrativeUserRights : narrative.getNarrativeUserRights()) {
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(narrativeUserRights.getUserId());
            if (StringUtils.equals((CharSequence)username, (CharSequence)person.getUserName()) || !StringUtils.equals((CharSequence)narrativeUserRights.getAccessType(), (CharSequence)NarrativeRight.MODIFY_NARRATIVE_RIGHT.getAccessType())) continue;
            retval = false;
            break;
        }
        return retval;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected KcWorkflowService getKcWorkflowService() {
        if (this.kcWorkflowService == null) {
            this.kcWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kcWorkflowService;
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        if (this.systemAuthorizationService == null) {
            this.systemAuthorizationService = KcServiceLocator.getService(SystemAuthorizationService.class);
        }
        return this.systemAuthorizationService;
    }

    private boolean isRemovingModifyNarrativePermission(List<ProposalUserRoles> proposalUserRolesList, ProposalUserRoles editRoles) {
        boolean newListContainsModifyNarrative = false;
        SystemAuthorizationService systemAuthorizationService = this.getSystemAuthorizationService();
        List<String> matchingRoleNames = systemAuthorizationService.getRoleNamesForPermission("Modify Narrative", "KC-PD");
        for (String roleName : editRoles.getRoleNames()) {
            if (!matchingRoleNames.contains(roleName)) continue;
            newListContainsModifyNarrative = true;
            break;
        }
        return this.hasModifyNarrativePermission(editRoles.getUsername(), proposalUserRolesList) && !newListContainsModifyNarrative;
    }

    private boolean hasModifyNarrativePermission(String username, List<ProposalUserRoles> proposalUserRolesList) {
        SystemAuthorizationService systemAuthorizationService = this.getSystemAuthorizationService();
        List<String> matchingRoleNames = systemAuthorizationService.getRoleNamesForPermission("Modify Narrative", "KC-PD");
        for (ProposalUserRoles proposalUserRoles : proposalUserRolesList) {
            if (!proposalUserRoles.getUsername().equals(username)) continue;
            for (String roleName : proposalUserRoles.getRoleNames()) {
                if (!matchingRoleNames.contains(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean testForLastModifier(String username, List<Narrative> attachments, String errorLocationKey, String errorLabel) {
        int index = 1;
        boolean reportedError = false;
        for (Narrative attachment : attachments) {
            if (this.isOnlyModifier(username, attachment)) {
                reportedError = true;
                this.getGlobalVariableService().getMessageMap().putErrorForSectionId(errorLocationKey, "error.narrative.one.modify.with.arg", new String[]{errorLabel + " " + index});
            }
            ++index;
        }
        return reportedError;
    }

    private boolean hasAggregator(ProposalUserRoles editRoles) {
        for (String roleName : editRoles.getRoleNames()) {
            if (!this.isAggregatorRole(roleName)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidUser(String username) {
        return this.getKcPersonService().getKcPersonByUserName(username) != null;
    }

    private boolean isDuplicate(String username, List<ProposalUserRoles> proposalUserRolesList) {
        for (ProposalUserRoles userRoles : proposalUserRolesList) {
            if (!StringUtils.equals((CharSequence)username, (CharSequence)userRoles.getUsername())) continue;
            return true;
        }
        return false;
    }

    private boolean isLastAggregator(String username, List<ProposalUserRoles> proposalUserRolesList) {
        for (ProposalUserRoles userRoles : proposalUserRolesList) {
            if (StringUtils.equals((CharSequence)username, (CharSequence)userRoles.getUsername())) continue;
            List<String> roleNames = userRoles.getRoleNames();
            for (String roleName : roleNames) {
                if (!this.isAggregatorRole(roleName)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAggregatorInitiator(ProposalDevelopmentDocument document, ProposalUserRoles proposalUserRole) {
        KcPerson initiator = this.getKcPersonService().getKcPersonByPersonId(document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        if (StringUtils.equals((CharSequence)initiator.getUserName(), (CharSequence)proposalUserRole.getUsername())) {
            for (String roleName : proposalUserRole.getRoleNames()) {
                if (!this.isAggregatorRole(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAggregatorRole(String roleName) {
        return StringUtils.equals((CharSequence)roleName, (CharSequence)"Aggregator Document Level");
    }

    private boolean isAddingViewerOnly(ProposalUserRoles proposalUser) {
        return proposalUser.getRoleNames().size() == 1 && (StringUtils.equals((CharSequence)proposalUser.getRoleNames().get(0), (CharSequence)"Viewer") || StringUtils.equals((CharSequence)proposalUser.getRoleNames().get(0), (CharSequence)"Viewer Document Level"));
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

