/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.common.impl.attachment;

import co.kuali.coeus.common.impl.attachment.KcAttachmentDataToS3Conversion;
import co.kuali.rice.coreservice.api.attachment.S3FileService;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
public class KcAttachmentDataToS3ConversionImpl
extends QuartzJobBean
implements KcAttachmentDataToS3Conversion {
    private static final Logger LOG = LogManager.getLogger(KcAttachmentDataToS3ConversionImpl.class);
    private static final String QUERY_SQL_MYSQL = "select id, data from file_data where data is not null LIMIT ? OFFSET ?";
    private static final String QUERY_SQL_ORACLE = "select id, data from file_data where data is not null";
    private static final String UPDATE_SQL = "update file_data set data = null where id = ?";
    private static final String DELETE_FILE_FROM_DB = "DELETE_FILE_FROM_DB";
    private static final String DATASOURCE_PLATFORM_CFG_NM = "datasource.ojb.platform";
    private static final String MYSQL_PLATFORM = "MySQL";
    private S3FileService kcS3FileService;
    private ParameterService parameterService;
    private Integer fetchSize = 5;
    private DataSource dataSource;
    private ConfigurationService configurationService;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeInternal(JobExecutionContext context) throws JobExecutionException {
        KcAttachmentDataToS3ConversionImpl.LOG.info("Starting attachment conversion job for file_data to S3");
        hasResults = true;
        offset = 0;
        while (hasResults) {
            if (this.processRecords()) {
                try {
                    conn = this.dataSource.getConnection();
                    try {
                        queryStmt = this.mysql() != false ? conn.prepareStatement("select id, data from file_data where data is not null LIMIT ? OFFSET ?") : conn.prepareStatement("select id, data from file_data where data is not null");
                        try {
                            updateStmt = conn.prepareStatement("update file_data set data = null where id = ?");
                            try {
                                if (this.mysql()) {
                                    queryStmt.setInt(1, this.fetchSize);
                                    queryStmt.setInt(2, offset);
                                }
                                conn.setAutoCommit(false);
                                hasResults = false;
                                if (!this.mysql()) {
                                    queryStmt.setFetchSize(this.fetchSize);
                                }
                                try {
                                    rs = queryStmt.executeQuery();
                                    try {
                                        while (rs.next()) {
                                            block50: {
                                                fileDataId = rs.getString(1);
                                                dbBytes = rs.getBytes(2);
                                                s3File = this.kcS3FileService.retrieveFile(fileDataId);
                                                if (s3File == null) {
                                                    s3FileClass = Class.forName("co.kuali.coeus.s3.api.S3File");
                                                    newS3File = s3FileClass.newInstance();
                                                    setId = s3FileClass.getMethod("setId", new Class[]{String.class});
                                                    setId.invoke(newS3File, new Object[]{fileDataId});
                                                    setFileContents = s3FileClass.getMethod("setFileContents", new Class[]{InputStream.class});
                                                    stream = new BufferedInputStream(new ByteArrayInputStream(dbBytes));
                                                    try {
                                                        setFileContents.invoke(newS3File, new Object[]{stream});
                                                        this.kcS3FileService.createFile(newS3File);
                                                    }
                                                    finally {
                                                        stream.close();
                                                    }
                                                    s3Bytes = this.getBytesFromS3File(this.kcS3FileService.retrieveFile(fileDataId));
                                                } else {
                                                    if (KcAttachmentDataToS3ConversionImpl.LOG.isDebugEnabled()) {
                                                        getFileMetaData = s3File.getClass().getMethod("getFileMetaData", new Class[0]);
                                                        KcAttachmentDataToS3ConversionImpl.LOG.debug("data found in S3, existing id: " + fileDataId + " metadata: " + getFileMetaData.invoke(s3File, new Object[0]));
                                                    }
                                                    s3Bytes = this.getBytesFromS3File(s3File);
                                                }
                                                if (s3Bytes == null || dbBytes == null) break block50;
                                                s3MD5 = DigestUtils.md5Hex((byte[])s3Bytes);
                                                if (!Objects.equals(s3MD5, dbMD5 = DigestUtils.md5Hex((byte[])dbBytes))) {
                                                    KcAttachmentDataToS3ConversionImpl.LOG.error("S3 data MD5: " + s3MD5 + " does not equal DB data MD5: " + dbMD5 + " for id: " + fileDataId);
                                                    break block50;
                                                }
                                                if (!this.isDeleteFromDatabase()) break block50;
                                                updateStmt.setString(1, fileDataId);
                                                numUpdated = updateStmt.executeUpdate();
                                                if (numUpdated == 1) break block50;
                                                KcAttachmentDataToS3ConversionImpl.LOG.error("Expected to update a single row, but instead updated " + numUpdated + ". Job exiting.");
                                                conn.rollback();
                                                if (rs == null) return;
                                                rs.close();
                                                return;
                                            }
                                            hasResults = true;
                                            continue;
                                            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                        ** if (rs == null) goto lbl-1000
                                    }
                                    catch (Throwable var8_17) {
                                        if (rs == null) throw var8_17;
                                        try {
                                            rs.close();
                                            throw var8_17;
                                        }
                                        catch (Throwable var9_20) {
                                            var8_17.addSuppressed(var9_20);
                                        }
                                        throw var8_17;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        rs.close();
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                    }
                                }
                                catch (SQLException e) {
                                    conn.rollback();
                                    throw e;
                                }
                                conn.commit();
                                Thread.sleep(500L);
                            }
                            finally {
                                if (updateStmt != null) {
                                    updateStmt.close();
                                }
                            }
                        }
                        finally {
                            if (queryStmt != null) {
                                queryStmt.close();
                            }
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
                catch (SQLException e) {
                    KcAttachmentDataToS3ConversionImpl.LOG.error("Got sql exception in attachment conversion, job exiting.", (Throwable)e);
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            offset += this.fetchSize.intValue();
        }
        KcAttachmentDataToS3ConversionImpl.LOG.info("Finishing attachment conversion job for file_data to S3");
    }

    protected byte[] getBytesFromS3File(Object s3File) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        Method getFileContents = s3File.getClass().getMethod("getFileContents", new Class[0]);
        InputStream fileContents = (InputStream)getFileContents.invoke(s3File, new Object[0]);
        byte[] s3Bytes = IOUtils.toByteArray((InputStream)fileContents);
        return s3Bytes;
    }

    protected boolean processRecords() {
        boolean s3DualSaveEnabled;
        boolean s3IntegrationEnabled = this.isS3IntegrationEnabled();
        if (!s3IntegrationEnabled) {
            LOG.info("S3 integration is not enabled.  Records will not be processed");
        }
        if (s3DualSaveEnabled = this.isS3DualSaveEnabled()) {
            LOG.info("S3 dual save is enabled.  Records will not be processed");
        }
        return s3IntegrationEnabled && !s3DualSaveEnabled;
    }

    protected boolean mysql() {
        return MYSQL_PLATFORM.equals(this.configurationService.getPropertyValueAsString(DATASOURCE_PLATFORM_CFG_NM));
    }

    protected boolean isS3IntegrationEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "S3_INTEGRATION_ENABLED");
    }

    protected boolean isS3DualSaveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "S3_DUAL_SAVE_ENABLED");
    }

    protected boolean isDeleteFromDatabase() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", DELETE_FILE_FROM_DB);
    }

    public S3FileService getKcS3FileService() {
        return this.kcS3FileService;
    }

    public void setKcS3FileService(S3FileService kcS3FileService) {
        this.kcS3FileService = kcS3FileService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

