/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectAssociatedDocumentType;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ExconProjectAssociatedDocument
extends ExconProjectAssociate
implements Comparable<ExconProjectAssociatedDocument> {
    private static final long serialVersionUID = 12345233343469217L;
    private static final Logger LOG = LogManager.getLogger(ExconProjectAssociatedDocument.class);
    private Long exconProjectAssocDocId;
    private String assocDocTypeCode;
    private String assocDocNumber;
    private String assocDocTitle;
    private ExconProjectAssociatedDocumentType assocDocType;
    private Long projectId;
    private transient BusinessObjectService businessObjectService;
    private transient ConfigurationService configurationService;

    public Long getExconProjectAssocDocId() {
        return this.exconProjectAssocDocId;
    }

    public void setExconProjectAssocDocId(Long exconProjectAssocDocId) {
        this.exconProjectAssocDocId = exconProjectAssocDocId;
    }

    public String getAssocDocTypeCode() {
        return this.assocDocTypeCode;
    }

    public void setAssocDocTypeCode(String assocDocTypeCode) {
        this.assocDocTypeCode = assocDocTypeCode;
    }

    public String getAssocDocNumber() {
        return this.assocDocNumber;
    }

    public void setAssocDocNumber(String assocDocNumber) {
        this.assocDocNumber = assocDocNumber;
    }

    public String getAssocDocTitle() {
        return this.assocDocTitle;
    }

    public void setAssocDocTitle(String assocDocTitle) {
        this.assocDocTitle = assocDocTitle;
    }

    public ExconProjectAssociatedDocumentType getAssocDocType() {
        if (this.assocDocTypeCode != null) {
            this.refreshReferenceObject("assocDocType");
        }
        return this.assocDocType;
    }

    public void setAssocDocType(ExconProjectAssociatedDocumentType assocDocType) {
        this.assocDocType = assocDocType;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    protected Class<PersistableBusinessObject> getAssocDocTypeClass() {
        try {
            return Class.forName(this.getAssocDocType().getAssocDocTypeClassName());
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getAssocDocViewURL() {
        Object docViewURL = this.getConfigurationService().getPropertyValueAsString("kc.excon.assocDoc.viewURL." + this.getAssocDocTypeCode());
        if (!StringUtils.isEmpty((CharSequence)docViewURL)) {
            docViewURL = ((String)docViewURL).replace("[assocDocNumber]", this.getAssocDocNumber());
        } else if (!StringUtils.isEmpty((CharSequence)this.getAssocDocType().getAssocDocTypeClassName())) {
            String className = this.getAssocDocType().getAssocDocTypeClassName();
            String shortClassName = className.substring(className.lastIndexOf(46) + 1);
            Object documentName = shortClassName + "Document";
            if (StringUtils.equals((CharSequence)"LookupableDevelopmentProposal", (CharSequence)shortClassName)) {
                documentName = "ProposalDocument";
            }
            HashMap<String, String> lookupVals = new HashMap<String, String>();
            lookupVals.put(this.getAssocDocType().getAssocDocTypeNumberAttr(), this.getAssocDocNumber());
            Collection results = this.getBusinessObjectService().findMatchingOrderBy(this.getAssocDocTypeClass(), lookupVals, "updateTimestamp", false);
            if (results != null && results.size() > 0) {
                Method m;
                PersistableBusinessObject bo = (PersistableBusinessObject)results.iterator().next();
                String docId = "";
                try {
                    m = Class.forName(className).getDeclaredMethod("get" + (String)documentName, null);
                    DocumentBase docClass = (DocumentBase)m.invoke((Object)bo, null);
                    m = Class.forName("org.kuali.rice.krad.document.DocumentBase").getDeclaredMethod("getDocumentNumber", null);
                    docId = (String)m.invoke((Object)docClass, null);
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
                if (StringUtils.isEmpty((CharSequence)docId)) {
                    try {
                        m = Class.forName(className).getDeclaredMethod("getDocumentNumber", null);
                        docId = (String)m.invoke((Object)bo, null);
                    }
                    catch (Exception e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)docId)) {
                    String docViewURLParm = this.getConfigurationService().getPropertyValueAsString("kew.url");
                    docViewURL = docViewURLParm + "/DocHandler.do?command=displayDocSearchView&docId=" + docId;
                }
            }
        }
        return docViewURL;
    }

    public String getAssocDocLookupURL(String formKey) {
        String docLookupURL = null;
        String docLookupURLParm = this.getConfigurationService().getPropertyValueAsString("kc.excon.assocDoc.lookupURL." + this.getAssocDocTypeCode());
        if (!StringUtils.isEmpty((CharSequence)docLookupURLParm)) {
            docLookupURL = docLookupURLParm.replace("[formKey]", formKey);
        }
        return docLookupURL;
    }

    @Override
    public void resetPersistenceState() {
        this.exconProjectAssocDocId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectAssociatedDocument exconProjectAssociatedDocumentArg) {
        return exconProjectAssociatedDocumentArg.getExconProjectAssocDocId().compareTo(this.getExconProjectAssocDocId());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExconProjectAssociatedDocument)) {
            return false;
        }
        ExconProjectAssociatedDocument oDoc = (ExconProjectAssociatedDocument)o;
        if (this.getExconProjectAssocDocId() != null) {
            return oDoc.getExconProjectAssocDocId().equals(this.getExconProjectAssocDocId());
        }
        return oDoc.getAssocDocTypeCode().equals(this.getAssocDocTypeCode()) && oDoc.getAssocDocNumber().equals(this.getAssocDocNumber());
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

