/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.UrlFactory;

public class ExconProjectLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 6369873655376681944L;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        fieldValues.remove(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING);
        fieldValues.put(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING, VersionStatus.ACTIVE.toString());
        List unboundedResults = super.getSearchResultsUnbounded(fieldValues);
        return unboundedResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List<HtmlData> htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        htmlDataList.add((HtmlData)this.getOpenLink((ExconProject)businessObject, false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(ExconProject exconProject, Boolean viewOnly) {
        ExconProjectDocument exconProjectDocument = exconProject.getExconProjectDocument();
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", viewOnly.toString());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("docId", exconProjectDocument.getDocumentNumber());
        parameters.put("placeHolderAwardId", exconProject.getProjectId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("projectStartDate") && !field.getPropertyName().equals("projectEndDate")) continue;
                field.setDatePicker(true);
            }
        }
        return rows;
    }

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
    }

    @Override
    protected String getHtmlAction() {
        return "exconProjectHome.do";
    }

    @Override
    protected String getDocumentTypeName() {
        return "ExconProjectDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "projectId";
    }
}

