/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.print;

import edu.mit.irb.irbnamespace.CorrespondenceDocument;
import java.util.HashMap;
import java.util.Map;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.print.ProtocolXmlStream;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.actions.print.CorrespondenceXmlStreamBase;

public class CorrespondenceXmlStream
extends CorrespondenceXmlStreamBase<CorrespondenceDocument> {
    private ProtocolXmlStream protocolXmlStream;

    @Override
    public Class<CorrespondenceDocument> type() {
        return CorrespondenceDocument.class;
    }

    @Override
    public Map<String, CorrespondenceDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        Protocol protocol = (Protocol)printableBusinessObject;
        ProtocolSubmission protocolSubmission = protocol.getProtocolSubmission();
        String scheduleId = null;
        Integer submissionNumber = null;
        if (protocolSubmission != null) {
            CommitteeSchedule committeeSchedule = protocolSubmission.getCommitteeSchedule();
            scheduleId = committeeSchedule != null ? committeeSchedule.getScheduleId() : null;
            submissionNumber = protocolSubmission.getSubmissionNumber();
        }
        CorrespondenceDocument correspondenceDocument = CorrespondenceDocument.Factory.newInstance();
        correspondenceDocument.setCorrespondence(this.getCorrespondence(protocol, scheduleId, submissionNumber));
        HashMap<String, CorrespondenceDocument> correspondenceStreamMap = new HashMap<String, CorrespondenceDocument>();
        correspondenceStreamMap.put("Correspondence", correspondenceDocument);
        return correspondenceStreamMap;
    }

    public CorrespondenceDocument.Correspondence getCorrespondence(Protocol protocol, String scheduleId, Integer submissionNumber) {
        CorrespondenceDocument.Correspondence correspondence = CorrespondenceDocument.Correspondence.Factory.newInstance();
        correspondence.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        ProtocolXmlStream protocolStream = this.getProtocolXmlStream();
        if (submissionNumber == null || submissionNumber <= 0) {
            correspondence.setProtocol(protocolStream.getProtocol(protocol));
        } else {
            correspondence.setProtocol(protocolStream.getProtocol(protocol, submissionNumber));
        }
        correspondence.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        return correspondence;
    }

    public void setProtocolXmlStream(ProtocolXmlStream protocolXmlStream) {
        this.protocolXmlStream = protocolXmlStream;
    }

    public ProtocolXmlStream getProtocolXmlStream() {
        return this.protocolXmlStream;
    }
}

