/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.decision;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.committee.impl.meeting.ProtocolMeetingVoterBase;
import org.kuali.coeus.common.committee.impl.meeting.ProtocolVoteAbstaineeBase;
import org.kuali.coeus.common.committee.impl.meeting.ProtocolVoteRecusedBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.decision.CommitteeDecision;
import org.kuali.kra.protocol.actions.decision.CommitteeDecisionService;
import org.kuali.kra.protocol.actions.decision.CommitteePersonBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public abstract class CommitteeDecisionServiceImplBase<CD extends CommitteeDecision<? extends CommitteePersonBase>>
implements CommitteeDecisionService<CD> {
    private BusinessObjectService businessObjectService;
    private ProtocolActionService protocolActionService;
    private CommitteeServiceBase committeeService;
    private DocumentService documentService;
    private ProtocolFinderDao protocolFinderDao;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    public void processCommitteeDecision(ProtocolBase protocol, CD committeeDecision) throws Exception {
        ProtocolSubmissionBase submission = this.getSubmission(protocol);
        if (submission != null) {
            submission.setCommitteeDecisionMotionTypeCode(committeeDecision.getMotionTypeCode());
            submission.setYesVoteCount(committeeDecision.getYesCount());
            submission.setNoVoteCount(committeeDecision.getNoCount());
            submission.setAbstainerCount(committeeDecision.getAbstainCount());
            submission.setRecusedCount(committeeDecision.getRecusedCount());
            submission.setVotingComments(committeeDecision.getVotingComments());
            this.addReviewComments(submission, committeeDecision.getReviewCommentsBean());
            ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(protocol, submission, this.getProtocolActionTypeCodeForRecordCommitteeDecisionHook());
            protocolAction.setComments(committeeDecision.getVotingComments());
            this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
            protocol.getProtocolActions().add(protocolAction);
            this.businessObjectService.save((PersistableBusinessObject)protocolAction);
            List<CommitteeMembershipBase> committeeMemberships = this.committeeService.getAvailableMembers(protocol.getProtocolSubmission().getCommitteeId(), protocol.getProtocolSubmission().getScheduleId());
            this.proccessAbstainers(committeeDecision, committeeMemberships, protocol, submission.getScheduleIdFk(), submission.getSubmissionId());
            this.proccessRecusers(committeeDecision, committeeMemberships, protocol, submission.getScheduleIdFk(), submission.getSubmissionId());
            this.documentService.saveDocument((Document)protocol.getProtocolDocument());
            protocol.refresh();
        }
    }

    protected abstract String getProtocolActionTypeCodeForRecordCommitteeDecisionHook();

    protected abstract ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected void proccessAbstainers(CD committeeDecision, List<CommitteeMembershipBase> committeeMemberships, ProtocolBase protocol, Long scheduleIdFk, Long submissionIdFk) {
        Map<String, Object> fieldValues;
        if (!committeeDecision.getAbstainers().isEmpty()) {
            block0: for (CommitteePersonBase person : committeeDecision.getAbstainers()) {
                for (CommitteeMembershipBase membership : committeeMemberships) {
                    if (!membership.getCommitteeMembershipId().equals(person.getMembershipId())) continue;
                    fieldValues = this.getFieldValuesMap(protocol.getProtocolId(), scheduleIdFk, membership.getPersonId(), membership.getRolodexId(), submissionIdFk);
                    if (this.businessObjectService.findMatching(this.getProtocolVoteAbstaineeBOClassHook(), fieldValues).size() != 0) continue block0;
                    this.saveProtocolMeetingVoter(this.getNewProtocolVoteAbstaineeInstanceHook(), protocol, scheduleIdFk, membership.getPersonId(), membership.getRolodexId(), submissionIdFk);
                    continue block0;
                }
            }
        }
        if (!committeeDecision.getAbstainersToDelete().isEmpty()) {
            for (CommitteePersonBase person : committeeDecision.getAbstainersToDelete()) {
                for (CommitteeMembershipBase membership : committeeMemberships) {
                    if (!membership.getCommitteeMembershipId().equals(person.getMembershipId())) continue;
                    fieldValues = this.getFieldValuesMap(protocol.getProtocolId(), scheduleIdFk, membership.getPersonId(), membership.getRolodexId(), submissionIdFk);
                    this.businessObjectService.deleteMatching(this.getProtocolVoteAbstaineeBOClassHook(), fieldValues);
                }
            }
            committeeDecision.getAbstainersToDelete().clear();
        }
    }

    protected abstract Class<? extends ProtocolVoteAbstaineeBase> getProtocolVoteAbstaineeBOClassHook();

    protected abstract ProtocolVoteAbstaineeBase getNewProtocolVoteAbstaineeInstanceHook();

    protected void proccessRecusers(CD committeeDecision, List<CommitteeMembershipBase> committeeMemberships, ProtocolBase protocol, Long scheduleIdFk, Long submissionIdFk) {
        Map<String, Object> fieldValues;
        if (!committeeDecision.getRecused().isEmpty()) {
            block0: for (CommitteePersonBase person : committeeDecision.getRecused()) {
                for (CommitteeMembershipBase membership : committeeMemberships) {
                    if (!membership.getCommitteeMembershipId().equals(person.getMembershipId())) continue;
                    fieldValues = this.getFieldValuesMap(protocol.getProtocolId(), scheduleIdFk, membership.getPersonId(), membership.getRolodexId(), submissionIdFk);
                    if (this.businessObjectService.findMatching(this.getProtocolVoteRecusedBOClassHook(), fieldValues).size() != 0) continue block0;
                    this.saveProtocolMeetingVoter(this.getNewProtocolVoteRecusedInstanceHook(), protocol, scheduleIdFk, membership.getPersonId(), membership.getRolodexId(), submissionIdFk);
                    continue block0;
                }
            }
        }
        if (!committeeDecision.getRecusedToDelete().isEmpty()) {
            for (CommitteePersonBase person : committeeDecision.getRecusedToDelete()) {
                for (CommitteeMembershipBase membership : committeeMemberships) {
                    if (!membership.getCommitteeMembershipId().equals(person.getMembershipId())) continue;
                    fieldValues = this.getFieldValuesMap(protocol.getProtocolId(), scheduleIdFk, membership.getPersonId(), membership.getRolodexId(), submissionIdFk);
                    this.businessObjectService.deleteMatching(this.getProtocolVoteRecusedBOClassHook(), fieldValues);
                }
            }
            committeeDecision.getRecusedToDelete().clear();
        }
    }

    protected abstract ProtocolVoteRecusedBase getNewProtocolVoteRecusedInstanceHook();

    protected abstract Class<? extends ProtocolVoteRecusedBase> getProtocolVoteRecusedBOClassHook();

    protected void saveProtocolMeetingVoter(ProtocolMeetingVoterBase voter, ProtocolBase protocol, Long scheduleIdFk, String personId, Integer rolodexId, Long submissionIdFk) {
        voter.setProtocol(protocol);
        voter.setProtocolIdFk(protocol.getProtocolId());
        voter.setSubmissionIdFk(submissionIdFk);
        voter.setRolodexId(rolodexId);
        voter.setPersonId(personId);
        voter.setNonEmployeeFlag(personId == null);
        this.businessObjectService.save((PersistableBusinessObject)voter);
    }

    protected abstract Map<String, Object> getFieldValuesMap(Long var1, Long var2, String var3, Integer var4, Long var5);

    protected abstract ProtocolSubmissionBase getSubmission(ProtocolBase var1);

    protected void addReviewComments(ProtocolSubmissionBase submission, ReviewCommentsBeanBase reviewCommentsBean) {
        int nextEntryNumber = 0;
        for (CommitteeScheduleMinuteBase minute : reviewCommentsBean.getReviewComments()) {
            minute.setEntryNumber(nextEntryNumber);
            if (StringUtils.isBlank((CharSequence)minute.getMinuteEntryTypeCode())) {
                minute.setMinuteEntryTypeCode("3");
            }
            if (StringUtils.isNotBlank((CharSequence)minute.getMinuteEntryTypeCode()) && "3".equals(minute.getMinuteEntryTypeCode())) {
                if (minute.getSubmissionIdFk() == null) {
                    minute.setSubmissionIdFk(submission.getSubmissionId());
                }
                if (minute.getProtocolIdFk() == null) {
                    minute.setProtocolIdFk(submission.getProtocolId());
                }
            }
            if (minute.getScheduleIdFk() == null) {
                minute.setScheduleIdFk(submission.getScheduleIdFk());
            }
            ++nextEntryNumber;
        }
    }

    @Override
    public List<ProtocolVoteAbstaineeBase> getAbstainers(String protocolNumber, int submissionNumber) {
        ArrayList<ProtocolVoteAbstaineeBase> protocolVoteAbstainers = new ArrayList<ProtocolVoteAbstaineeBase>();
        for (ProtocolSubmissionBase protocolSubmission : this.protocolFinderDao.findProtocolSubmissions(protocolNumber, submissionNumber)) {
            protocolVoteAbstainers.addAll(protocolSubmission.getAbstainers());
        }
        return protocolVoteAbstainers;
    }

    @Override
    public List<ProtocolVoteRecusedBase> getRecusers(String protocolNumber, int submissionNumber) {
        ArrayList<ProtocolVoteRecusedBase> protocolVoteRecusers = new ArrayList<ProtocolVoteRecusedBase>();
        for (ProtocolSubmissionBase protocolSubmission : this.protocolFinderDao.findProtocolSubmissions(protocolNumber, submissionNumber)) {
            protocolSubmission.refreshReferenceObject("recusers");
            protocolVoteRecusers.addAll(protocolSubmission.getRecusers());
        }
        return protocolVoteRecusers;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }
}

