/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.api;

import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.award.api.AwardControllerBase;
import org.kuali.coeus.award.dto.AwardDto;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyBean;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposalBean;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepad;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.UserSessionUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v2"})
@Controller(value="awardHierarchyController")
public class AwardHierarchyController
extends AwardControllerBase {
    @Autowired
    @Qualifier(value="awardDao")
    private AwardDao awardDao;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="versionHistoryService")
    private VersionHistoryService versionHistoryService;
    @Autowired
    @Qualifier(value="institutionalProposalService")
    private InstitutionalProposalService institutionalProposalService;

    @RequestMapping(method={RequestMethod.POST}, value={"/awards/{awardId}/child"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    AwardDto createChild(@RequestBody AwardDto awardDto, @PathVariable Long awardId) throws Exception {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        Award award = this.getAwardDao().getAward(awardId);
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        VersionHistory activeVersionHistory = this.versionHistoryService.findActiveVersion(Award.class, award.getAwardNumber());
        if (activeVersionHistory == null) {
            throw new UnprocessableEntityException("A child cannot be copied from an award that has no active versions.");
        }
        AwardHierarchyBean awardHierarchyBean = new AwardHierarchyBean();
        awardHierarchyBean.init(award.getAwardNumber());
        AwardHierarchy rootNode = awardHierarchyBean.getRootNode(award.getAwardNumber());
        AwardHierarchy newChildNode = awardHierarchyBean.getNewNodeBasedOnParent(award.getAwardNumber(), rootNode);
        AwardDocument awardDocument = this.createDocument(newChildNode, awardDto);
        this.translateCollections(awardDto, awardDocument);
        this.changeDates(awardDocument.getAward(), awardDto);
        this.addFundingProposals(awardDto, awardDocument.getAward());
        awardDocument.getAward().setAwardInMultipleNodeHierarchy(Boolean.TRUE);
        this.commonApiService.saveDocument((Document)awardDocument);
        return this.commonApiService.convertObject(awardDocument.getAward(), AwardDto.class);
    }

    protected AwardDocument createDocument(AwardHierarchy awardNode, AwardDto awardDto) throws WorkflowException {
        this.businessObjectService.save((PersistableBusinessObject)awardNode);
        AwardDocument awardDocument = (AwardDocument)this.documentService.getNewDocument(AwardDocument.class);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)awardDocument.getDocumentHeader().getWorkflowDocument());
        Award newChildAward = awardNode.getAward();
        this.commonApiService.updateDataObjectFromDto(newChildAward, awardDto);
        this.defaultValues(newChildAward, awardDto);
        awardDocument.setAward(newChildAward);
        return awardDocument;
    }

    public void addFundingProposals(AwardDto awardDto, Award award) {
        award.setFundingProposals(new ArrayList<AwardFundingProposal>());
        if (CollectionUtils.isNotEmpty(awardDto.getFundingProposals())) {
            awardDto.getFundingProposals().stream().forEach(awardFundingProposalDto -> {
                AwardFundingProposalBean fundingProposalBean = new AwardFundingProposalBean();
                fundingProposalBean.setMergeTypeCode(awardFundingProposalDto.getMergeTypeCode());
                InstitutionalProposal institutionalProposal = this.institutionalProposalService.getInstitutionalProposal(awardFundingProposalDto.getProposalId().toString());
                if (institutionalProposal == null) {
                    throw new UnprocessableEntityException("The funding proposal with proposal id " + awardFundingProposalDto.getProposalId() + " cannot be located");
                }
                fundingProposalBean.setNewFundingProposal(institutionalProposal);
                fundingProposalBean.validateAndPerformFeed(new ArrayList<Award>(), award);
            });
        }
    }

    protected Document getDocument(Long documentNumber) {
        return this.commonApiService.getDocumentFromDocId(documentNumber);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected void defaultValues(Award award, AwardDto awardDto) {
        if (award.getAwardAmountInfos() == null) {
            award.initializeAwardAmountInfoObjects();
        }
        if (award.getAwardCostShares() == null) {
            award.setAwardCostShares(new ArrayList<AwardCostShare>());
        }
        if (award.getApprovedForeignTravelTrips() == null) {
            award.setApprovedForeignTravelTrips(new ArrayList<AwardApprovedForeignTravel>());
        }
        if (award.getFundingProposals() == null) {
            award.setFundingProposals(new ArrayList<AwardFundingProposal>());
        }
        if (award.getAllFundingProposals() == null) {
            award.setAllFundingProposals(new ArrayList<AwardFundingProposal>());
        }
        if (award.getAwardComments() == null) {
            award.setAwardComments(new ArrayList<AwardComment>());
        }
        if (award.getAwardReportTermItems() == null) {
            award.setAwardReportTermItems(new ArrayList<AwardReportTerm>());
        }
        if (award.getAwardSponsorTerms() == null) {
            award.setAwardSponsorTerms(new ArrayList<AwardSponsorTerm>());
        }
        if (award.getSponsorContacts() == null) {
            award.setSponsorContacts(new ArrayList<AwardSponsorContact>());
        }
        if (award.getAwardFandaRate() == null) {
            award.setAwardFandaRate(new ArrayList<AwardFandaRate>());
        }
        if (award.getAwardDirectFandADistributions() == null) {
            award.setAwardDirectFandADistributions(new ArrayList<AwardDirectFandADistribution>());
        }
        if (award.getAwardApprovedSubawards() == null) {
            award.setAwardApprovedSubawards(new ArrayList<AwardApprovedSubaward>());
        }
        if (award.getKeywords() == null) {
            award.setKeywords(new ArrayList<AwardScienceKeyword>());
        }
        if (award.getProjectPersons() == null) {
            award.setProjectPersons(new ArrayList<AwardPerson>());
        }
        if (award.getAwardUnitContacts() == null) {
            award.setAwardUnitContacts(new ArrayList<AwardUnitContact>());
        }
        if (award.getSpecialReviews() == null) {
            award.setSpecialReviews(new ArrayList<AwardSpecialReview>());
        }
        if (award.getApprovedEquipmentItems() == null) {
            award.setApprovedEquipmentItems(new ArrayList<AwardApprovedEquipment>());
        }
        if (award.getPaymentScheduleItems() == null) {
            award.setPaymentScheduleItems(new ArrayList<AwardPaymentSchedule>());
        }
        if (award.getAwardTransferringSponsors() == null) {
            award.setAwardTransferringSponsors(new ArrayList<AwardTransferringSponsor>());
        }
        if (award.getAwardCloseoutItems() == null) {
            award.setAwardCloseoutItems(new ArrayList<AwardCloseout>());
        }
        if (award.getAwardCloseoutNewItems() == null) {
            award.setAwardCloseoutNewItems(new ArrayList<AwardCloseout>());
        }
        if (award.getAwardNotepads() == null) {
            award.setAwardNotepads(new ArrayList<AwardNotepad>());
        }
        if (award.getAwardAttachments() == null) {
            award.setAttachments(new ArrayList<AwardAttachment>());
        }
        if (award.getAwardBudgetLimits() == null) {
            award.setAwardBudgetLimits(new ArrayList<AwardBudgetLimit>());
        }
        if (award.getAwardCustomDataList() == null) {
            award.setAwardCustomDataList(new ArrayList<AwardCustomData>());
        }
        if (award.getAwardCfdas() == null) {
            award.setAwardCfdas(new ArrayList<AwardCfda>());
        }
        award.setProjectEndDate(awardDto.getProjectEndDate());
        if (award.getAwardNumber() == null) {
            award.setAwardNumber("000000-00000");
        }
        award.setSequenceNumber(1);
        award.setApprovedEquipmentIndicator("N");
        award.setApprovedForeignTripIndicator("N");
        award.setSubContractIndicator("N");
        award.setCostSharingIndicator("N");
        award.setIdcIndicator("N");
        award.setPaymentScheduleIndicator("N");
        award.setScienceCodeIndicator("N");
        award.setSpecialReviewIndicator("N");
        award.setTransferSponsorIndicator("N");
        award.setCurrentActionComments("");
        award.setNewVersion(false);
        award.setAwardSequenceStatus(VersionStatus.PENDING.name());
    }

    public AwardDao getAwardDao() {
        return this.awardDao;
    }

    public void setAwardDao(AwardDao awardDao) {
        this.awardDao = awardDao;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

