/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="coreServicesUtil")
public class CoreServicesUtil {
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    private static final Integer LIMIT_COUNT = 100;
    private static final String LIMIT_PARAM = "limit";
    private static final String SKIP_PARAM = "skip";
    private static final String ITEM_COUNT_PARAM = "item-count";
    private static final Logger LOG = LogManager.getLogger(CoreServicesUtil.class);

    public <T> List<T> getAll(String url, Map<String, Object> params, ParameterizedTypeReference<List<T>> responseType) {
        ResponseEntity<List<T>> response = this.getAllResponse(url, params, responseType, 0);
        List collection = (List)response.getBody();
        Double itemCount = Double.valueOf((String)response.getHeaders().get((Object)ITEM_COUNT_PARAM).get(0));
        Integer iterations = (int)Math.ceil(itemCount / (double)LIMIT_COUNT.intValue());
        for (int i = 1; i < iterations; ++i) {
            collection.addAll((Collection)this.getAllResponse(url, params, responseType, LIMIT_COUNT * i).getBody());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("GET " + url + " returned " + collection.size() + " groups");
        }
        return collection;
    }

    private <T> ResponseEntity<List<T>> getAllResponse(String url, Map<String, Object> params, ParameterizedTypeReference<List<T>> responseType, Integer skip) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            uriComponentsBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        String uri = uriComponentsBuilder.queryParam(LIMIT_PARAM, new Object[]{LIMIT_COUNT}).queryParam(SKIP_PARAM, new Object[]{skip}).build().encode().toString();
        return this.getRestOperations().exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.getAuthServiceRestUtilService().getAuthServiceStyleHttpHeadersForUser()), responseType, new Object[0]);
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }
}

