/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;

public class NegotiationAssociationTypeMaintenanceDocumentRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.dontChangeLinkedBoClassIfExistingRecords(document);
    }

    boolean dontChangeLinkedBoClassIfExistingRecords(MaintenanceDocument document) {
        NegotiationAssociationType old = (NegotiationAssociationType)document.getOldMaintainableObject().getPersistableBusinessObject();
        NegotiationAssociationType current = (NegotiationAssociationType)document.getNewMaintainableObject().getPersistableBusinessObject();
        if (document.isNew()) {
            return true;
        }
        if (StringUtils.equals((String)old.getLinkedBoClass(), (String)current.getLinkedBoClass())) {
            return true;
        }
        if (this.existingRecords(old.getId())) {
            ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
            errorReporter.reportError("document.newMaintainableObject.linkedBoClass", "negotiation.error.linked.bo.class", new String[0]);
            return false;
        }
        return true;
    }

    boolean existingRecords(Long associationTypeId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("negotiationAssociationTypeId", associationTypeId.toString());
        return this.getBoService().countMatching(Negotiation.class, fieldValues) > 0;
    }
}

