/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplit;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonCreditSplitRuleEvent;
import org.kuali.kra.award.contacts.AwardPersonCreditSplitRuleImpl;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplitRuleEvent;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplitRuleImpl;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardCreditSplitBean
implements Serializable {
    static final String PERSON_TOTALS_KEY = "personTotalsKey";
    private static final long serialVersionUID = 1330497293834315534L;
    private static Logger LOGGER = LogManager.getLogger(AwardCreditSplitBean.class);
    private static final String YES = "Y";
    private static final String AWARD_CREDIT_SPLIT_PARM_NAME = "award.creditsplit.enabled";
    private static final ScaleTwoDecimal ZERO_VALUE = ScaleTwoDecimal.ZERO;
    private static final ScaleTwoDecimal MAX_VALUE = new ScaleTwoDecimal(100.0);
    private AwardForm awardForm;
    private AwardDocument awardDocument;
    private transient Collection<InvestigatorCreditType> investigatorCreditTypes;
    private transient ParameterService parameterService;
    private transient AwardService awardService;

    public AwardCreditSplitBean(AwardForm awardForm) {
        this.awardForm = awardForm;
    }

    public AwardCreditSplitBean(AwardDocument awardDocument) {
        this.awardDocument = awardDocument;
    }

    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        if (this.investigatorCreditTypes == null || this.investigatorCreditTypes.size() == 0) {
            this.investigatorCreditTypes = this.loadInvestigatorCreditTypes();
        }
        return this.investigatorCreditTypes;
    }

    public Map<String, ScaleTwoDecimal> getPersonsTotalsMap() {
        return this.calculateCreditSplitTotals().get(PERSON_TOTALS_KEY);
    }

    public AwardPerson getProjectPerson(int index) {
        return this.getProjectPersons().get(index);
    }

    public List<AwardPerson> getProjectPersons() {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        List<AwardPerson> projectPersons = this.getAward().getProjectPersons();
        for (AwardPerson p : projectPersons) {
            if (!this.addToCreditSplit(p)) continue;
            this.createDefaultCreditSplitMapForProjectPerson(creditTypes, p);
            for (AwardPersonUnit apu : p.getUnits()) {
                this.createDefaultCreditSplitMapForPersonUnit(creditTypes, apu);
            }
        }
        return this.getAward().getProjectPersons();
    }

    public List<AwardPerson> getInvestigators() {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        List<AwardPerson> investigators = this.getAward().getInvestigators();
        for (AwardPerson investigator : investigators) {
            if (!this.addToCreditSplit(investigator)) continue;
            this.createDefaultCreditSplitMapForProjectPerson(creditTypes, investigator);
            for (AwardPersonUnit apu : investigator.getUnits()) {
                this.createDefaultCreditSplitMapForPersonUnit(creditTypes, apu);
            }
        }
        return investigators;
    }

    public boolean addToCreditSplit(AwardPerson person) {
        return !person.isKeyPerson() || person.isOptInUnitStatus();
    }

    public Map<String, Map<String, ScaleTwoDecimal>> getUnitTotalsMap() {
        return this.calculateCreditSplitTotals();
    }

    public boolean isAwardCreditsLimitApplicable() {
        try {
            String parmValue = this.fetchParameterValue(AWARD_CREDIT_SPLIT_PARM_NAME);
            return parmValue.equalsIgnoreCase(YES);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean recalculateCreditSplit() {
        boolean noErrors = true;
        if (this.isAwardCreditsLimitApplicable()) {
            Map<String, Map<String, ScaleTwoDecimal>> totalsMap = this.calculateCreditSplitTotals();
            noErrors = this.checkIfPersonTotalsAreValid(totalsMap);
            noErrors &= this.checkIfPersonUnitsTotalsAreValid(totalsMap);
        }
        return noErrors;
    }

    protected String fetchParameterValue(String parmName) {
        return this.getParameterService().getParameterValueAsString(AwardDocument.class, parmName);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    Map<String, Map<String, ScaleTwoDecimal>> calculateCreditSplitTotals() {
        HashMap<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals = new HashMap<String, Map<String, ScaleTwoDecimal>>();
        this.calculatePersonTotals(allCreditSplitTotals);
        this.calculatePersonUnitTotals(allCreditSplitTotals);
        return allCreditSplitTotals;
    }

    Award getAward() {
        Award award = this.awardForm != null ? this.awardForm.getAwardDocument().getAward() : (this.awardDocument != null ? this.awardDocument.getAward() : null);
        return award;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }

    private void calculatePersonTotalForCreditSplitType(AwardPerson projectPerson, InvestigatorCreditType creditType, Map<String, ScaleTwoDecimal> personCreditSplitTotalMap) {
        String creditTypeCode = creditType.getCode();
        ScaleTwoDecimal personsTotalCredit = personCreditSplitTotalMap.get(creditTypeCode);
        if (personsTotalCredit == null) {
            personsTotalCredit = ZERO_VALUE;
        }
        for (CreditSplit creditSplit : projectPerson.getCreditSplits()) {
            if (!creditSplit.getInvCreditTypeCode().equals(creditTypeCode)) continue;
            personCreditSplitTotalMap.put(creditTypeCode, (ScaleTwoDecimal)personsTotalCredit.add((AbstractDecimal)creditSplit.getCredit()));
        }
    }

    private void calculatePersonTotals(Map<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        Map<String, ScaleTwoDecimal> personCreditSplitTotalMap = this.initializePersonCreditSplitTotalMap(allCreditSplitTotals);
        for (AwardPerson projectPerson : this.getPersonsSelectedForCreditSplit()) {
            for (InvestigatorCreditType creditType : creditTypes) {
                this.calculatePersonTotalForCreditSplitType(projectPerson, creditType, personCreditSplitTotalMap);
            }
        }
    }

    private void calculatePersonUnitTotals(Map<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        for (AwardPerson projectPerson : this.getProjectPersons()) {
            String personKey = this.getPersonKey(projectPerson);
            Map<String, ScaleTwoDecimal> personUnitCreditTotals = allCreditSplitTotals.get(personKey);
            if (personUnitCreditTotals == null) {
                personUnitCreditTotals = new HashMap<String, ScaleTwoDecimal>();
                allCreditSplitTotals.put(personKey, personUnitCreditTotals);
            }
            for (InvestigatorCreditType creditType : creditTypes) {
                String creditTypeCode;
                ScaleTwoDecimal totalCredit = personUnitCreditTotals.get(creditTypeCode = creditType.getCode());
                personUnitCreditTotals.put(creditTypeCode, totalCredit != null ? totalCredit : ZERO_VALUE);
            }
            this.calculateUnitCreditSplitTotals(projectPerson, personUnitCreditTotals);
        }
    }

    private void calculateUnitCreditSplitTotals(AwardPerson projectPerson, Map<String, ScaleTwoDecimal> personUnitCreditTotals) {
        if (projectPerson.isKeyPerson() && projectPerson.getUnits().size() == 0) {
            this.handleKeyPersonWithNoUnits(personUnitCreditTotals);
        } else {
            for (AwardPersonUnit unit : projectPerson.getUnits()) {
                for (CreditSplit creditSplit : unit.getCreditSplits()) {
                    ScaleTwoDecimal totalCredit = personUnitCreditTotals.get(creditSplit.getInvCreditTypeCode());
                    if (totalCredit == null) {
                        totalCredit = ZERO_VALUE;
                    }
                    personUnitCreditTotals.put(creditSplit.getInvCreditTypeCode(), (ScaleTwoDecimal)totalCredit.add((AbstractDecimal)creditSplit.getCredit()));
                }
            }
        }
    }

    private void handleKeyPersonWithNoUnits(Map<String, ScaleTwoDecimal> personUnitCreditTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        for (InvestigatorCreditType creditType : creditTypes) {
            personUnitCreditTotals.put(creditType.getCode(), MAX_VALUE);
        }
    }

    private boolean checkIfPersonTotalsAreValid(Map<String, Map<String, ScaleTwoDecimal>> totalsMap) {
        AwardPersonCreditSplitRuleImpl rule = new AwardPersonCreditSplitRuleImpl();
        AwardPersonCreditSplitRuleEvent event = new AwardPersonCreditSplitRuleEvent((Document)this.awardDocument, totalsMap.get(PERSON_TOTALS_KEY));
        return rule.checkAwardPersonCreditSplitTotals(event);
    }

    private boolean checkIfPersonUnitsTotalsAreValid(Map<String, Map<String, ScaleTwoDecimal>> totalsMap) {
        AwardPersonUnitCreditSplitRuleImpl rule = new AwardPersonUnitCreditSplitRuleImpl();
        boolean success = true;
        for (AwardPerson projectPerson : this.getAward().getProjectPersons()) {
            AwardPersonUnitCreditSplitRuleEvent event = new AwardPersonUnitCreditSplitRuleEvent((Document)this.awardDocument, projectPerson, totalsMap.get(this.getPersonKey(projectPerson)));
            if (!this.getAwardService().generateCreditSplitForPerson(projectPerson).booleanValue()) continue;
            success &= rule.checkAwardPersonUnitCreditSplitTotals(event);
        }
        return success;
    }

    private void createDefaultCreditSplitMapForPersonUnit(Collection<InvestigatorCreditType> creditTypes, AwardPersonUnit apu) {
        HashMap<InvestigatorCreditType, AwardPersonUnitCreditSplit> personUnitCreditMap = new HashMap<InvestigatorCreditType, AwardPersonUnitCreditSplit>();
        for (AwardPersonUnitCreditSplit apuCreditSplit : apu.getCreditSplits()) {
            personUnitCreditMap.put(apuCreditSplit.getInvestigatorCreditType(), apuCreditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personUnitCreditMap.get(creditType) != null) continue;
            apu.add(new AwardPersonUnitCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private void createDefaultCreditSplitMapForProjectPerson(Collection<InvestigatorCreditType> creditTypes, AwardPerson projectPerson) {
        HashMap<InvestigatorCreditType, AwardPersonCreditSplit> personCreditMap = new HashMap<InvestigatorCreditType, AwardPersonCreditSplit>();
        for (AwardPersonCreditSplit creditSplit : projectPerson.getCreditSplits()) {
            personCreditMap.put(creditSplit.getInvestigatorCreditType(), creditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personCreditMap.get(creditType) != null) continue;
            projectPerson.add(new AwardPersonCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private String getPersonKey(AwardPerson projectPerson) {
        return projectPerson.getFullName();
    }

    private Map<String, ScaleTwoDecimal> initializePersonCreditSplitTotalMap(Map<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals) {
        Map<String, ScaleTwoDecimal> personCreditTypeTotals = allCreditSplitTotals.get(PERSON_TOTALS_KEY);
        if (personCreditTypeTotals == null) {
            personCreditTypeTotals = new HashMap<String, ScaleTwoDecimal>();
            allCreditSplitTotals.put(PERSON_TOTALS_KEY, personCreditTypeTotals);
        }
        return personCreditTypeTotals;
    }

    public List<AwardPerson> getPersonsSelectedForCreditSplit() {
        return this.getAwardService().getPersonsSelectedForCreditSplit(this.getProjectPersons());
    }
}

