/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.distribution;

import org.kuali.coeus.common.budget.framework.distribution.BudgetDistributionService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalBudgetDistributionController
extends ProposalBudgetControllerBase {
    @Autowired
    @Qualifier(value="budgetDistributionService")
    private BudgetDistributionService budgetDistributionService;

    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropBudget-UnrecoveredFandAPage"})
    public ModelAndView navigateToFandA(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.getBudgetDistributionService().initializeUnrecoveredFandACollectionDefaults(form.getBudget());
        return super.navigate(form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=resetUnrecoveredFandA"})
    public ModelAndView resetUnrecoveredFandAToDefault(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        budget.getBudgetUnrecoveredFandAs().clear();
        this.budgetDistributionService.initializeUnrecoveredFandACollectionDefaults(budget);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropBudget-CostSharingPage"})
    public ModelAndView navigateToCostShare(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.getBudgetDistributionService().initializeCostSharingCollectionDefaults(form.getBudget());
        return super.navigate(form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=resetCostSharing"})
    public ModelAndView resetCostSharingToDefault(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        budget.getBudgetCostShares().clear();
        this.budgetDistributionService.initializeCostSharingCollectionDefaults(budget);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    public BudgetDistributionService getBudgetDistributionService() {
        return this.budgetDistributionService;
    }

    public void setBudgetDistributionService(BudgetDistributionService budgetDistributionService) {
        this.budgetDistributionService = budgetDistributionService;
    }
}

