/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.fiscalyear;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="fiscalYearMonthService")
public class FiscalYearMonthServiceImpl
implements FiscalYearMonthService {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    protected static final String FISCAL_YEAR_MONTH_PARAMETER_NAME = "KC_FISCAL_START_MONTH";
    protected static final String KC_GENERAL_NAMESPACE = "KC-GEN";
    protected static final String DOCUMENT_COMPONENT_NAME = "Document";
    protected static final String MONTH_KEY = "month";
    protected static final String YEAR_KEY = "year";

    @Override
    public Integer getCurrentFiscalMonth() {
        return this.getCurrentFiscalData(null).get(MONTH_KEY);
    }

    @Override
    public Integer getCurrentFiscalMonthForDisplay() {
        return this.getCurrentFiscalData(null).get(MONTH_KEY) + 1;
    }

    @Override
    public Integer getCurrentFiscalYear() {
        return this.getCurrentFiscalData(null).get(YEAR_KEY);
    }

    @Override
    public Integer getFiscalYearFromDate(Calendar date) {
        Integer fiscalStartMonth = this.getFiscalYearMonth();
        Integer year = date.get(1);
        Integer month = date.get(2);
        if (fiscalStartMonth != 0 && month >= fiscalStartMonth) {
            year = year + 1;
        }
        return year;
    }

    protected Map<String, Integer> getCurrentFiscalData(Calendar calendar) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        Integer fiscalStartMonth = this.getFiscalYearMonth();
        if (calendar.get(2) == fiscalStartMonth.intValue()) {
            data.put(MONTH_KEY, this.findMonth(fiscalStartMonth, calendar.get(2)));
            if (fiscalStartMonth.equals(0)) {
                data.put(YEAR_KEY, calendar.get(1));
            } else {
                data.put(YEAR_KEY, calendar.get(1) + 1);
            }
        } else if (calendar.get(2) > fiscalStartMonth) {
            data.put(MONTH_KEY, this.findMonth(fiscalStartMonth, calendar.get(2)));
            if (fiscalStartMonth.equals(0)) {
                data.put(YEAR_KEY, calendar.get(1));
            } else {
                data.put(YEAR_KEY, calendar.get(1) + 1);
            }
        } else {
            data.put(MONTH_KEY, this.findMonth(fiscalStartMonth, calendar.get(2)));
            data.put(YEAR_KEY, calendar.get(1));
        }
        return data;
    }

    private int findMonth(int startingMonth, int currentMonth) {
        int nextMonth = startingMonth;
        int[] YEAR = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        for (int i = 0; i < 12; ++i) {
            YEAR[i] = nextMonth;
            if (nextMonth == 11) {
                nextMonth = 0;
                continue;
            }
            ++nextMonth;
        }
        for (int i : YEAR) {
            if (YEAR[i] != currentMonth) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find the current month: " + currentMonth);
    }

    protected Integer getFiscalYearMonth() {
        Parameter parm = this.getParameterService().getParameter(KC_GENERAL_NAMESPACE, DOCUMENT_COMPONENT_NAME, FISCAL_YEAR_MONTH_PARAMETER_NAME);
        return Integer.parseInt(parm.getValue());
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public Calendar getFiscalYearStartDate(Integer fiscalYear) {
        Calendar cal = Calendar.getInstance();
        if (this.getFiscalYearMonth().equals(new Integer(0))) {
            cal.set(1, fiscalYear);
        } else {
            cal.set(1, fiscalYear - 1);
        }
        cal.set(5, 1);
        cal.set(2, this.getFiscalYearMonth());
        return cal;
    }

    @Override
    public Calendar getFiscalYearEndDate(Integer fiscalYear) {
        Calendar cal = this.getFiscalYearStartDate(fiscalYear);
        cal.add(5, -1);
        cal.add(1, 1);
        return cal;
    }
}

