/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit.sync;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.sync.SourceUnit;
import org.kuali.coeus.common.framework.unit.sync.SyncBehavior;
import org.kuali.coeus.common.framework.unit.sync.TargetRoleInfo;
import org.kuali.coeus.common.framework.unit.sync.UnitRoleSync;
import org.kuali.coeus.common.framework.unit.sync.UnitRoleSyncService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component(value="unitRoleSyncService")
public class UnitRoleSyncServiceImpl
implements UnitRoleSyncService {
    private static final String ACTIVE = "active";
    private static final String ID = "id";
    private static final Collection<String> KIM_CACHE_NAMES = Stream.of("http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType").collect(Collectors.toList());
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="globalCacheManager")
    private CacheManager globalCacheManager;
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    @Override
    public void syncPersonUnitInfoToRoles() {
        this.syncPersonUnitInfoToRoles(this.getBusinessObjectService().findMatching(UnitRoleSync.class, Collections.singletonMap(ACTIVE, true)));
    }

    void syncPersonUnitInfoToRoles(Collection<UnitRoleSync> unitRoleSyncs) {
        Set activeUnits = this.unitService.getUnits().stream().filter(Unit::isActive).map(Unit::getUnitNumber).collect(Collectors.toSet());
        unitRoleSyncs.stream().filter(UnitRoleSync::isActive).forEach(unitRoleSync -> {
            Map<String, Set<String>> personUnits = unitRoleSync.getSourceUnitInfos().stream().map(sourceUnit -> SourceUnit.fromCode(sourceUnit.getSourceUnitCode())).map(sourceUnit -> {
                if (SourceUnit.PERSON_APPOINTMENTS.equals(sourceUnit)) {
                    return this.kcPersonService.findPersonAppointmentUnits(activeUnits);
                }
                if (SourceUnit.PERSON_PRIMARY_DEPARTMENTS.equals(sourceUnit)) {
                    return this.kcPersonService.findPersonEmploymentUnits(activeUnits, true);
                }
                if (SourceUnit.PERSON_SECONDARY_DEPARTMENTS.equals(sourceUnit)) {
                    return this.kcPersonService.findPersonEmploymentUnits(activeUnits, false);
                }
                throw new RuntimeException(sourceUnit + " not supported");
            }).flatMap(map -> map.entrySet().stream()).collect(this.entriesToMapWithMergedSet());
            this.createMemberships(personUnits, unitRoleSync.getTargetRoleInfos(), SyncBehavior.fromCode(unitRoleSync.getSyncBehaviorCode()));
            this.clearKimCache();
        });
    }

    private void createMemberships(Map<String, Set<String>> personUnits, List<TargetRoleInfo> targetRoleInfos, SyncBehavior syncBehavior) {
        targetRoleInfos.forEach(targetRole -> {
            RoleBo role = (RoleBo)this.dataObjectService.findUnique(RoleBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)ID, (Object)targetRole.getRoleId()), PredicateFactory.equal((String)ACTIVE, (Object)true)}));
            if (role != null) {
                if (SyncBehavior.DELETE_ALL_ADD.equals((Object)syncBehavior)) {
                    this.findMatchingPrincipalRoleMembers(role.getMembers()).forEach(arg_0 -> ((DataObjectService)this.dataObjectService).delete(arg_0));
                    personUnits.forEach((personId, unitNumbers) -> unitNumbers.forEach(unitNumber -> this.dataObjectService.save((Object)this.createRoleMember(role.getId(), role.getKimTypeId(), (String)personId, (String)unitNumber, targetRole.isDescends()), new PersistenceOption[0])));
                } else if (SyncBehavior.IGNORE_EXISTING.equals((Object)syncBehavior)) {
                    personUnits.forEach((personId, unitNumbers) -> unitNumbers.forEach(unitNumber -> {
                        if (this.findMatchingPrincipalRoleMembers(role.getMembers(), (String)unitNumber, (String)personId).isEmpty()) {
                            this.dataObjectService.save((Object)this.createRoleMember(role.getId(), role.getKimTypeId(), (String)personId, (String)unitNumber, targetRole.isDescends()), new PersistenceOption[0]);
                        }
                    }));
                } else if (SyncBehavior.DELETE_READD.equals((Object)syncBehavior)) {
                    personUnits.forEach((personId, unitNumbers) -> unitNumbers.forEach(unitNumber -> {
                        this.findMatchingPrincipalRoleMembers(role.getMembers(), (String)unitNumber, (String)personId).forEach(arg_0 -> ((DataObjectService)this.dataObjectService).delete(arg_0));
                        this.dataObjectService.save((Object)this.createRoleMember(role.getId(), role.getKimTypeId(), (String)personId, (String)unitNumber, targetRole.isDescends()), new PersistenceOption[0]);
                    }));
                } else {
                    throw new RuntimeException(syncBehavior + " not supported");
                }
            }
        });
    }

    private List<RoleMemberBo> findMatchingPrincipalRoleMembers(List<RoleMemberBo> roleMembers, String unitNumber, String personId) {
        return roleMembers.stream().filter(member -> MemberType.PRINCIPAL.equals((Object)member.getType())).filter(member -> member.getMemberId().equals(personId)).filter(member -> StringUtils.equals((CharSequence)((CharSequence)member.getAttributes().get("unitNumber")), (CharSequence)unitNumber)).collect(Collectors.toList());
    }

    private List<RoleMemberBo> findMatchingPrincipalRoleMembers(List<RoleMemberBo> roleMembers) {
        return roleMembers.stream().filter(member -> MemberType.PRINCIPAL.equals((Object)member.getType())).collect(Collectors.toList());
    }

    private RoleMemberBo createRoleMember(String roleId, String kimTypeId, String principalId, String unitNumber, boolean descends) {
        RoleMemberBo roleMember = new RoleMemberBo();
        roleMember.setRoleId(roleId);
        roleMember.setMemberId(principalId);
        roleMember.setType(MemberType.PRINCIPAL);
        roleMember.setAttributeDetails(this.isUnitHierarchyType(kimTypeId) ? this.createUnitHierarchyQual(unitNumber, descends) : this.createUnitQual(unitNumber));
        return roleMember;
    }

    private boolean isUnitHierarchyType(String kimTypeId) {
        return "10001".equals(kimTypeId);
    }

    private List<RoleMemberAttributeDataBo> createUnitQual(String unitNumber) {
        RoleMemberAttributeDataBo unitQualifier = new RoleMemberAttributeDataBo();
        unitQualifier.setKimTypeId("10000");
        unitQualifier.setKimAttributeId("10000");
        unitQualifier.setAttributeValue(unitNumber);
        return Stream.of(unitQualifier).collect(Collectors.toList());
    }

    private List<RoleMemberAttributeDataBo> createUnitHierarchyQual(String unitNumber, boolean subunits) {
        RoleMemberAttributeDataBo unitQualifier = new RoleMemberAttributeDataBo();
        unitQualifier.setKimTypeId("10001");
        unitQualifier.setKimAttributeId("10000");
        unitQualifier.setAttributeValue(unitNumber);
        RoleMemberAttributeDataBo subunitsQualifier = new RoleMemberAttributeDataBo();
        subunitsQualifier.setKimTypeId("10001");
        subunitsQualifier.setKimAttributeId("10001");
        subunitsQualifier.setAttributeValue(subunits ? "Y" : "N");
        return Stream.of(unitQualifier, subunitsQualifier).collect(Collectors.toList());
    }

    private void clearKimCache() {
        KIM_CACHE_NAMES.stream().map(name -> this.getGlobalCacheManager().getCache(name)).filter(Objects::nonNull).forEach(Cache::clear);
    }

    private Collector<Map.Entry<String, Set<String>>, ?, Map<String, Set<String>>> entriesToMapWithMergedSet() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> Stream.concat(v1.stream(), v2.stream()).collect(Collectors.toSet()), HashMap::new);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public CacheManager getGlobalCacheManager() {
        return this.globalCacheManager;
    }

    public void setGlobalCacheManager(CacheManager globalCacheManager) {
        this.globalCacheManager = globalCacheManager;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }
}

