/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.coi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.AbstractProjectRetrievalService;
import org.kuali.coeus.coi.framework.PersonType;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPerson;
import org.kuali.coeus.coi.framework.ProjectSponsor;
import org.kuali.coeus.coi.framework.ProjectTypeCode;
import org.kuali.coeus.coi.framework.Versionedproject;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyStatusConstants;
import org.springframework.stereotype.Component;

@Component(value="propDevProjectRetrievalService")
public class PropDevProjectRetrievalServiceImpl
extends AbstractProjectRetrievalService {
    private static final String PD_ALL_PROJECT_QUERY = "SELECT t.TITLE, t.PROPOSAL_NUMBER, t.STATUS_CODE, t.REQUESTED_START_DATE_INITIAL, t.REQUESTED_END_DATE_INITIAL, t.SPONSOR_CODE, u.SPONSOR_NAME, t.PRIME_SPONSOR_CODE, p.SPONSOR_NAME, t.SPONSOR_PROPOSAL_NUMBER, t.NOTICE_OF_OPPORTUNITY_CODE, n.DESCRIPTION, u.SPONSOR_TYPE_CODE, st.DESCRIPTION as SPONSOR_TYPE_DESCRIPTION, pst.SPONSOR_TYPE_CODE as PRIME_SPONSOR_TYPE_CODE, pst.DESCRIPTION as PRIME_SPONSOR_TYPE_DESCRIPTION FROM EPS_PROPOSAL t LEFT OUTER JOIN SPONSOR u ON t.SPONSOR_CODE = u.SPONSOR_CODE LEFT OUTER JOIN SPONSOR p ON t.PRIME_SPONSOR_CODE = p.SPONSOR_CODE LEFT OUTER JOIN NOTICE_OF_OPPORTUNITY n ON t.NOTICE_OF_OPPORTUNITY_CODE = n.NOTICE_OF_OPPORTUNITY_CODE LEFT OUTER JOIN SPONSOR_TYPE st ON u.SPONSOR_TYPE_CODE = st.SPONSOR_TYPE_CODE LEFT OUTER JOIN SPONSOR_TYPE pst ON p.SPONSOR_TYPE_CODE = pst.SPONSOR_TYPE_CODE WHERE t.IS_HIERARCHY in ('" + HierarchyStatusConstants.None.code() + "', '" + HierarchyStatusConstants.Child.code() + "')";
    private static final String PD_ALL_PROJECT_PERSON_QUERY = "SELECT t.PROPOSAL_NUMBER, t.PERSON_ID, t.ROLODEX_ID, t.PROP_PERSON_ROLE_ID FROM EPS_PROP_PERSON t INNER JOIN EPS_PROPOSAL u ON t.PROPOSAL_NUMBER = u.PROPOSAL_NUMBER WHERE u.IS_HIERARCHY in ('" + HierarchyStatusConstants.None.code() + "', '" + HierarchyStatusConstants.Child.code() + "')";
    private static final String PD_PROJECT_QUERY = PD_ALL_PROJECT_QUERY + " AND t.PROPOSAL_NUMBER = ?";
    private static final String PD_PROJECT_PERSON_QUERY = PD_ALL_PROJECT_PERSON_QUERY + " AND t.PROPOSAL_NUMBER = ?";

    @Override
    public Project convertObjectToProject(Versionedproject versionedproject) throws SQLException {
        return null;
    }

    @Override
    protected Project toProject(ResultSet rs) throws SQLException {
        Project project = new Project();
        project.setTitle(rs.getString(1));
        project.setTypeCode(ProjectTypeCode.PROPOSAL.getId());
        project.setSourceSystem("KC-PD");
        String sourceIdentifier = rs.getString(2);
        project.setSourceIdentifier(sourceIdentifier);
        project.setSourceStatus(rs.getString(3));
        project.setStartDate(rs.getDate(4));
        project.setEndDate(rs.getDate(5));
        project.setPrimeSponsorCode(rs.getString(8));
        project.setPrimeSponsorName(rs.getString(9));
        project.setPrimeSponsorTypeCode(rs.getString(15));
        project.setPrimeSponsorTypeDescription(rs.getString(16));
        project.setShortUrl(this.getBaseShortUrl() + "/kc-common/development-proposals/" + sourceIdentifier);
        project.setSponsorProjectId(rs.getString(10));
        project.setNoticeOfOpportunityCode(rs.getString(11));
        project.setNoticeOfOpportunityDescription(rs.getString(12));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", sourceIdentifier);
        project.setMetadata(metadata);
        this.setSponsorFields(Collections.singletonList(new ProjectSponsor("KC-PD", sourceIdentifier, rs.getString(6), rs.getString(7), new HashMap<String, String>(metadata), rs.getString(13), rs.getString(14))), project);
        if (this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "Linked_Project_Push_Enabled").booleanValue()) {
            project.setLinkedProjects(this.getLinkedProjects(this.getMedusaService().getMedusaNode("DP", Long.parseLong(rs.getString(2)))));
        }
        return project;
    }

    @Override
    protected ProjectPerson toProjectPerson(ResultSet rs) throws SQLException {
        ProjectPerson person = new ProjectPerson();
        person.setSourceSystem("KC-PD");
        person.setSourceIdentifier(rs.getString(1));
        String personId = rs.getString(2);
        String rolodexId = rs.getString(3);
        person.setPersonId(StringUtils.isNotBlank((CharSequence)personId) ? personId : rolodexId);
        person.setSourcePersonType(StringUtils.isNotBlank((CharSequence)personId) ? PersonType.EMPLOYEE.toString() : PersonType.NONEMPLOYEE.toString());
        person.setRoleCode(rs.getString(4));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", person.getSourceIdentifier());
        person.setMetadata(metadata);
        return person;
    }

    @Override
    protected String allProjectQuery() {
        return PD_ALL_PROJECT_QUERY;
    }

    @Override
    protected String allProjectPersonQuery() {
        return PD_ALL_PROJECT_PERSON_QUERY;
    }

    @Override
    protected String projectQuery() {
        return PD_PROJECT_QUERY;
    }

    @Override
    protected String projectPersonQuery() {
        return PD_PROJECT_PERSON_QUERY;
    }
}

