/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.excon.shipment.ExconIntlShipment;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krms.api.engine.Facts;

public class ExconIntlShipmentDocument
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument,
KrmsRulesContext {
    private static final long serialVersionUID = 95857646613256L;
    private static final String DEFAULT_TAB = "Versions";
    private static final String ALTERNATE_OPEN_TAB = "Parameters";
    private static final Logger LOG = LogManager.getLogger(ExconIntlShipmentDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "ECIS";
    private transient boolean documentSaveAfterVersioning;
    private List<ExconIntlShipment> exconIntlShipmentList;
    private transient PermissionService permissionService;
    private transient KcWorkflowService kcWorkflowService;
    private transient DocHandlerService docHandlerService;

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public ExconIntlShipmentDocument() {
        this.init();
    }

    public ExconIntlShipment getExconIntlShipment() {
        return this.getExconIntlShipmentList().size() > 0 ? this.getExconIntlShipmentList().get(0) : new ExconIntlShipment();
    }

    public void setExconIntlShipment(ExconIntlShipment exconIntlShipment) {
        this.exconIntlShipmentList.set(0, exconIntlShipment);
    }

    public void setExconIntlShipmentList(List<ExconIntlShipment> exconIntlShipmentList) {
        this.exconIntlShipmentList = exconIntlShipmentList;
    }

    public List<ExconIntlShipment> getExconIntlShipmentList() {
        return this.exconIntlShipmentList;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        for (ExconIntlShipment exconIntlShipment : this.exconIntlShipmentList) {
            exconIntlShipment.setExconIntlShipmentDocument(this);
        }
    }

    public boolean isEditable() {
        WorkflowDocument workflowDoc = this.getDocumentHeader().getWorkflowDocument();
        return workflowDoc.isInitiated() || workflowDoc.isSaved() || workflowDoc.isCompletionRequested();
    }

    public boolean isCanceled() {
        WorkflowDocument workflow = this.getDocumentHeader().getWorkflowDocument();
        return workflow.isCanceled();
    }

    public boolean getCanModify() {
        HashMap qualifications = new HashMap();
        return this.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KC-AWARD", "Modify Award Account Reservation Document", qualifications);
    }

    protected void init() {
        this.exconIntlShipmentList = new ArrayList<ExconIntlShipment>();
        this.exconIntlShipmentList.add(new ExconIntlShipment());
    }

    public boolean isDocumentSaveAfterVersioning() {
        return this.documentSaveAfterVersioning;
    }

    public void setDocumentSaveAfterExconIntlShipmentLookupEditOrVersion(boolean documentSaveAfterVersioning) {
        this.documentSaveAfterVersioning = documentSaveAfterVersioning;
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && (this.getDocumentHeader().getWorkflowDocument().isFinal() || this.getDocumentHeader().getWorkflowDocument().isProcessed() || this.getKcWorkflowService().hasPendingApprovalRequests(this.getDocumentHeader().getWorkflowDocument()))) {
            isComplete = true;
        }
        return isComplete;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return null;
    }

    public List buildListOfDeletionAwareLists() {
        return super.buildListOfDeletionAwareLists();
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getExconIntlShipment().getDocumentKey();
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-EXCON");
        qualifiers.put("name", "KC Excon Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        this.getKcKrmsFactBuilderServiceHelper().addFacts(factsBuilder, this);
    }

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
    }

    public String buildForwardUrl() {
        Object forward = this.getDocHandlerService().getDocHandlerUrl(this.getDocumentNumber());
        forward = !((String)(forward = ((String)forward).replaceFirst(DEFAULT_TAB, ALTERNATE_OPEN_TAB))).contains("?") ? (String)forward + "?" : (String)forward + "&";
        forward = (String)forward + "docId=" + this.documentNumber;
        forward = (String)forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = (String)forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        return "<a href=\"" + (String)forward + "\"target=\"_blank\">" + this.documentNumber + "</a>";
    }

    @Override
    public boolean answerSplitNodeQuestion(String routeNodeName) {
        LOG.debug("Processing answerSplitNodeQuestion:" + routeNodeName);
        if (StringUtils.equals((CharSequence)"isActualMatch", (CharSequence)routeNodeName)) {
            return false;
        }
        return super.answerSplitNodeQuestion(routeNodeName);
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public KcWorkflowService getKcWorkflowService() {
        if (this.kcWorkflowService == null) {
            this.kcWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kcWorkflowService;
    }

    public void setKcWorkflowService(KcWorkflowService kcWorkflowService) {
        this.kcWorkflowService = kcWorkflowService;
    }

    public DocHandlerService getDocHandlerService() {
        if (this.docHandlerService == null) {
            this.docHandlerService = KcServiceLocator.getService(DocHandlerService.class);
        }
        return this.docHandlerService;
    }

    public void setDocHandlerService(DocHandlerService docHandlerService) {
        this.docHandlerService = docHandlerService;
    }

    protected KcKrmsFactBuilderServiceHelper getKcKrmsFactBuilderServiceHelper() {
        return (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("exconIntlShipmentFactBuilderService");
    }
}

