/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcHoldingPageAction
extends KualiAction {
    private static final String RETURN_TO_PORTAL = "returnToPortal";
    private DocumentService documentService;
    private PersonService personService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        String documentIdParameter = request.getParameter("holdingPageDocumentId");
        Object documentId = StringUtils.isNotBlank((CharSequence)documentIdParameter) ? documentIdParameter : request.getSession().getAttribute("documentHttpSessionKey");
        Document document = this.getByDocumentHeaderId(documentId.toString());
        if (RETURN_TO_PORTAL.equals(this.findMethodToCall(form, request))) {
            this.cleanupUserSession();
            GlobalVariables.getUserSession().removeObject("holdingPageMessages");
        } else if (GlobalVariables.getUserSession().retrieveObject("forceHoldingForActionList") != null) {
            GlobalVariables.getUserSession().removeObject("forceHoldingForActionList");
            forward = this.getReturnPath(request);
        } else if (this.isDocumentPostprocessingComplete(document)) {
            forward = this.getReturnPath(request);
        }
        return forward;
    }

    private ActionForward getReturnPath(HttpServletRequest request) {
        String documentIdParameter = request.getParameter("holdingPageReturnLocation");
        String backLocation = StringUtils.isNotBlank((CharSequence)documentIdParameter) ? documentIdParameter : (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
        this.cleanupUserSession();
        return new ActionForward(backLocation, true);
    }

    private void cleanupUserSession() {
        GlobalVariables.getUserSession().removeObject("holdingPageReturnLocation");
    }

    public ActionForward returnToPortal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("portal");
    }

    protected boolean isDocumentPostprocessingComplete(Document document) {
        return document.getDocumentHeader().hasWorkflowDocument() && !this.isPessimisticallyLocked(document) && this.isProcessComplete(document);
    }

    protected boolean isPessimisticallyLocked(Document document) {
        boolean isPessimisticallyLocked = false;
        Person pessimisticLockHolder = this.getPersonService().getPersonByPrincipalName("kr");
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (!pessimisticLock.isOwnedByUser(pessimisticLockHolder)) continue;
            isPessimisticallyLocked = true;
            break;
        }
        return isPessimisticallyLocked;
    }

    protected boolean isProcessComplete(Document document) {
        boolean isProcessComplete = false;
        if (document instanceof KcTransactionalDocumentBase) {
            isProcessComplete = ((KcTransactionalDocumentBase)document).isProcessComplete();
        }
        return isProcessComplete;
    }

    protected Document getByDocumentHeaderId(String documentId) throws WorkflowException {
        return this.getDocumentService().getByDocumentHeaderId(documentId);
    }

    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KcServiceLocator.getService(DocumentService.class);
        }
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KcServiceLocator.getService(PersonService.class);
        }
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

