/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.api.attachment;

import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api"})
@Controller(value="fileDataController")
public class FileDataController
extends RestController {
    private static final String FILE_DATA = "FileData";
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kcAttachmentDataDao")
    private KcAttachmentDataDao kcAttachmentDataDao;

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/file-data/{fileDataId}"}, produces={"application/octet-stream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public byte[] getFileData(@PathVariable String fileDataId) {
        this.assertUserHasReadAccess();
        byte[] data = this.kcAttachmentDataDao.getData(fileDataId);
        if (ArrayUtils.isEmpty((byte[])data)) {
            throw new UnprocessableEntityException("File Data with fileDataId " + fileDataId + " not found.");
        }
        return data;
    }

    protected void assertUserHasReadAccess() {
        if (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", FILE_DATA))) {
            throw new UnauthorizedAccessException();
        }
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDataDao) {
        this.kcAttachmentDataDao = kcAttachmentDataDao;
    }
}

