/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.rolodex;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.framework.contact.Contactable;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="ROLODEX")
public class Rolodex
extends KcPersistableBusinessObjectBase
implements Contactable,
MutableInactivatable,
RolodexContract {
    private static final long serialVersionUID = -278526635683595863L;
    @Id
    @Column(name="ROLODEX_ID")
    private Integer rolodexId;
    @Column(name="ADDRESS_LINE_1")
    private String addressLine1;
    @Column(name="ADDRESS_LINE_2")
    private String addressLine2;
    @Column(name="ADDRESS_LINE_3")
    private String addressLine3;
    @Column(name="CITY")
    private String city;
    @Column(name="COMMENTS")
    private String comments;
    @Column(name="COUNTRY_CODE")
    private String countryCode;
    @Column(name="COUNTY")
    private String county;
    @Column(name="DELETE_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean deleteFlag;
    @Column(name="EMAIL_ADDRESS")
    private String emailAddress;
    @Column(name="FAX_NUMBER")
    private String faxNumber;
    @Column(name="FIRST_NAME")
    private String firstName;
    @Column(name="LAST_NAME")
    private String lastName;
    @Column(name="MIDDLE_NAME")
    private String middleName;
    @Column(name="ORGANIZATION")
    private String organization;
    @Column(name="OWNED_BY_UNIT")
    private String ownedByUnit;
    @Column(name="PHONE_NUMBER")
    private String phoneNumber;
    @Column(name="POSTAL_CODE")
    private String postalCode;
    @Column(name="PREFIX")
    private String prefix;
    @Column(name="SPONSOR_ADDRESS_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private boolean sponsorAddressFlag;
    @Column(name="SPONSOR_CODE")
    private String sponsorCode;
    @Column(name="STATE")
    private String state;
    @Column(name="SUFFIX")
    private String suffix;
    @Column(name="TITLE")
    private String title;
    @Column(name="CREATE_USER")
    private String createUser;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="OWNED_BY_UNIT", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit unit;
    @OneToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="SPONSOR_CODE", referencedColumnName="SPONSOR_CODE", insertable=false, updatable=false)
    private Sponsor sponsor;

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    @Override
    public void setUpdateUser(String updateUser) {
        super.setUpdateUser(updateUser);
        this.setCreateUser(updateUser);
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public Boolean getDeleteFlag() {
        return this.deleteFlag;
    }

    public void setDeleteFlag(Boolean deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOwnedByUnit() {
        return this.ownedByUnit;
    }

    public void setOwnedByUnit(String ownedByUnit) {
        this.ownedByUnit = ownedByUnit;
    }

    @Override
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean getSponsorAddressFlag() {
        return this.sponsorAddressFlag;
    }

    public void setSponsorAddressFlag(boolean sponsorAddressFlag) {
        this.sponsorAddressFlag = sponsorAddressFlag;
    }

    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
    }

    public Sponsor getSponsor() {
        return this.sponsor;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getFullName() {
        StringBuilder name = new StringBuilder();
        if (this.getLastName() != null) {
            name.append(this.getLastName());
            name.append(", ");
        }
        if (this.getPrefix() != null) {
            name.append(this.getPrefix());
            name.append(" ");
        }
        if (this.getFirstName() != null) {
            name.append(this.getFirstName());
            name.append(" ");
        }
        if (this.getMiddleName() != null) {
            name.append(this.getMiddleName());
        }
        return name.length() > 0 ? name.toString() : null;
    }

    @Override
    public String getContactOrganizationName() {
        return this.getUnit().getUnitName();
    }

    @Override
    public Serializable getIdentifier() {
        return this.getRolodexId();
    }

    @Override
    public String getOrganizationIdentifier() {
        return this.getUnit().getOrganizationId();
    }

    @Deprecated
    public String getIsSponsorAddress() {
        return this.sponsorAddressFlag ? "Y" : "N";
    }

    @Deprecated
    public void setIsSponsorAddress(String isSponsorAddress) {
        this.sponsorAddressFlag = StringUtils.equalsIgnoreCase((CharSequence)isSponsorAddress, (CharSequence)"Y");
    }
}

