/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;

public class ExconProjectFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            ExconProjectDocument exconDocument = (ExconProjectDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, exconDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, KrmsRulesContext document) {
        ExconProjectDocument exconDocument = (ExconProjectDocument)document;
        ExconProject exconProject = exconDocument.getExconProject();
        this.addExconProjectFacts(factsBuilder, exconProject);
    }

    private void addExconProjectFacts(Facts.Builder factsBuilder, ExconProject exconProject) {
        this.addObjectMembersAsFacts(factsBuilder, exconProject, "KC-EXCON-PROJECT-CONTEXT", "KC-EXCON");
        factsBuilder.addFact("ExconProject", (Object)exconProject);
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

