/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.rate;

import java.io.Serializable;
import java.sql.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.budget.api.rate.AbstractInstituteRateContract;
import org.kuali.coeus.common.budget.framework.rate.AbstractInstituteRateKey;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.BooleanNFConverter;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

@MappedSuperclass
public abstract class AbstractInstituteRate
extends KcPersistableBusinessObjectBase
implements Comparable<AbstractInstituteRate>,
AbstractInstituteRateKey,
MutableInactivatable,
AbstractInstituteRateContract {
    private static final long serialVersionUID = -2136003574701633349L;
    @Id
    @Column(name="FISCAL_YEAR")
    private String fiscalYear;
    @Id
    @Column(name="ON_OFF_CAMPUS_FLAG")
    @Convert(converter=BooleanNFConverter.class)
    private Boolean onOffCampusFlag;
    @Id
    @Column(name="RATE_CLASS_CODE")
    private String rateClassCode;
    @Id
    @Column(name="RATE_TYPE_CODE")
    private String rateTypeCode;
    @Id
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="INSTITUTE_RATE")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal instituteRate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false)
    private RateClass rateClass;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false), @JoinColumn(name="RATE_TYPE_CODE", referencedColumnName="RATE_TYPE_CODE", insertable=false, updatable=false)})
    private RateType rateType;
    @Transient
    private String unitNumber;
    @Transient
    private ScaleTwoDecimal externalApplicableRate;
    @Transient
    private Unit unit;
    @Transient
    private Boolean active = Boolean.TRUE;
    @Transient
    private boolean nonEditableRateFlag;

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        this.active = active;
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public RateType getRateType() {
        return this.rateType;
    }

    public void setRateType(RateType rateType) {
        this.rateType = rateType;
    }

    public String getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(String fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    @Override
    public Boolean getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    public void setOnOffCampusFlag(Boolean onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    @Override
    public String getRateClassCode() {
        return this.rateClassCode;
    }

    public void setRateClassCode(String rateClassCode) {
        this.rateClassCode = rateClassCode;
    }

    @Override
    public String getRateTypeCode() {
        return this.rateTypeCode;
    }

    public void setRateTypeCode(String rateTypeCode) {
        this.rateTypeCode = rateTypeCode;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public ScaleTwoDecimal getInstituteRate() {
        return this.instituteRate;
    }

    public void setInstituteRate(ScaleTwoDecimal rate) {
        this.instituteRate = rate;
    }

    public String getRateClassType() {
        return this.rateClass.getRateClassTypeCode();
    }

    @Override
    public int compareTo(AbstractInstituteRate abstractInstituteRate) {
        int result = this.getRateType().getDescription().compareTo(abstractInstituteRate.getRateType().getDescription());
        result = result != 0 ? result : this.getFiscalYear().compareTo(abstractInstituteRate.getFiscalYear());
        result = result != 0 ? result : this.getOnOffCampusFlag().compareTo(abstractInstituteRate.getOnOffCampusFlag());
        return result;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public String getRateKeyAsString() {
        return this.getRateClassCode() + this.getRateTypeCode() + this.getLocationFlagAsString(this.getOnOffCampusFlag()) + this.getStartDate();
    }

    private String getLocationFlagAsString(boolean campusFlag) {
        return campusFlag ? "N" : "F";
    }

    public boolean getNonEditableRateFlag() {
        return this.nonEditableRateFlag;
    }

    public void setNonEditableRateFlag(boolean nonEditableRateFlag) {
        this.nonEditableRateFlag = nonEditableRateFlag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active == null ? 0 : this.active.hashCode());
        result = 31 * result + (this.fiscalYear == null ? 0 : this.fiscalYear.hashCode());
        result = 31 * result + (this.instituteRate == null ? 0 : this.instituteRate.hashCode());
        result = 31 * result + (this.onOffCampusFlag == null ? 0 : this.onOffCampusFlag.hashCode());
        result = 31 * result + (this.rateClass == null ? 0 : this.rateClass.hashCode());
        result = 31 * result + (this.rateClassCode == null ? 0 : this.rateClassCode.hashCode());
        result = 31 * result + (this.rateType == null ? 0 : this.rateType.hashCode());
        result = 31 * result + (this.rateTypeCode == null ? 0 : this.rateTypeCode.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.unitNumber == null ? 0 : this.unitNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInstituteRate other = (AbstractInstituteRate)obj;
        if (this.active == null ? other.active != null : !this.active.equals(other.active)) {
            return false;
        }
        if (this.fiscalYear == null ? other.fiscalYear != null : !this.fiscalYear.equals(other.fiscalYear)) {
            return false;
        }
        if (this.instituteRate == null ? other.instituteRate != null : !this.instituteRate.equals((Object)other.instituteRate)) {
            return false;
        }
        if (this.onOffCampusFlag == null ? other.onOffCampusFlag != null : !this.onOffCampusFlag.equals(other.onOffCampusFlag)) {
            return false;
        }
        if (this.rateClass == null ? other.rateClass != null : !this.rateClass.equals(other.rateClass)) {
            return false;
        }
        if (this.rateClassCode == null ? other.rateClassCode != null : !this.rateClassCode.equals(other.rateClassCode)) {
            return false;
        }
        if (this.rateType == null ? other.rateType != null : !this.rateType.equals(other.rateType)) {
            return false;
        }
        if (this.rateTypeCode == null ? other.rateTypeCode != null : !this.rateTypeCode.equals(other.rateTypeCode)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return !(this.unitNumber == null ? other.unitNumber != null : !this.unitNumber.equals(other.unitNumber));
    }

    public ScaleTwoDecimal getExternalApplicableRate() {
        return this.externalApplicableRate == null ? this.getInstituteRate() : this.externalApplicableRate;
    }

    public void setExternalApplicableRate(ScaleTwoDecimal externalApplicableRate) {
        this.externalApplicableRate = externalApplicableRate;
    }

    public static abstract class AbstractInstituteRateId
    implements Serializable {
        private String fiscalYear;
        private Boolean onOffCampusFlag;
        private String rateClassCode;
        private String rateTypeCode;
        private Date startDate;

        public String toString() {
            return new ToStringBuilder((Object)this).append("fiscalYear", (Object)this.fiscalYear).append("onOffCampusFlag", (Object)this.onOffCampusFlag).append("rateClassCode", (Object)this.rateClassCode).append("rateTypeCode", (Object)this.rateTypeCode).append("startDate", (Object)this.startDate).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            AbstractInstituteRateId rhs = (AbstractInstituteRateId)other;
            return new EqualsBuilder().append((Object)this.fiscalYear, (Object)rhs.fiscalYear).append((Object)this.onOffCampusFlag, (Object)rhs.onOffCampusFlag).append((Object)this.rateClassCode, (Object)rhs.rateClassCode).append((Object)this.rateTypeCode, (Object)rhs.rateTypeCode).append((Object)this.startDate, (Object)rhs.startDate).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.fiscalYear).append((Object)this.onOffCampusFlag).append((Object)this.rateClassCode).append((Object)this.rateTypeCode).append((Object)this.startDate).toHashCode();
        }

        public int compareTo(AbstractInstituteRateId other) {
            return new CompareToBuilder().append((Object)this.fiscalYear, (Object)other.fiscalYear).append((Object)this.onOffCampusFlag, (Object)other.onOffCampusFlag).append((Object)this.rateClassCode, (Object)other.rateClassCode).append((Object)this.rateTypeCode, (Object)other.rateTypeCode).append((Object)this.startDate, (Object)other.startDate).toComparison();
        }

        public String getFiscalYear() {
            return this.fiscalYear;
        }

        public void setFiscalYear(String fiscalYear) {
            this.fiscalYear = fiscalYear;
        }

        public Boolean getOnOffCampusFlag() {
            return this.onOffCampusFlag;
        }

        public void setOnOffCampusFlag(Boolean onOffCampusFlag) {
            this.onOffCampusFlag = onOffCampusFlag;
        }

        public String getRateClassCode() {
            return this.rateClassCode;
        }

        public void setRateClassCode(String rateClassCode) {
            this.rateClassCode = rateClassCode;
        }

        public String getRateTypeCode() {
            return this.rateTypeCode;
        }

        public void setRateTypeCode(String rateTypeCode) {
            this.rateTypeCode = rateTypeCode;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }
    }
}

