/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.copy;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.copy.CopyMode;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyCriteria;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentCopyController
extends ProposalDevelopmentControllerBase {
    public static final String COPY_DIALOG = "PropDev-CopyDialog-Section";
    private static final String IS_COPIED_PROPOSAL = "isCopiedProposal";
    @Autowired
    @Qualifier(value="documentTypeService")
    private DocumentTypeService documentTypeService;
    @Autowired
    @Qualifier(value="proposalCopyService")
    private ProposalCopyService proposalCopyService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copy"})
    public ModelAndView copy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ProposalCopyCriteria proposalCopyCriteria = form.getProposalCopyCriteria();
        if (StringUtils.isNotBlank((CharSequence)proposalCopyCriteria.getLeadUnitNumber()) || proposalCopyCriteria.isHierarchyCopy()) {
            ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
            this.releaseLocksForLoggedInUser(form);
            ProposalDevelopmentDocument newDoc = !proposalCopyCriteria.isHierarchyCopy() ? this.getProposalCopyService().copyProposal(proposalDevelopmentDocument, proposalCopyCriteria) : this.getProposalCopyService().copyProposalHierarchy(form.getProposalDevelopmentDocument(), proposalCopyCriteria);
            if (newDoc != null) {
                return this.returnToDocument(form, newDoc.getDocumentNumber());
            }
        }
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=displayCopyDialog"})
    public ModelAndView displayCopyDialog(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        if (form.getDevelopmentProposal().isInHierarchy()) {
            return this.getModelAndViewService().showDialog("PropDev-Copy-Hierarchy-Or-Single-Dialog", true, (UifFormBase)form);
        }
        return this.copySingleProposal(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copyAllHierarchy"})
    public ModelAndView copyAllHierarchy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalCopyCriteria(new ProposalCopyCriteria(form.getProposalDevelopmentDocument()));
        form.getProposalCopyCriteria().setCopyMode(CopyMode.HIERARCHY);
        form.getProposalCopyCriteria().setIncludeBudget(true);
        form.getProposalCopyCriteria().setIncludeAttachments(true);
        return this.displayCopyDialogDirect(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copySingleProposal"})
    public ModelAndView copySingleProposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalCopyCriteria(new ProposalCopyCriteria(form.getProposalDevelopmentDocument()));
        form.getProposalCopyCriteria().setCopyMode(CopyMode.SINGLE);
        return this.displayCopyDialogDirect(form);
    }

    public ModelAndView displayCopyDialogDirect(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ((ProposalDevelopmentViewHelperServiceImpl)form.getView().getViewHelperService()).populateQuestionnaires(form);
        return this.getModelAndViewService().showDialog(COPY_DIALOG, true, (UifFormBase)form);
    }

    protected ModelAndView returnToDocument(ProposalDevelopmentDocumentForm form, String newDocNum) {
        String docHandlerUrl = this.getDocHandlerUrl(form);
        Properties props = new Properties();
        props.put("command", "displayDocSearchView");
        props.put("docId", newDocNum);
        props.put(IS_COPIED_PROPOSAL, "true");
        if (StringUtils.isNotBlank((CharSequence)form.getReturnFormKey())) {
            props.put("formKey", form.getReturnFormKey());
        }
        return this.getModelAndViewService().performRedirect((UifFormBase)form, docHandlerUrl, props);
    }

    protected String getDocHandlerUrl(ProposalDevelopmentDocumentForm form) {
        DocumentType docType = this.getDocumentTypeService().getDocumentTypeByName(form.getDocTypeName());
        return docType.getResolvedDocumentHandlerUrl();
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public ProposalCopyService getProposalCopyService() {
        return this.proposalCopyService;
    }

    public void setProposalCopyService(ProposalCopyService proposalCopyService) {
        this.proposalCopyService = proposalCopyService;
    }
}

