/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

@Entity
@Table(name="EPS_PROP_PERSON_CERT_DETAILS")
@IdClass(value=ProposalPersonCertificationDetailsId.class)
public class ProposalPersonCertificationDetails
extends KcPersistableBusinessObjectBase {
    private static final long serialVersionUID = -4110005875629288373L;
    @Id
    @Column(name="PROP_PERSON_NUMBER")
    private Integer proposalPersonNumber;
    @Id
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber;
    @Column(name="CERTIFIED_BY")
    private String certifiedBy;
    @Column(name="CERTIFIED_TIME")
    private Timestamp certifiedTime;
    @Transient
    private transient String certifiedPersonName;
    @Transient
    private transient String certifiedTimeStamp;
    @Transient
    private transient KcPersonService kcPersonService;

    public ProposalPersonCertificationDetails() {
    }

    public ProposalPersonCertificationDetails(Integer proposalPersonNumber, String proposalNumber) {
        this.proposalPersonNumber = proposalPersonNumber;
        this.proposalNumber = proposalNumber;
    }

    public Integer getProposalPersonNumber() {
        return this.proposalPersonNumber;
    }

    public void setProposalPersonNumber(Integer proposalPersonNumber) {
        this.proposalPersonNumber = proposalPersonNumber;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public String getCertifiedPersonName() {
        if (this.certifiedBy != null) {
            this.certifiedPersonName = this.getKcPersonService().getKcPersonByPersonId(this.certifiedBy).getUserName();
        }
        return this.certifiedPersonName;
    }

    public void setCertifiedPersonName(String certifiedPersonName) {
        this.certifiedPersonName = certifiedPersonName;
    }

    public String getCertifiedTimeStamp() {
        if (this.certifiedTime != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
            this.certifiedTimeStamp = simpleDateFormat.format(this.certifiedTime);
        }
        return this.certifiedTimeStamp;
    }

    public void setCertifiedTimeStamp(String certifiedTimeStamp) {
        this.certifiedTimeStamp = certifiedTimeStamp;
    }

    public String getCertifiedBy() {
        return this.certifiedBy;
    }

    public void setCertifiedBy(String certifiedBy) {
        this.certifiedBy = certifiedBy;
    }

    public Timestamp getCertifiedTime() {
        return this.certifiedTime;
    }

    public void setCertifiedTime(Timestamp certifiedTime) {
        this.certifiedTime = certifiedTime;
    }

    public static final class ProposalPersonCertificationDetailsId
    implements Serializable,
    Comparable<ProposalPersonCertificationDetailsId> {
        private Integer proposalPersonNumber;
        private String proposalNumber;

        public Integer getProposalPersonNumber() {
            return this.proposalPersonNumber;
        }

        public void setProposalPersonNumber(Integer proposalPersonNumber) {
            this.proposalPersonNumber = proposalPersonNumber;
        }

        public String getProposalNumber() {
            return this.proposalNumber;
        }

        public void setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("proposalPersonNumber", (Object)this.proposalPersonNumber).append("proposalNumber", (Object)this.proposalNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalPersonCertificationDetailsId rhs = (ProposalPersonCertificationDetailsId)other;
            return new EqualsBuilder().append((Object)this.proposalPersonNumber, (Object)rhs.proposalPersonNumber).append((Object)this.proposalNumber, (Object)rhs.proposalNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.proposalPersonNumber).append((Object)this.proposalNumber).toHashCode();
        }

        @Override
        public int compareTo(ProposalPersonCertificationDetailsId other) {
            return new CompareToBuilder().append((Object)this.proposalPersonNumber, (Object)other.proposalPersonNumber).append((Object)this.proposalNumber, (Object)other.proposalNumber).toComparison();
        }
    }
}

