/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment.institute;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.attachment.institute.AddInstituteAttachmentEvent;
import org.kuali.coeus.propdev.impl.attachment.institute.AddInstituteAttachmentRule;
import org.kuali.coeus.propdev.impl.attachment.institute.ReplaceInstituteAttachmentEvent;
import org.kuali.coeus.propdev.impl.attachment.institute.ReplaceInstituteAttachmentRule;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalDevelopmentInstituteAttachmentRule
extends KcTransactionalDocumentRuleBase
implements AddInstituteAttachmentRule,
ReplaceInstituteAttachmentRule {
    private static final String INSTITUTE = "Institute";
    private static final String NEW_INSTITUTE_ATTACHMENT = "newInstituteAttachment";
    private static final String NARRATIVE_TYPE_CODE = "code";
    private static final String NARRATIVE_FILE = "narrativeFile";
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentInstituteAttachmentRule.class);
    public static final String MODULE_TITLE = "moduleTitle";
    public static final String MODULE_STATUS_CODE = "moduleStatusCode";
    public static final String INSTITUTIONAL_ATTACHMENT_TYPE_CODE = "institutionalAttachmentTypeCode";
    private ParameterService parameterService;
    private KcAttachmentService kcAttachmentService;
    private DictionaryValidationService dictionaryValidationService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    @Override
    public boolean processAddInstituteAttachmentBusinessRules(AddInstituteAttachmentEvent addInstituteAttachmentEvent) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)addInstituteAttachmentEvent.getDocument();
        Narrative narrative = addInstituteAttachmentEvent.getNarrative();
        boolean rulePassed = true;
        this.populateNarrativeType(narrative);
        String errorPath = NEW_INSTITUTE_ATTACHMENT;
        if (narrative.getNarrativeType() == null) {
            rulePassed = false;
        }
        DictionaryValidationService dictionaryValidationService = this.getKnsDictionaryValidationService();
        dictionaryValidationService.validateAttributeFormat(narrative.getClass().getName(), MODULE_TITLE, narrative.getModuleTitle(), MODULE_TITLE);
        if (GlobalVariables.getMessageMap().getPropertiesWithErrors().size() > 0) {
            rulePassed = false;
        }
        if (StringUtils.isBlank((CharSequence)narrative.getNarrativeTypeCode())) {
            rulePassed = false;
            this.reportError(INSTITUTIONAL_ATTACHMENT_TYPE_CODE, "error.proposalAttachment.narrativeType.notSelected", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)narrative.getModuleStatusCode())) {
            rulePassed = false;
            this.reportError(MODULE_STATUS_CODE, "error.proposalAttachment.narrativeStatus.notSelected", new String[0]);
        }
        if (rulePassed) {
            this.populateNarrativeType(narrative);
            String[] param = new String[]{INSTITUTE, narrative.getNarrativeType().getDescription()};
            if (!narrative.getNarrativeType().isAllowMultiple()) {
                for (Narrative narr : document.getDevelopmentProposal().getInstituteAttachments()) {
                    if (narr == null || !StringUtils.equals((CharSequence)narr.getNarrativeTypeCode(), (CharSequence)narrative.getNarrativeTypeCode())) continue;
                    LOG.debug("error.proposalAttachment.narrativeType.allowMulitple");
                    this.reportError(INSTITUTIONAL_ATTACHMENT_TYPE_CODE, "error.proposalAttachment.narrativeType.allowMulitple", param);
                    rulePassed = false;
                }
            } else if (StringUtils.isBlank((CharSequence)narrative.getModuleTitle())) {
                this.reportError(MODULE_TITLE, "error.proposalAttachment.description.required", param);
                rulePassed = false;
            }
        }
        if (StringUtils.isBlank((CharSequence)narrative.getName())) {
            rulePassed = false;
            this.reportError(NARRATIVE_FILE, "error.required.for.fileName", "File Name");
        }
        return rulePassed &= this.validFileNameCharacters(narrative, errorPath);
    }

    @Override
    public boolean processReplaceInstituteAttachmentBusinessRules(ReplaceInstituteAttachmentEvent event) {
        boolean rulePassed = true;
        rulePassed &= this.validFileNameCharacters(event.getNarrative(), event.getErrorPathPrefix());
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)event.getDocument();
        boolean isS2S = document.getDevelopmentProposal().hasS2sOpportunity();
        if (isS2S && document.getDevelopmentProposal().isNIHSponsor()) {
            rulePassed &= this.getKcFileService().validPDFFile(event.getNarrative(), this.getErrorReporter(), event.getErrorPathPrefix());
        }
        return rulePassed;
    }

    private boolean validFileNameCharacters(Narrative narrative, String errorPath) {
        String attachmentFileName;
        boolean rulePassed = true;
        KcAttachmentService attachmentService = this.getKcFileService();
        String invalidCharacters = attachmentService.getInvalidCharacters(attachmentFileName = narrative.getName());
        if (ObjectUtils.isNotNull((Object)invalidCharacters)) {
            String parameter = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "INVALID_FILE_NAME_CHECK");
            if ("2".equals(parameter)) {
                rulePassed &= false;
                this.reportError(errorPath + NARRATIVE_FILE, "error.institutionalProposal.notesAndAttachments.fileName.invalid", attachmentFileName, invalidCharacters);
            } else {
                rulePassed &= true;
                this.reportWarning(errorPath + NARRATIVE_FILE, "error.institutionalProposal.notesAndAttachments.fileName.invalid", attachmentFileName, invalidCharacters);
            }
        }
        return rulePassed;
    }

    private void populateNarrativeType(Narrative narrative) {
        HashMap<String, String> narrativeTypeMap = new HashMap<String, String>();
        narrativeTypeMap.put(NARRATIVE_TYPE_CODE, narrative.getNarrativeTypeCode());
        BusinessObjectService service = this.getBusinessObjectService();
        NarrativeType narrType = (NarrativeType)service.findByPrimaryKey(NarrativeType.class, narrativeTypeMap);
        if (narrType != null) {
            narrative.setNarrativeType(narrType);
        }
    }

    protected KcAttachmentService getKcFileService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    @Override
    protected DictionaryValidationService getKnsDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }
}

