/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.print.BudgetBaseStream;
import org.kuali.coeus.common.budget.impl.print.ReportTypeVO;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.printing.schema.BudgetSummaryReportDocument;
import org.kuali.kra.printing.schema.ReportHeaderType;
import org.kuali.kra.printing.schema.ReportPageType;
import org.kuali.kra.printing.schema.ReportType;
import org.kuali.kra.printing.schema.SubReportType;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="industrialBudgetXmlStream")
@Scope(value="prototype")
public class IndustrialBudgetXmlStream
extends BudgetBaseStream<BudgetSummaryReportDocument> {
    private static final Logger LOG = LogManager.getLogger(IndustrialBudgetXmlStream.class);

    @Override
    public Class<BudgetSummaryReportDocument> type() {
        return BudgetSummaryReportDocument.class;
    }

    @Override
    public Map<String, BudgetSummaryReportDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, BudgetSummaryReportDocument> xmlObjectList = new LinkedHashMap<String, BudgetSummaryReportDocument>();
        this.budget = (Budget)printableBusinessObject;
        if (this.budget != null) {
            for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) {
                    LOG.debug("Skipping printing of empty budget period, for Budget period - " + budgetPeriod.getBudgetPeriod());
                    continue;
                }
                this.budgetPeriod = budgetPeriod;
                BudgetSummaryReportDocument budgetSummaryReportDocument = BudgetSummaryReportDocument.Factory.newInstance();
                BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = this.getIndustrialBudgetReport();
                budgetSummaryReportDocument.setBudgetSummaryReport(budgetSummaryReport);
                xmlObjectList.put("Period" + budgetPeriod.getBudgetPeriod(), budgetSummaryReportDocument);
            }
        }
        return xmlObjectList;
    }

    private BudgetSummaryReportDocument.BudgetSummaryReport getIndustrialBudgetReport() {
        BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
        BudgetParent budgetParent = this.budget.getBudgetParent();
        ReportHeaderType reportHeaderType = this.getReportHeaderTypeForCumulativeReport(budgetParent);
        budgetSummaryReport.setReportHeader(reportHeaderType);
        ReportPageType cumilativePageType = this.getIndustrialBudgetReportPageType();
        budgetSummaryReport.setCumilativePage(cumilativePageType);
        ReportPageType[] reportPageTypeArray = this.getReportPageTypes();
        budgetSummaryReport.setReportPageArray(reportPageTypeArray);
        return budgetSummaryReport;
    }

    private ReportPageType[] getReportPageTypes() {
        ArrayList<ReportPageType> reportPageTypeList = new ArrayList<ReportPageType>();
        ReportPageType reportPageType = this.getIndustrialBudgetReportPageType();
        reportPageTypeList.add(reportPageType);
        return reportPageTypeList.toArray(new ReportPageType[0]);
    }

    private ReportPageType getIndustrialBudgetReportPageType() {
        ReportPageType reportPageType = ReportPageType.Factory.newInstance();
        ReportPageType.BudgetSummary budgetSummary = this.getIndustrialBudget();
        ReportPageType.CalculationMethodology calculationMethodology = this.getCalculationMethodology();
        reportPageType.setBudgetSummary(budgetSummary);
        reportPageType.setCalculationMethodology(calculationMethodology);
        reportPageType.setPeriod(this.budgetPeriod.getBudgetPeriod());
        return reportPageType;
    }

    private ReportPageType.BudgetSummary getIndustrialBudget() {
        ReportPageType.BudgetSummary budgetSummary = ReportPageType.BudgetSummary.Factory.newInstance();
        SubReportType subReportType = this.getIndustrialSalarySummary();
        budgetSummary.setSalarySummaryFromEDI(subReportType);
        subReportType = this.getIndustrialBudgetSummaryNonPersonnel();
        budgetSummary.setBudgetSummaryNonPersonnel(subReportType);
        subReportType = this.getBudgetIndirectCostsForReport();
        budgetSummary.setBudgetIndirectCostsForReport(subReportType);
        budgetSummary.setTotalDirectCost(this.budgetPeriod.getTotalDirectCost().doubleValue());
        budgetSummary.setTotalCostToSponsor(this.budgetPeriod.getTotalCost().doubleValue());
        budgetSummary.setTotalUnderrecoveryAmount(this.budgetPeriod.getUnderrecoveryAmount().doubleValue());
        budgetSummary.setTotalCostSharingAmount(this.budgetPeriod.getCostSharingAmount().doubleValue());
        return budgetSummary;
    }

    private SubReportType getIndustrialSalarySummary() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        this.setReportTypeForIndustrialBudgetSalary(reportTypeList);
        this.setIndustrialBudgetLASalaryForBudgetRateAndBase(reportTypeList);
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForIndustrialBudgetSalary(List<ReportType> reportTypeList) {
        this.setReportTypeListFromReportTypeVOListForIndustrialBudgetSalary(reportTypeList, this.getReportTypeVOList(this.budgetPeriod));
    }

    @Override
    protected List<AbstractBudgetRateAndBase> getRatesApplicableToVOList(List<? extends AbstractBudgetRateAndBase> rates) {
        ArrayList<AbstractBudgetRateAndBase> result = new ArrayList<AbstractBudgetRateAndBase>();
        for (AbstractBudgetRateAndBase abstractBudgetRateAndBase : rates) {
            if (this.isRateAndBaseOfRateClassTypeEB(abstractBudgetRateAndBase) || this.isRateAndBaseOfRateClassTypeVacation(abstractBudgetRateAndBase) || this.isRateAndBaseOfRateClassTypeLAwithEBVA(abstractBudgetRateAndBase)) continue;
            result.add(abstractBudgetRateAndBase);
        }
        return result;
    }

    private void setIndustrialBudgetLASalaryForBudgetRateAndBase(List<ReportType> reportTypeList) {
        ArrayList<ReportTypeVO> reportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (!this.isRateAndBaseOfRateClassTypeLAwithEBVA(budgetRateAndBase)) continue;
                Date startDate = budgetRateAndBase.getStartDate();
                Date endDate = budgetRateAndBase.getEndDate();
                String key = startDate.toString() + endDate.toString();
                if (laRateBaseMap.containsKey(key)) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForIndustrialBudgetLASalaryForRateBase(budgetLineItem, budgetRateAndBase);
                reportTypeVOList.add(reportTypeVO);
                laRateBaseMap.put(key, budgetRateAndBase);
            }
        }
        this.setReportTypeBudgetLASalary(reportTypeList, reportTypeVOList);
    }

    private ReportTypeVO getReportTypeVOForIndustrialBudgetLASalaryForRateBase(BudgetLineItem budgetLineItem, BudgetRateAndBase budgetRateAndBase) {
        ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetLASalaryForRateBase(budgetLineItem, budgetRateAndBase);
        reportTypeVO.setSalaryRequested((ScaleTwoDecimal)reportTypeVO.getSalaryRequested().add((AbstractDecimal)reportTypeVO.getFringe()));
        return reportTypeVO;
    }

    private void setReportTypeListFromReportTypeVOListForIndustrialBudgetSalary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String reportTypeKey = this.getKeyForIndustrialBudget(reportTypeVO);
            if (reportTypeMap.containsKey(reportTypeKey)) continue;
            ScaleTwoDecimal salary = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String reportTypeTempKey = this.getKeyForIndustrialBudget(tempReportTypeVO);
                if (!reportTypeTempKey.equals(reportTypeKey)) continue;
                salary = (ScaleTwoDecimal)salary.add((AbstractDecimal)tempReportTypeVO.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForIndustrialBudgetSalary(salary, reportTypeVO);
            reportTypeMap.put(reportTypeKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForIndustrialBudgetSalary(ScaleTwoDecimal salary, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)reportTypeVO.getStartDate(), (String)"MM/dd/yy"));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)reportTypeVO.getEndDate(), (String)"MM/dd/yy"));
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setPersonName(reportTypeVO.getPersonName());
        reportType.setPercentEffort(reportTypeVO.getPercentEffort() != null ? reportTypeVO.getPercentEffort().doubleValue() : 0.0);
        reportType.setPercentCharged(reportTypeVO.getPercentCharged() != null ? reportTypeVO.getPercentCharged().doubleValue() : 0.0);
        if (reportTypeVO.getBudgetCategoryCode() != null) {
            reportType.setBudgetCategoryCode(Integer.parseInt(reportTypeVO.getBudgetCategoryCode()));
        }
        salary = (ScaleTwoDecimal)salary.add((AbstractDecimal)reportTypeVO.getSalaryRequested());
        reportType.setSalaryRequested(salary.doubleValue());
        reportType.setInvestigatorFlag(reportTypeVO.getInvestigatorFlag());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        return reportType;
    }

    private String getKeyForIndustrialBudget(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getStartDate().toString()).append(reportTypeVO.getEndDate().toString()).append(reportTypeVO.getPersonName()).append(reportTypeVO.getInvestigatorFlag().toString()).append(reportTypeVO.getBudgetCategoryCode()).append(reportTypeVO.getBudgetCategoryDesc()).append(reportTypeVO.getBudgetLineItemId());
        return key.toString();
    }

    private SubReportType getIndustrialBudgetSummaryNonPersonnel() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.LAB_ALLOCATION.getRateClassType(), budgetLineItem));
        }
        ReportType reportType = this.getReportTypeForNonPersonnel("Other Direct Costs", "Allocated Lab Expense", calculatedCost, null);
        if (calculatedCost.doubleValue() > 0.0) {
            reportTypeList.add(reportType);
        }
        this.setReportTypeForIndustrialBudgetNonPersonnel(reportTypeList);
        reportTypeList.sort(Comparator.comparing(ReportType::getBudgetCategoryDescription));
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForIndustrialBudgetNonPersonnel(List<ReportType> reportTypeList) {
        ReportTypeVO tempReportTypeVO;
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel(budgetLineItem) || this.checkLineItemNumberAvailableForIndustrialNonPersonnel(budgetLineItem)) continue;
            tempReportTypeVO = this.getReportTypeVOForIndustrialNonPersonnel(budgetLineItem);
            tempReportTypeVOList.add(tempReportTypeVO);
        }
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel(budgetLineItem) || !this.isOverhead(budgetLineItem)) continue;
            tempReportTypeVO = this.getReportTypeVOForIndustrialNonPersonnel(budgetLineItem);
            tempReportTypeVOList.add(tempReportTypeVO);
        }
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String industrialBudgetNonPersKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(industrialBudgetNonPersKey)) continue;
            ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String industrialBudgetNonPersTempKey = reportTypeVO1.getCostElementDesc();
                if (!industrialBudgetNonPersTempKey.equals(industrialBudgetNonPersKey)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)reportTypeVO1.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForIndustrialNonPersonnel(calculatedCost, reportTypeVO);
            reportTypeMap.put(industrialBudgetNonPersKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForIndustrialNonPersonnel(ScaleTwoDecimal calculatedCost, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        return reportType;
    }

    private ReportTypeVO getReportTypeVOForIndustrialNonPersonnel(BudgetLineItem budgetLineItem) {
        ReportTypeVO tempReportTypeVO = new ReportTypeVO();
        tempReportTypeVO.setBudgetCategoryDesc(budgetLineItem.getBudgetCategory().getDescription());
        tempReportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
        tempReportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
        return tempReportTypeVO;
    }

    private boolean isOverhead(BudgetLineItem budgetLineItem) {
        boolean availabe = false;
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            if (!budgetLineItemCalcAmount.getApplyRateFlag().booleanValue() || !this.isLineItemCalAmountOfRateClassTypeOverhead(budgetLineItemCalcAmount)) continue;
            availabe = true;
            break;
        }
        return availabe;
    }

    private boolean checkLineItemNumberAvailableForIndustrialNonPersonnel(BudgetLineItem budgetLineItem) {
        boolean availabe = false;
        Integer lineItemNumber = budgetLineItem.getLineItemNumber();
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            if (!this.isLineItemCalAmountOfRateClassTypeOverhead(budgetLineItemCalcAmount) || !budgetLineItemCalcAmount.getLineItemNumber().equals(lineItemNumber)) continue;
            availabe = true;
        }
        return availabe;
    }
}

