/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.scheduling;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.scheduling.KcCronTriggerService;
import org.kuali.coeus.sys.framework.scheduling.util.KcCronTriggerParameterDetails;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;

public class KcCronTriggerBean
extends CronTriggerFactoryBean {
    public static final String PARAMETER_DETAILS_KEY = "CRON_TRIGGER_PARAMETER_DETAILS";
    private static final Logger LOG = LogManager.getLogger(KcCronTriggerBean.class);
    private String defaultCronExpression = "0 0 5 * * ?";
    private String parameterNamespace;
    private String parameterComponent;
    private String cronExpressionParameterName;
    private String triggerEnabledParameterName;
    private String startTimeParameterName;
    private String misfireSkipParameterName;
    private ParameterService parameterService;
    private KcCronTriggerService kcCronTriggerService;

    public void afterPropertiesSet() throws ParseException {
        this.setCronExpression(this.getSystemCronExpression());
        this.setStartTime(this.getCronStartTime());
        this.setMisfireInstruction(this.getMisfireInstruction());
        super.afterPropertiesSet();
        KcCronTriggerParameterDetails parameterDetails = new KcCronTriggerParameterDetails();
        parameterDetails.setParameterNamespace(this.getParameterNamespace());
        parameterDetails.setParameterComponent(this.getParameterComponent());
        parameterDetails.setCronExpressionParameterName(this.getCronExpressionParameterName());
        parameterDetails.setTriggerEnabledParameterName(this.getTriggerEnabledParameterName());
        parameterDetails.setStartTimeParameterName(this.getStartTimeParameterName());
        parameterDetails.setMisfireSkipParameterName(this.getMisfireSkipParameterName());
        this.getJobDataMap().put(PARAMETER_DETAILS_KEY, (Object)parameterDetails);
    }

    protected String getSystemCronExpression() {
        if (StringUtils.isNotBlank((CharSequence)this.cronExpressionParameterName) && this.getParameterService().parameterExists(this.parameterNamespace, this.parameterComponent, this.cronExpressionParameterName).booleanValue()) {
            String param = this.getParameterService().getParameterValueAsString(this.parameterNamespace, this.parameterComponent, this.cronExpressionParameterName);
            if (param != null) {
                return param;
            }
            LOG.warn("parameter [" + this.cronExpressionParameterName + "] not found using default value of [" + this.defaultCronExpression + "].");
        }
        return this.defaultCronExpression;
    }

    protected Date getCronStartTime() {
        return this.kcCronTriggerService.getCronStartTime(this.isTriggerEnabled(), this.parameterNamespace, this.parameterComponent, this.startTimeParameterName);
    }

    protected boolean isTriggerEnabled() {
        if (StringUtils.isNotBlank((CharSequence)this.triggerEnabledParameterName)) {
            if (this.getParameterService().parameterExists(this.parameterNamespace, this.parameterComponent, this.triggerEnabledParameterName).booleanValue()) {
                return this.getParameterService().getParameterValueAsBoolean(this.parameterNamespace, this.parameterComponent, this.triggerEnabledParameterName);
            }
            return false;
        }
        return true;
    }

    protected int getMisfireInstruction() {
        boolean skipMisfire = false;
        if (StringUtils.isNotBlank((CharSequence)this.misfireSkipParameterName) && this.getParameterService().parameterExists(this.parameterNamespace, this.parameterComponent, this.misfireSkipParameterName).booleanValue()) {
            skipMisfire = this.getParameterService().getParameterValueAsBoolean(this.parameterNamespace, this.parameterComponent, this.misfireSkipParameterName);
        }
        return this.kcCronTriggerService.getMisfireInstruction(skipMisfire);
    }

    public String getDefaultCronExpression() {
        return this.defaultCronExpression;
    }

    public void setDefaultCronExpression(String defaultCronExpression) {
        this.defaultCronExpression = defaultCronExpression;
    }

    public String getCronExpressionParameterName() {
        return this.cronExpressionParameterName;
    }

    public void setCronExpressionParameterName(String cronExpressionParameterName) {
        this.cronExpressionParameterName = cronExpressionParameterName;
    }

    public String getTriggerEnabledParameterName() {
        return this.triggerEnabledParameterName;
    }

    public void setTriggerEnabledParameterName(String triggerEnabledParameterName) {
        this.triggerEnabledParameterName = triggerEnabledParameterName;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public String getStartTimeParameterName() {
        return this.startTimeParameterName;
    }

    public void setStartTimeParameterName(String startTimeParameterName) {
        this.startTimeParameterName = startTimeParameterName;
    }

    protected KcCronTriggerService getKcCronTriggerService() {
        return this.kcCronTriggerService;
    }

    public void setKcCronTriggerService(KcCronTriggerService kcCronTriggerService) {
        this.kcCronTriggerService = kcCronTriggerService;
    }

    public String getParameterNamespace() {
        return this.parameterNamespace;
    }

    public void setParameterNamespace(String parameterNamespace) {
        this.parameterNamespace = parameterNamespace;
    }

    public String getParameterComponent() {
        return this.parameterComponent;
    }

    public void setParameterComponent(String parameterComponent) {
        this.parameterComponent = parameterComponent;
    }

    public String getMisfireSkipParameterName() {
        return this.misfireSkipParameterName;
    }

    public void setMisfireSkipParameterName(String misfireSkipParameterName) {
        this.misfireSkipParameterName = misfireSkipParameterName;
    }
}

