/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.SentReportNotification;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.lookup.LookupController;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/lookup"})
public class SentReportNotificationLookupController
extends LookupController {
    public static final String DELETE_SENT_REPORT_NOTIFICATION_PERM = AwardPermissionConstants.MODIFY_AWARD_REPORT_TRACKING.getAwardPermission();
    private static final String AUTH_EXCEPTION_DELETE_ACITON = "Delete";
    private static final String AUTH_EXCEPTION_NOTIFICATIONS_TYPE = "Report Tracking Notifications";
    private BusinessObjectService businessObjectService;
    private GlobalVariableService globalVariableService;
    private UnitAuthorizationService unitAuthorizationService;

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=deleteSelectedReportNotifications"})
    public ModelAndView deleteSelectedReportNotifications(LookupForm lookupForm) {
        ModelAndView modelAndView = this.getModelAndViewService().getModelAndView((UifFormBase)lookupForm);
        if (!this.isAuthorizedToDeleteNotifications()) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), AUTH_EXCEPTION_DELETE_ACITON, AUTH_EXCEPTION_NOTIFICATIONS_TYPE);
        }
        if (lookupForm.getLookupResults().stream().allMatch(result -> result instanceof SentReportNotification) && lookupForm.getSelectedCollectionLines().containsKey("lookupResults")) {
            List notificationsToDelete = ((Set)lookupForm.getSelectedCollectionLines().get("lookupResults")).stream().map(selectedLine -> ObjectPropertyUtils.getPropertyValue((Object)lookupForm, (String)selectedLine)).collect(Collectors.toList());
            this.getBusinessObjectService().delete(notificationsToDelete);
            lookupForm.getLookupResults().removeAll(notificationsToDelete);
            lookupForm.getSelectedCollectionLines().clear();
        }
        return modelAndView;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=deleteAllReportNotifications"})
    public ModelAndView deleteAllReportNotifications(LookupForm lookupForm) {
        ModelAndView modelAndView = this.getModelAndViewService().getModelAndView((UifFormBase)lookupForm);
        if (!this.isAuthorizedToDeleteNotifications()) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), AUTH_EXCEPTION_DELETE_ACITON, AUTH_EXCEPTION_NOTIFICATIONS_TYPE);
        }
        Collection searchResults = lookupForm.getLookupResults();
        if (searchResults != null && searchResults.stream().allMatch(result -> result instanceof SentReportNotification)) {
            this.getBusinessObjectService().delete((Object)searchResults);
            lookupForm.setLookupResults(Collections.emptyList());
        }
        return modelAndView;
    }

    private boolean isAuthorizedToDeleteNotifications() {
        String principalId = this.getGlobalVariableService().getUserSession().getPrincipalId();
        return this.getUnitAuthorizationService().hasPermission(principalId, "KC-AWARD", DELETE_SENT_REPORT_NOTIFICATION_PERM);
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    private UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }
}

