/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.generate;

import java.util.Objects;

/**
 * 
 * This class holds information about form generation.  For example: what forms are supported,
 * the name of the generator, the location of the stylesheet.
 */
public final class FormMappingInfo {
    private String nameSpace;
    private String formName;

    public FormMappingInfo(String nameSpace, String formName) {
        this.nameSpace = nameSpace;
        this.formName = formName;
    }

    public String getNameSpace() {
        return nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FormMappingInfo that = (FormMappingInfo) o;
        return Objects.equals(nameSpace, that.nameSpace) && Objects.equals(formName, that.formName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameSpace, formName);
    }

    @Override
    public String toString() {
        return "FormMappingInfo{" +
                "nameSpace='" + nameSpace + '\'' +
                ", formName='" + formName + '\'' +
                '}';
    }
}
