/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

import java.util.ArrayList;
import java.util.List;

public final class S2SBudgetDto {

    private List<S2SBudgetPeriodDto> budgetPeriods;
    private ScaleTwoDecimal cumTotalFundsForSrPersonnel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalFundsForOtherPersonnel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalFundsForPersonnel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumNumOtherPersonnel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumEquipmentFunds = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTravel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumDomesticTravel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumForeignTravel = ScaleTwoDecimal.ZERO;

    private List<S2SOtherDirectCostInfoDto> otherDirectCosts = new ArrayList<>();

    private ScaleTwoDecimal partStipendCost = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partTravelCost = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partOtherCost = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partSubsistence = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partTuition = ScaleTwoDecimal.ZERO;
    private int participantCount;

    private ScaleTwoDecimal cumTotalDirectCosts = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalIndirectCosts = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalCosts = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumFee = ScaleTwoDecimal.ZERO;


    private ScaleTwoDecimal cumTotalCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalNonFundsForSrPersonnel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalNonFundsForOtherPersonnel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalNonFundsForPersonnel = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTravelNonFund = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumDomesticTravelNonFund = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumForeignTravelNonFund = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partStipendCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partTravelCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partSubsistenceCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partTuitionCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal partOtherCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumEquipmentNonFunds = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalDirectCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumTotalIndirectCostSharing = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumProjectIncome = ScaleTwoDecimal.ZERO;

    public List<S2SBudgetPeriodDto> getBudgetPeriods() {
        return budgetPeriods;
    }

    public void setBudgetPeriods(List<S2SBudgetPeriodDto> budgetPeriods) {
        this.budgetPeriods = budgetPeriods;
    }

    public ScaleTwoDecimal getCumTotalFundsForSrPersonnel() {
        return cumTotalFundsForSrPersonnel;
    }

    public void setCumTotalFundsForSrPersonnel(ScaleTwoDecimal cumTotalFundsForSrPersonnel) {
        this.cumTotalFundsForSrPersonnel = cumTotalFundsForSrPersonnel;
    }

    public ScaleTwoDecimal getCumTotalFundsForOtherPersonnel() {
        return cumTotalFundsForOtherPersonnel;
    }

    public void setCumTotalFundsForOtherPersonnel(ScaleTwoDecimal cumTotalFundsForOtherPersonnel) {
        this.cumTotalFundsForOtherPersonnel = cumTotalFundsForOtherPersonnel;
    }

    public ScaleTwoDecimal getCumTotalFundsForPersonnel() {
        return cumTotalFundsForPersonnel;
    }

    public void setCumTotalFundsForPersonnel(ScaleTwoDecimal cumTotalFundsForPersonnel) {
        this.cumTotalFundsForPersonnel = cumTotalFundsForPersonnel;
    }

    public ScaleTwoDecimal getCumNumOtherPersonnel() {
        return cumNumOtherPersonnel;
    }

    public void setCumNumOtherPersonnel(ScaleTwoDecimal cumNumOtherPersonnel) {
        this.cumNumOtherPersonnel = cumNumOtherPersonnel;
    }

    public ScaleTwoDecimal getCumEquipmentFunds() {
        return cumEquipmentFunds;
    }

    public void setCumEquipmentFunds(ScaleTwoDecimal cumEquipmentFunds) {
        this.cumEquipmentFunds = cumEquipmentFunds;
    }

    public ScaleTwoDecimal getCumTravel() {
        return cumTravel;
    }

    public void setCumTravel(ScaleTwoDecimal cumTravel) {
        this.cumTravel = cumTravel;
    }

    public ScaleTwoDecimal getCumDomesticTravel() {
        return cumDomesticTravel;
    }

    public void setCumDomesticTravel(ScaleTwoDecimal cumDomesticTravel) {
        this.cumDomesticTravel = cumDomesticTravel;
    }

    public ScaleTwoDecimal getCumForeignTravel() {
        return cumForeignTravel;
    }

    public void setCumForeignTravel(ScaleTwoDecimal cumForeignTravel) {
        this.cumForeignTravel = cumForeignTravel;
    }

    public ScaleTwoDecimal getPartOtherCost() {
        return partOtherCost;
    }

    public void setPartOtherCost(ScaleTwoDecimal partOtherCost) {
        this.partOtherCost = partOtherCost;
    }

    public int getParticipantCount() {
        return participantCount;
    }

    public void setParticipantCount(int participantCount) {
        this.participantCount = participantCount;
    }

    public ScaleTwoDecimal getPartTravelCost() {
        return partTravelCost;
    }

    public void setPartTravelCost(ScaleTwoDecimal partTravelCost) {
        this.partTravelCost = partTravelCost;
    }

    public ScaleTwoDecimal getPartStipendCost() {
        return partStipendCost;
    }

    public void setPartStipendCost(ScaleTwoDecimal partStipendCost) {
        this.partStipendCost = partStipendCost;
    }

    public List<S2SOtherDirectCostInfoDto> getOtherDirectCosts() {
        return otherDirectCosts;
    }

    public void setOtherDirectCosts(List<S2SOtherDirectCostInfoDto> otherDirectCosts) {
        this.otherDirectCosts = otherDirectCosts;
    }

    public ScaleTwoDecimal getCumTotalDirectCosts() {
        return cumTotalDirectCosts;
    }

    public void setCumTotalDirectCosts(ScaleTwoDecimal cumTotalDirectCosts) {
        this.cumTotalDirectCosts = cumTotalDirectCosts;
    }

    public ScaleTwoDecimal getCumTotalIndirectCosts() {
        return cumTotalIndirectCosts;
    }

    public void setCumTotalIndirectCosts(ScaleTwoDecimal cumTotalIndirectCosts) {
        this.cumTotalIndirectCosts = cumTotalIndirectCosts;
    }

    public ScaleTwoDecimal getCumTotalCosts() {
        return cumTotalCosts;
    }

    public void setCumTotalCosts(ScaleTwoDecimal cumTotalCosts) {
        this.cumTotalCosts = cumTotalCosts;
    }

    public ScaleTwoDecimal getCumFee() {
        return cumFee;
    }

    public void setCumFee(ScaleTwoDecimal cumFee) {
        this.cumFee = cumFee;
    }


    public ScaleTwoDecimal getCumTotalCostSharing() {
        return cumTotalCostSharing;
    }

    public void setCumTotalCostSharing(ScaleTwoDecimal cumTotalCostSharing) {
        this.cumTotalCostSharing = cumTotalCostSharing;
    }

    public ScaleTwoDecimal getCumTotalNonFundsForSrPersonnel() {
        return cumTotalNonFundsForSrPersonnel;
    }

    public void setCumTotalNonFundsForSrPersonnel(ScaleTwoDecimal cumTotalNonFundsForSrPersonnel) {
        this.cumTotalNonFundsForSrPersonnel = cumTotalNonFundsForSrPersonnel;
    }

    public ScaleTwoDecimal getCumTotalNonFundsForOtherPersonnel() {
        return cumTotalNonFundsForOtherPersonnel;
    }

    public void setCumTotalNonFundsForOtherPersonnel(ScaleTwoDecimal cumTotalNonFundsForOtherPersonnel) {
        this.cumTotalNonFundsForOtherPersonnel = cumTotalNonFundsForOtherPersonnel;
    }

    public ScaleTwoDecimal getCumTotalNonFundsForPersonnel() {
        return cumTotalNonFundsForPersonnel;
    }

    public void setCumTotalNonFundsForPersonnel(ScaleTwoDecimal cumTotalNonFundsForPersonnel) {
        this.cumTotalNonFundsForPersonnel = cumTotalNonFundsForPersonnel;
    }

    public ScaleTwoDecimal getCumTravelNonFund() {
        return cumTravelNonFund;
    }

    public void setCumTravelNonFund(ScaleTwoDecimal cumTravelNonFund) {
        this.cumTravelNonFund = cumTravelNonFund;
    }

    public ScaleTwoDecimal getCumDomesticTravelNonFund() {
        return cumDomesticTravelNonFund;
    }

    public void setCumDomesticTravelNonFund(ScaleTwoDecimal cumDomesticTravelNonFund) {
        this.cumDomesticTravelNonFund = cumDomesticTravelNonFund;
    }

    public ScaleTwoDecimal getCumForeignTravelNonFund() {
        return cumForeignTravelNonFund;
    }

    public void setCumForeignTravelNonFund(ScaleTwoDecimal cumForeignTravelNonFund) {
        this.cumForeignTravelNonFund = cumForeignTravelNonFund;
    }

    public ScaleTwoDecimal getPartStipendCostSharing() {
        return partStipendCostSharing;
    }

    public void setPartStipendCostSharing(ScaleTwoDecimal partStipendCostSharing) {
        this.partStipendCostSharing = partStipendCostSharing;
    }

    public ScaleTwoDecimal getPartTravelCostSharing() {
        return partTravelCostSharing;
    }

    public void setPartTravelCostSharing(ScaleTwoDecimal partTravelCostSharing) {
        this.partTravelCostSharing = partTravelCostSharing;
    }

    public ScaleTwoDecimal getPartOtherCostSharing() {
        return partOtherCostSharing;
    }

    public void setPartOtherCostSharing(ScaleTwoDecimal partOtherCostSharing) {
        this.partOtherCostSharing = partOtherCostSharing;
    }

    public ScaleTwoDecimal getCumEquipmentNonFunds() {
        return cumEquipmentNonFunds;
    }

    public void setCumEquipmentNonFunds(ScaleTwoDecimal cumEquipmentNonFunds) {
        this.cumEquipmentNonFunds = cumEquipmentNonFunds;
    }

    public ScaleTwoDecimal getCumTotalDirectCostSharing() {
        return cumTotalDirectCostSharing;
    }

    public void setCumTotalDirectCostSharing(ScaleTwoDecimal cumTotalDirectCostSharing) {
        this.cumTotalDirectCostSharing = cumTotalDirectCostSharing;
    }

    public ScaleTwoDecimal getCumTotalIndirectCostSharing() {
        return cumTotalIndirectCostSharing;
    }

    public void setCumTotalIndirectCostSharing(ScaleTwoDecimal cumTotalIndirectCostSharing) {
        this.cumTotalIndirectCostSharing = cumTotalIndirectCostSharing;
    }

    public ScaleTwoDecimal getPartSubsistence() {
        return partSubsistence;
    }

    public void setPartSubsistence(ScaleTwoDecimal partSubsistence) {
        this.partSubsistence = partSubsistence;
    }

    public ScaleTwoDecimal getPartTuition() {
        return partTuition;
    }

    public void setPartTuition(ScaleTwoDecimal partTuition) {
        this.partTuition = partTuition;
    }

    public ScaleTwoDecimal getPartSubsistenceCostSharing() {
        return partSubsistenceCostSharing;
    }

    public void setPartSubsistenceCostSharing(ScaleTwoDecimal partSubsistenceCostSharing) {
        this.partSubsistenceCostSharing = partSubsistenceCostSharing;
    }

    public ScaleTwoDecimal getPartTuitionCostSharing() {
        return partTuitionCostSharing;
    }

    public void setPartTuitionCostSharing(ScaleTwoDecimal partTuitionCostSharing) {
        this.partTuitionCostSharing = partTuitionCostSharing;
    }

    public ScaleTwoDecimal getCumProjectIncome() {
        return cumProjectIncome;
    }

    public void setCumProjectIncome(ScaleTwoDecimal cumProjectIncome) {
        this.cumProjectIncome = cumProjectIncome;
    }
}
