/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

import java.util.ArrayList;
import java.util.List;

public final class S2SIndirectCostDto {

    private List<S2SIndirectCostDetailsDto> indirectCostDetails;
    private ScaleTwoDecimal totalIndirectCosts;
    private ScaleTwoDecimal totalIndirectCostSharing;

    public S2SIndirectCostDto() {
        indirectCostDetails = new ArrayList<>();
    }

    public List<S2SIndirectCostDetailsDto> getIndirectCostDetails() {
        return indirectCostDetails;
    }

    public void setIndirectCostDetails(List<S2SIndirectCostDetailsDto> indirectCostDetails) {
        this.indirectCostDetails = indirectCostDetails;
    }

    public ScaleTwoDecimal getTotalIndirectCosts() {
        return totalIndirectCosts;
    }

    public void setTotalIndirectCosts(ScaleTwoDecimal totalIndirectCosts) {
        this.totalIndirectCosts = totalIndirectCosts;
    }

    public ScaleTwoDecimal getTotalIndirectCostSharing() {
        return totalIndirectCostSharing;
    }

    public void setTotalIndirectCostSharing(ScaleTwoDecimal totalIndirectCostSharing) {
        this.totalIndirectCostSharing = totalIndirectCostSharing;
    }
}
