/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.generate;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

/**
 * 
 * This class is meant to store and retrieve attachments and its associated properties
 */
public final class AttachmentData {
    private final String fileDataId;
    private final String fileName;
    private final String contentId;
    private final byte[] content;
    private final String contentType;
    private final String hashAlgorithm;
    private final String hashValue;
    private final String uploadUser;
    private final Date uploadTimestamp;

    public AttachmentData(String fileDataId, String fileName, String contentId, byte[] content, String contentType, String hashAlgorithm, String hashValue, String uploadUser, Date uploadTimestamp) {
        this.fileDataId = fileDataId;
        this.fileName = fileName;
        this.contentId = contentId;
        this.content = content;
        this.contentType = contentType;
        this.hashAlgorithm = hashAlgorithm;
        this.hashValue = hashValue;
        this.uploadUser = uploadUser;
        this.uploadTimestamp = uploadTimestamp;

//        This can be null in cases where the item comes from attachments and not the database.
//        if (StringUtils.isBlank(fileDataId)) {
//            throw new IllegalArgumentException("fileDataId is blank");
//        }

        if (StringUtils.isBlank(fileName)) {
            throw new IllegalArgumentException("fileName is blank");
        }

        if (StringUtils.isBlank(contentId)) {
            throw new IllegalArgumentException("contentId is blank");
        }

        if (content == null || content.length == 0) {
            throw new IllegalArgumentException("content is null or empty");
        }

        if (StringUtils.isBlank(contentType)) {
            throw new IllegalArgumentException("contentType is blank");
        }

        if (StringUtils.isBlank(hashAlgorithm)) {
            throw new IllegalArgumentException("hashAlgorithm is blank");
        }

        if (StringUtils.isBlank(hashValue)) {
            throw new IllegalArgumentException("hashValue is blank");
        }
    }

    public AttachmentData(AttachmentData attachment) {
        this(attachment.fileDataId, attachment.fileName, attachment.contentId, attachment.content, attachment.contentType, attachment.hashAlgorithm, attachment.hashValue, attachment.uploadUser, attachment.uploadTimestamp);
    }

    public String getFileDataId() {
        return fileDataId;
    }

    public String getFileName() {
        return fileName;
    }

    public String getContentId() {
        return contentId;
    }

    public byte[] getContent() {
        return content;
    }

    public String getContentType() {
        return contentType;
    }

    public String getHashValue() {
        return hashValue;
    }

    public String getHashAlgorithm() {
        return hashAlgorithm;
    }

    public String getUploadUser() {
        return uploadUser;
    }

    public Date getUploadTimestamp() {
        return uploadTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AttachmentData that)) return false;
        return Objects.equals(fileDataId, that.fileDataId) && Objects.equals(fileName, that.fileName) && Objects.equals(contentId, that.contentId) && Objects.deepEquals(content, that.content) && Objects.equals(contentType, that.contentType) && Objects.equals(hashAlgorithm, that.hashAlgorithm) && Objects.equals(hashValue, that.hashValue) && Objects.equals(uploadUser, that.uploadUser) && Objects.equals(uploadTimestamp, that.uploadTimestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fileDataId, fileName, contentId, Arrays.hashCode(content), contentType, hashAlgorithm, hashValue, uploadUser, uploadTimestamp);
    }

    private final static class StringUtils {
        private StringUtils() {
            throw new UnsupportedOperationException("do not call");
        }

        public static boolean isBlank(final CharSequence cs) {
            final int strLen = length(cs);
            if (strLen == 0) {
                return true;
            }
            for (int i = 0; i < strLen; i++) {
                if (!Character.isWhitespace(cs.charAt(i))) {
                    return false;
                }
            }
            return true;
        }

        private static int length(final CharSequence cs) {
            return cs == null ? 0 : cs.length();
        }
    }
}
