/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.location;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.country.CountryContract;
import org.kuali.coeus.common.api.country.KcCountryService;
import org.kuali.coeus.common.api.state.KcStateService;
import org.kuali.coeus.common.api.state.StateContract;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component("s2SLocationService")
public class S2SLocationServiceImpl implements S2SLocationService {

    @Autowired
    @Qualifier("kcCountryService")
    private KcCountryService kcCountryService;

    @Autowired
    @Qualifier("kcStateService")
    private KcStateService kcStateService;

    /**
     * {@inheritDoc}
     */
    @Override
    public CountryContract getCountryFromCode(String countryCode) {
        if(StringUtils.isBlank(countryCode)) return null;
        CountryContract country = getKcCountryService().getCountryByAlternateCode(countryCode);
        if(country==null){
            country = getKcCountryService().getCountry(countryCode);
        }
        return country;
    }



    /**
     * {@inheritDoc}
     */
    @Override
    public StateContract getStateFromCode(String countryAlternateCode, String stateCode) {
        CountryContract country = getCountryFromCode(countryAlternateCode);

        return getKcStateService().getState(country.getCode(), stateCode);
    }

    public KcStateService getKcStateService() {
        return kcStateService;
    }

    public void setKcStateService(KcStateService kcStateService) {
        this.kcStateService = kcStateService;
    }

    public KcCountryService getKcCountryService() {
        return kcCountryService;
    }

    public void setKcCountryService(KcCountryService kcCountryService) {
        this.kcCountryService = kcCountryService;
    }
}
